package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.*;
import com.jurismarches.vradi.ui.editors.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.OneClicListSelectionModel;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class OfferEditUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_VALIDE = "valide";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.OfferEditUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table actionPanel;
    protected javax.swing.JButton addFile;
    protected javax.swing.JButton annuler;
    protected javax.swing.JPanel content;
    protected com.jurismarches.vradi.ui.editors.StringEditor countryEditor;
    protected com.jurismarches.vradi.entities.Form data;
    protected com.jurismarches.vradi.ui.editors.DateTimeEditor datePeremeptionEditor;
    protected com.jurismarches.vradi.ui.editors.DateTimeEditor datePubEditor;
    protected com.jurismarches.vradi.ui.editors.StringEditor departmentEditor;
    protected com.jurismarches.vradi.ui.editors.TextEditor descriptionEditor;
    protected com.jurismarches.vradi.ui.editors.StringEditor entityEditor;
    protected jaxx.runtime.validator.swing.SwingValidatorMessageTableModel errorEditorTable;
    protected javax.swing.JList fileList;
    protected jaxx.runtime.swing.Table formPanel;
    protected javax.swing.JScrollPane formScrollPane;
    protected javax.swing.JSplitPane formSplitPane;
    protected com.jurismarches.vradi.ui.editors.IdEditor idEditor;
    protected jaxx.runtime.swing.HBox lastModified;
    protected com.jurismarches.vradi.ui.editors.StringEditor objetEditor;
    protected javax.swing.JSplitPane offerEdit;
    protected OfferEditUI offerEditUI = this;
    protected javax.swing.JList propositionList;
    protected javax.swing.DefaultListModel propositionListModel;
    protected javax.swing.JButton removeFile;
    protected com.jurismarches.vradi.ui.editors.StringEditor sourceTextEditor;
    protected com.jurismarches.vradi.ui.editors.UrlEditor sourceURLEditor;
    protected javax.swing.JPanel statusButtonPanel;
    protected javax.swing.JButton test;
    protected javax.swing.JPanel thesaurus;
    protected java.lang.Boolean valide;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private jaxx.runtime.swing.Spacer $Spacer0;
    private javax.swing.JSplitPane $JSplitPane0;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JScrollPane $JScrollPane0;
    private jaxx.runtime.swing.Table $Table2;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane1;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public OfferEditHandler getHandler() {
        return getContextValue(OfferEditHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        if(data != null && data.getExtensions().contains(ModificationTag.MODIFICATION_TAG)) {
            Object date = data.getField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIED);
            Object user = data.getField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIER);
            if(date != null && user != null) {
                String labelText = String.format(_("vradi.entity.lastModified.date.user"), date, user);
                lastModified.add(new JLabel(labelText));
            }
        }
        setContextValue(errorEditorTable, "errorEditorTable");
        formScrollPane.getVerticalScrollBar().setBlockIncrement(100);
        formScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        propositionList.setCellRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        OneClicListSelectionModel selectModel = new OneClicListSelectionModel(propositionList.getSelectionModel(), propositionList.getModel());
        propositionList.setSelectionModel(selectModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferEditUI() {
        $initialize();
    }

    public OfferEditUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addFile(java.awt.event.ActionEvent event) {
        getHandler().addFile(this);
    }

    public void doActionPerformed__on__removeFile(java.awt.event.ActionEvent event) {
        getHandler().removeFile(this);
    }

    public void doActionPerformed__on__test(java.awt.event.ActionEvent event) {
        getHandler().test(this, data);
    }

    public void doTableChanged__on__errorEditorTable(javax.swing.event.TableModelEvent event) {
        setValide(errorEditorTable.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getActionPanel() {
        return actionPanel;
    }

    public javax.swing.JButton getAddFile() {
        return addFile;
    }

    public javax.swing.JButton getAnnuler() {
        return annuler;
    }

    public javax.swing.JPanel getContent() {
        return content;
    }

    public com.jurismarches.vradi.ui.editors.StringEditor getCountryEditor() {
        return countryEditor;
    }

    public com.jurismarches.vradi.entities.Form getData() {
        return data;
    }

    public com.jurismarches.vradi.ui.editors.DateTimeEditor getDatePeremeptionEditor() {
        return datePeremeptionEditor;
    }

    public com.jurismarches.vradi.ui.editors.DateTimeEditor getDatePubEditor() {
        return datePubEditor;
    }

    public com.jurismarches.vradi.ui.editors.StringEditor getDepartmentEditor() {
        return departmentEditor;
    }

    public com.jurismarches.vradi.ui.editors.TextEditor getDescriptionEditor() {
        return descriptionEditor;
    }

    public com.jurismarches.vradi.ui.editors.StringEditor getEntityEditor() {
        return entityEditor;
    }

    public jaxx.runtime.validator.swing.SwingValidatorMessageTableModel getErrorEditorTable() {
        return errorEditorTable;
    }

    public javax.swing.JList getFileList() {
        return fileList;
    }

    public jaxx.runtime.swing.Table getFormPanel() {
        return formPanel;
    }

    public javax.swing.JScrollPane getFormScrollPane() {
        return formScrollPane;
    }

    public javax.swing.JSplitPane getFormSplitPane() {
        return formSplitPane;
    }

    public com.jurismarches.vradi.ui.editors.IdEditor getIdEditor() {
        return idEditor;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public com.jurismarches.vradi.ui.editors.StringEditor getObjetEditor() {
        return objetEditor;
    }

    public javax.swing.JSplitPane getOfferEdit() {
        return offerEdit;
    }

    public javax.swing.JList getPropositionList() {
        return propositionList;
    }

    public javax.swing.DefaultListModel getPropositionListModel() {
        return propositionListModel;
    }

    public javax.swing.JButton getRemoveFile() {
        return removeFile;
    }

    public com.jurismarches.vradi.ui.editors.StringEditor getSourceTextEditor() {
        return sourceTextEditor;
    }

    public com.jurismarches.vradi.ui.editors.UrlEditor getSourceURLEditor() {
        return sourceURLEditor;
    }

    public javax.swing.JPanel getStatusButtonPanel() {
        return statusButtonPanel;
    }

    public javax.swing.JButton getTest() {
        return test;
    }

    public javax.swing.JPanel getThesaurus() {
        return thesaurus;
    }

    public java.lang.Boolean getValide() {
        return valide;
    }

    public java.lang.Boolean isValide() {
        return valide !=null && valide;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(com.jurismarches.vradi.entities.Form newValue) {
        com.jurismarches.vradi.entities.Form oldValue = this.data;
        this.data = newValue;
        firePropertyChange(PROPERTY_DATA, oldValue, newValue);
    }

    public void setValide(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.valide;
        this.valide = newValue;
        firePropertyChange(PROPERTY_VALIDE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected jaxx.runtime.swing.Spacer get$Spacer0() {
        return $Spacer0;
    }

    protected javax.swing.JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(lastModified, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        actionPanel.add(statusButtonPanel, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        actionPanel.add(annuler, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        actionPanel.add(test, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToFormPanel() {
        if (!allComponentsCreated) {
            return;
        }
        formPanel.add(formScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToFormScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        formScrollPane.getViewport().add($Table0);
    }

    protected void addChildrenToFormSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        formSplitPane.add(formPanel, JSplitPane.LEFT);
        formSplitPane.add($JSplitPane0, JSplitPane.RIGHT);
    }

    protected void addChildrenToOfferEdit() {
        if (!allComponentsCreated) {
            return;
        }
        offerEdit.add(formSplitPane, JSplitPane.LEFT);
        offerEdit.add(thesaurus, JSplitPane.RIGHT);
    }

    protected void addChildrenToOfferEditUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(offerEdit, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToStatusButtonPanel() {
        if (!allComponentsCreated) {
            return;
        }
        statusButtonPanel.add($JLabel1);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new jaxx.runtime.swing.Table());
        actionPanel.setName("actionPanel");
    }

    protected void createAddFile() {
        $objectMap.put("addFile", addFile = new javax.swing.JButton());
        addFile.setName("addFile");
        addFile.setText(_("vradi.action.addFile"));
        addFile.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addFile"));
    }

    protected void createAnnuler() {
        $objectMap.put("annuler", annuler = new javax.swing.JButton());
        annuler.setName("annuler");
        annuler.setText(_("vradi.action.cancel"));
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        content.setName("content");
        content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
    }

    protected void createCountryEditor() {
        $objectMap.put("countryEditor", countryEditor = new com.jurismarches.vradi.ui.editors.StringEditor());
        countryEditor.setName("countryEditor");
        countryEditor.setFieldName("Form.FIELD_COUNTRY");
    }

    protected void createData() {
        $objectMap.put("data", data = getContextValue(Form.class));
    }

    protected void createDatePeremeptionEditor() {
        $objectMap.put("datePeremeptionEditor", datePeremeptionEditor = new com.jurismarches.vradi.ui.editors.DateTimeEditor());
        datePeremeptionEditor.setName("datePeremeptionEditor");
        datePeremeptionEditor.setFieldName("Form.FIELD_DATEPEREMPTION");
    }

    protected void createDatePubEditor() {
        $objectMap.put("datePubEditor", datePubEditor = new com.jurismarches.vradi.ui.editors.DateTimeEditor());
        datePubEditor.setName("datePubEditor");
        datePubEditor.setFieldName("Form.FIELD_DATEPUB");
    }

    protected void createDepartmentEditor() {
        $objectMap.put("departmentEditor", departmentEditor = new com.jurismarches.vradi.ui.editors.StringEditor());
        departmentEditor.setName("departmentEditor");
        departmentEditor.setFieldName("Form.FIELD_DEPARTMENT");
    }

    protected void createDescriptionEditor() {
        $objectMap.put("descriptionEditor", descriptionEditor = new com.jurismarches.vradi.ui.editors.TextEditor());
        descriptionEditor.setName("descriptionEditor");
        descriptionEditor.setFieldName("Form.FIELD_DESCRIPTION");
    }

    protected void createEntityEditor() {
        $objectMap.put("entityEditor", entityEditor = new com.jurismarches.vradi.ui.editors.StringEditor());
        entityEditor.setName("entityEditor");
        entityEditor.setFieldName("Form.FIELD_ENTITY");
    }

    protected void createErrorEditorTable() {
        $objectMap.put("errorEditorTable", errorEditorTable = new jaxx.runtime.validator.swing.SwingValidatorMessageTableModel());
        errorEditorTable.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorEditorTable"));
    }

    protected void createFileList() {
        $objectMap.put("fileList", fileList = new javax.swing.JList());
        fileList.setName("fileList");
    }

    protected void createFormPanel() {
        $objectMap.put("formPanel", formPanel = new jaxx.runtime.swing.Table());
        formPanel.setName("formPanel");
    }

    protected void createFormScrollPane() {
        $objectMap.put("formScrollPane", formScrollPane = new javax.swing.JScrollPane());
        formScrollPane.setName("formScrollPane");
    }

    protected void createFormSplitPane() {
        $objectMap.put("formSplitPane", formSplitPane = new javax.swing.JSplitPane());
        formSplitPane.setName("formSplitPane");
        formSplitPane.setDividerLocation(750);
        formSplitPane.setOneTouchExpandable(true);
        formSplitPane.setResizeWeight(0.8);
        formSplitPane.setContinuousLayout(true);
        formSplitPane.setDividerSize(12);
    }

    protected void createIdEditor() {
        $objectMap.put("idEditor", idEditor = new com.jurismarches.vradi.ui.editors.IdEditor());
        idEditor.setName("idEditor");
        idEditor.setFieldName("Form.FIELD_ID");
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createObjetEditor() {
        $objectMap.put("objetEditor", objetEditor = new com.jurismarches.vradi.ui.editors.StringEditor());
        objetEditor.setName("objetEditor");
        objetEditor.setFieldName("Form.FIELD_OBJET");
    }

    protected void createOfferEdit() {
        $objectMap.put("offerEdit", offerEdit = new javax.swing.JSplitPane());
        offerEdit.setName("offerEdit");
        offerEdit.setDividerLocation(400);
        offerEdit.setOneTouchExpandable(true);
        offerEdit.setContinuousLayout(true);
        offerEdit.setDividerSize(12);
    }

    protected void createPropositionList() {
        $objectMap.put("propositionList", propositionList = new javax.swing.JList());
        propositionList.setName("propositionList");
    }

    protected void createPropositionListModel() {
        $objectMap.put("propositionListModel", propositionListModel = new javax.swing.DefaultListModel());
    }

    protected void createRemoveFile() {
        $objectMap.put("removeFile", removeFile = new javax.swing.JButton());
        removeFile.setName("removeFile");
        removeFile.setText(_("vradi.action.removeFile"));
        removeFile.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeFile"));
    }

    protected void createSourceTextEditor() {
        $objectMap.put("sourceTextEditor", sourceTextEditor = new com.jurismarches.vradi.ui.editors.StringEditor());
        sourceTextEditor.setName("sourceTextEditor");
        sourceTextEditor.setFieldName("Form.FIELD_SOURCETEXT");
    }

    protected void createSourceURLEditor() {
        $objectMap.put("sourceURLEditor", sourceURLEditor = new com.jurismarches.vradi.ui.editors.UrlEditor());
        sourceURLEditor.setName("sourceURLEditor");
        sourceURLEditor.setFieldName("Form.FIELD_SOURCEURL");
    }

    protected void createStatusButtonPanel() {
        $objectMap.put("statusButtonPanel", statusButtonPanel = new javax.swing.JPanel());
        statusButtonPanel.setName("statusButtonPanel");
        statusButtonPanel.setLayout(new FlowLayout(FlowLayout.LEADING));
    }

    protected void createTest() {
        $objectMap.put("test", test = new javax.swing.JButton());
        test.setName("test");
        test.setText(_("vradi.action.test"));
        test.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__test"));
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new javax.swing.JPanel());
        thesaurus.setName("thesaurus");
        thesaurus.setLayout(new BoxLayout(thesaurus, BoxLayout.X_AXIS));
    }

    protected void createValide() {
        $objectMap.put("valide", valide = true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToOfferEditUI();
        addChildrenToOfferEdit();
        addChildrenToFormSplitPane();
        addChildrenToFormPanel();
        addChildrenToFormScrollPane();
        // inline complete setup of $Table0
        $Table0.add(objetEditor, new GridBagConstraints(0, 0, 6, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(idEditor, new GridBagConstraints(0, 1, 2, 1, 0.3, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(sourceTextEditor, new GridBagConstraints(2, 1, 2, 1, 0.3, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(sourceURLEditor, new GridBagConstraints(4, 1, 2, 1, 0.3, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(entityEditor, new GridBagConstraints(0, 2, 2, 1, 0.3, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(countryEditor, new GridBagConstraints(2, 2, 2, 1, 0.3, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(departmentEditor, new GridBagConstraints(4, 2, 2, 1, 0.3, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(datePubEditor, new GridBagConstraints(0, 3, 2, 1, 0.3, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(datePeremeptionEditor, new GridBagConstraints(2, 3, 2, 1, 0.3, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($Spacer0, new GridBagConstraints(4, 3, 2, 1, 0.3, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(content, new GridBagConstraints(0, 4, 6, 1, 1.0, 0.8, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(descriptionEditor, new GridBagConstraints(0, 5, 6, 1, 1.0, 0.2, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($Table1, JSplitPane.LEFT);
        $JSplitPane0.add($Table2, JSplitPane.RIGHT);
        // inline complete setup of $Table1
        $Table1.add($JScrollPane0, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(addFile, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(removeFile, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fileList);
        // inline complete setup of $Table2
        $Table2.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add($JScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(propositionList);
        addChildrenToActionPanel();
        addChildrenToStatusButtonPanel();
        
        // apply 47 property setters
        offerEdit.setOrientation(JSplitPane.VERTICAL_SPLIT);
        objetEditor.setExtensionFieldName(Form.FIELD_OBJET);
        objetEditor.setExtensionName(Form.EXT_INFOGENE);
        objetEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        objetEditor.setValue(data.getObjet());
        idEditor.setExtensionFieldName(Form.FIELD_ID);
        idEditor.setExtensionName(Form.EXT_INFOGENE);
        idEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        idEditor.setValue(data.getId());
        sourceTextEditor.setExtensionFieldName(Form.FIELD_SOURCETEXT);
        sourceTextEditor.setExtensionName(Form.EXT_INFOGENE);
        sourceTextEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        sourceTextEditor.setValue(data.getSourceText());
        sourceURLEditor.setExtensionFieldName(Form.FIELD_SOURCEURL);
        sourceURLEditor.setExtensionName(Form.EXT_INFOGENE);
        sourceURLEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.URL.getFieldType()));
        sourceURLEditor.setValue(data.getSourceURL());
        entityEditor.setExtensionFieldName(Form.FIELD_ENTITY);
        entityEditor.setExtensionName(Form.EXT_INFOGENE);
        entityEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        entityEditor.setValue(data.getEntity());
        countryEditor.setExtensionFieldName(Form.FIELD_COUNTRY);
        countryEditor.setExtensionName(Form.EXT_INFOGENE);
        countryEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        countryEditor.setValue(data.getCountry());
        departmentEditor.setExtensionFieldName(Form.FIELD_DEPARTMENT);
        departmentEditor.setExtensionName(Form.EXT_INFOGENE);
        departmentEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        departmentEditor.setValue(data.getDepartment());
        datePubEditor.setExtensionFieldName(Form.FIELD_DATEPUB);
        datePubEditor.setExtensionName(Form.EXT_FORM);
        datePubEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.DATE_TIME.getFieldType()));
        datePubEditor.setValue(data.getDatePub());
        datePeremeptionEditor.setExtensionFieldName(Form.FIELD_DATEPEREMPTION);
        datePeremeptionEditor.setExtensionName(Form.EXT_FORM);
        datePeremeptionEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.DATE_TIME.getFieldType()));
        datePeremeptionEditor.setValue(data.getDatePeremption());
        descriptionEditor.setExtensionFieldName(Form.FIELD_DESCRIPTION);
        descriptionEditor.setExtensionName(Form.EXT_INFOGENE);
        descriptionEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.TEXT.getFieldType()));
        descriptionEditor.setValue(data.getDescription());
        $JSplitPane0.setOrientation(JSplitPane.VERTICAL_SPLIT);
        propositionList.setModel(propositionListModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("offerEditUI", this);
        createData();
        createPropositionListModel();
        createValide();
        createErrorEditorTable();
        createOfferEdit();
        createFormSplitPane();
        createFormPanel();
        createFormScrollPane();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        $Table0.setName("$Table0");
        createObjetEditor();
        createIdEditor();
        createSourceTextEditor();
        createSourceURLEditor();
        createEntityEditor();
        createCountryEditor();
        createDepartmentEditor();
        createDatePubEditor();
        createDatePeremeptionEditor();
        // inline creation of $Spacer0
        $objectMap.put("$Spacer0", $Spacer0 = new jaxx.runtime.swing.Spacer());
        $Spacer0.setName("$Spacer0");
        createContent();
        createDescriptionEditor();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new javax.swing.JSplitPane());
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setDividerLocation(200);
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setContinuousLayout(true);
        $JSplitPane0.setDividerSize(12);
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        $Table1.setName("$Table1");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        $JScrollPane0.setName("$JScrollPane0");
        createFileList();
        createAddFile();
        createRemoveFile();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new jaxx.runtime.swing.Table());
        $Table2.setName("$Table2");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.edit.proposition"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        $JScrollPane1.setName("$JScrollPane1");
        createPropositionList();
        createThesaurus();
        createActionPanel();
        createLastModified();
        createStatusButtonPanel();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.status.validate"));
        createAnnuler();
        createTest();
        // inline creation of offerEditUI
        setName("offerEditUI");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}