package org.sharengo.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class LabelImpl extends BusinessEntityWikitty implements Label {

    private static final long serialVersionUID = 911181373L;


    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionLabel =
        new WikittyExtension(EXT_LABEL, "1", null,
		    WikittyUtil.buildFieldMapExtension(
				"String labels[0-*] unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.add(extensionLabel);

        extensions = Collections.unmodifiableList(exts);
    }
 
	public LabelImpl() {
		super();
	}

    public LabelImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public LabelImpl(Wikitty wi) {
		super(wi);
	}

    public Set<String> getLabels() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_LABEL, "labels", String.class);
        return result;
    }

    public void addLabels(String element) {
        getWikitty().addToField(EXT_LABEL, "labels", element);
    }
    
    public void removeLabels(String element) {
        getWikitty().removeFromField(EXT_LABEL, "labels", element);
    }
    
    public void clearLabels() {
        getWikitty().clearField(EXT_LABEL, "labels");
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //LabelImpl
