/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.jdbc.WikittyJDBCUtil;

public class WikittyExtensionStorageJDBC
implements WikittyExtensionStorage {
    protected static Log log = LogFactory.getLog(WikittyExtensionStorageJDBC.class);
    protected static String driver = "jdbc.con.driver";
    protected static String extAdminCreationQ = "jdbc.queries.creation.extension.admin";
    protected static String extDataCreationQ = "jdbc.queries.creation.extension.data";
    protected static String selectionQ = "jdbc.queries.select";
    protected static String orderedWhereSelectionQ = "jdbc.queries.select.where.order";
    protected static String whereSelectionQ = "jdbc.queries.select.where";
    protected static String adminInsertQ = "jdbc.queries.insert.extension.admin";
    protected static String dataInsertQ = "jdbc.queries.insert.extension.data";
    protected static String adminTable = "extension_admin";
    protected static String dataTable = "extension_data";
    protected Properties conf;
    protected Map<String, WikittyExtension> extensionCache = new HashMap<String, WikittyExtension>();
    protected Map<String, String> lastVersion = null;

    public WikittyExtensionStorageJDBC() {
        this(WikittyJDBCUtil.loadProperties());
    }

    public WikittyExtensionStorageJDBC(Properties properties) {
        this.conf = properties;
        try {
            Class.forName(this.conf.getProperty(driver));
        }
        catch (ClassNotFoundException eee) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)"Couldn't find the driver!");
                eee.printStackTrace();
            }
            throw new WikittyException((Exception)eee);
        }
        Connection con = null;
        try {
            con = WikittyJDBCUtil.getConnection(this.conf);
            Statement statement = con.createStatement();
            try {
                statement.execute(this.conf.getProperty(extAdminCreationQ));
                statement.execute(this.conf.getProperty(extDataCreationQ));
                con.commit();
            }
            catch (SQLException eee) {
                con.rollback();
            }
            WikittyJDBCUtil.closeConnection(con);
        }
        catch (SQLException eee) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)"Couldn't connect !");
                eee.printStackTrace();
            }
            WikittyJDBCUtil.closeConnection(con);
            throw new WikittyException((Exception)eee);
        }
    }

    public List<WikittyExtensionStorage.Command> prepare(WikittyTransaction transaction, Collection<WikittyExtension> extensions) throws WikittyException {
        Connection con = null;
        try {
            con = WikittyJDBCUtil.getConnection(this.conf);
            ArrayList<WikittyExtensionStorage.Command> result = new ArrayList<WikittyExtensionStorage.Command>(extensions.size());
            for (WikittyExtension ext : extensions) {
                String id = ext.getId();
                Statement statement = con.createStatement();
                ResultSet versionResultSet = statement.executeQuery(String.format(this.conf.getProperty(whereSelectionQ), "version", adminTable, "id", "'" + id + "'"));
                StringBuffer batch = new StringBuffer();
                if (!versionResultSet.first()) {
                    String tagValues = WikittyUtil.convertTagValuesToString((WikittyExtension)ext);
                    batch.append(String.format(this.conf.getProperty(adminInsertQ), ext.getId(), ext.getName(), ext.getVersion(), ext.getRequires() != null ? "'" + ext.getRequires() + "'" : "null", !tagValues.isEmpty() ? "'" + tagValues + "'" : "null"));
                    for (int i = 0; i < ext.getFieldNames().size(); ++i) {
                        FieldType type = ext.getFieldType((String)ext.getFieldNames().get(i));
                        batch.append(String.format(this.conf.getProperty(dataInsertQ), ext.getId(), ext.getFieldNames().get(i), type.toDefinition((String)ext.getFieldNames().get(i)), i));
                    }
                } else {
                    log.warn((Object)("The extension is found " + id));
                }
                result.add(new CommandJDBC(batch.toString()));
            }
            WikittyJDBCUtil.closeConnection(con);
            return result;
        }
        catch (SQLException eee) {
            WikittyJDBCUtil.closeConnection(con);
            throw new WikittyException((Exception)eee);
        }
    }

    public UpdateResponse commit(WikittyTransaction transaction, List<WikittyExtensionStorage.Command> extensionStorageCommandList) {
        Connection con = null;
        try {
            con = WikittyJDBCUtil.getConnection(this.conf);
            Statement statement = con.createStatement();
            for (WikittyExtensionStorage.Command command : extensionStorageCommandList) {
                CommandJDBC commandJDBC = (CommandJDBC)command;
                statement.execute(commandJDBC.queries);
            }
            con.commit();
            WikittyJDBCUtil.closeConnection(con);
            this.lastVersion = null;
            UpdateResponse result = new UpdateResponse();
            return result;
        }
        catch (SQLException eee) {
            WikittyJDBCUtil.closeConnection(con, true);
            throw new WikittyException((Exception)eee);
        }
    }

    public boolean exists(String id) {
        Connection con = null;
        try {
            con = WikittyJDBCUtil.getConnection(this.conf);
            Statement statement = con.createStatement();
            ResultSet resultSet = statement.executeQuery(String.format(this.conf.getProperty(whereSelectionQ), adminTable, "id", "'" + id + "'"));
            boolean result = resultSet.first();
            WikittyJDBCUtil.closeConnection(con);
            return result;
        }
        catch (SQLException eee) {
            WikittyJDBCUtil.closeConnection(con);
            throw new WikittyException((Exception)eee);
        }
    }

    public List<String> getAllExtensionIds() {
        Connection con = null;
        try {
            con = WikittyJDBCUtil.getConnection(this.conf);
            ArrayList<String> result = new ArrayList<String>();
            Statement statement = con.createStatement();
            ResultSet resultSet = statement.executeQuery(String.format(this.conf.getProperty(selectionQ), "id", adminTable));
            resultSet.beforeFirst();
            while (resultSet.next()) {
                String id = resultSet.getString("id");
                result.add(id);
            }
            WikittyJDBCUtil.closeConnection(con);
            return result;
        }
        catch (SQLException eee) {
            WikittyJDBCUtil.closeConnection(con);
            throw new WikittyException((Exception)eee);
        }
    }

    public List<WikittyExtension> getAllExtensions(boolean lastVersion) {
        Connection con = null;
        try {
            con = WikittyJDBCUtil.getConnection(this.conf);
            ArrayList<WikittyExtension> result = new ArrayList<WikittyExtension>();
            Statement statement = con.createStatement();
            if (lastVersion) {
                ResultSet adminResultSet = statement.executeQuery(String.format(this.conf.getProperty(selectionQ), "DISTINCT name", adminTable));
                adminResultSet.beforeFirst();
                while (adminResultSet.next()) {
                    String extName = adminResultSet.getString("name");
                    String extVersion = this.getLastVersion(extName);
                    String extId = WikittyExtension.computeId((String)extName, (String)extVersion);
                    result.add(this.restore(WikittyExtension.computeName((String)extId), WikittyExtension.computeVersion((String)extId)));
                }
            } else {
                ResultSet adminResultSet = statement.executeQuery(String.format(this.conf.getProperty(selectionQ), "id", adminTable));
                adminResultSet.beforeFirst();
                while (adminResultSet.next()) {
                    String extId = adminResultSet.getString("id");
                    result.add(this.restore(WikittyExtension.computeName((String)extId), WikittyExtension.computeVersion((String)extId)));
                }
            }
            WikittyJDBCUtil.closeConnection(con);
            return result;
        }
        catch (SQLException eee) {
            WikittyJDBCUtil.closeConnection(con);
            throw new WikittyException((Exception)eee);
        }
    }

    public String getLastVersion(String extName) {
        if (this.lastVersion == null) {
            this.lastVersion = new HashMap<String, String>();
            Connection con = null;
            try {
                con = WikittyJDBCUtil.getConnection(this.conf);
                Statement statement = con.createStatement();
                ResultSet resultSet = statement.executeQuery(String.format(this.conf.getProperty(selectionQ), "name,version", adminTable));
                resultSet.beforeFirst();
                while (resultSet.next()) {
                    String name = resultSet.getString("name");
                    String version = resultSet.getString("version");
                    String prevVersion = this.lastVersion.get(name);
                    if (prevVersion != null && !WikittyUtil.versionGreaterThan((String)version, (String)prevVersion)) continue;
                    this.lastVersion.put(name, version);
                }
            }
            catch (SQLException eee) {
                WikittyJDBCUtil.closeConnection(con);
                throw new WikittyException((Exception)eee);
            }
            WikittyJDBCUtil.closeConnection(con);
        }
        String result = this.lastVersion.get(extName);
        return result;
    }

    public WikittyExtension restore(String name, String version) throws WikittyException {
        String id = WikittyExtension.computeId((String)name, (String)version);
        WikittyExtension result = this.extensionCache.get(id);
        if (result == null) {
            Connection con = null;
            try {
                con = WikittyJDBCUtil.getConnection(this.conf);
                Statement statement = con.createStatement();
                ResultSet adminResultSet = statement.executeQuery(String.format(this.conf.getProperty(whereSelectionQ), "*", adminTable, "id", "'" + id + "'"));
                if (adminResultSet.first()) {
                    String extName = adminResultSet.getString("name");
                    String extVersion = adminResultSet.getString("version");
                    String extRequires = adminResultSet.getString("requires");
                    String extTagValue = adminResultSet.getString("tagValues");
                    LinkedHashMap<String, FieldType> fieldTypes = new LinkedHashMap<String, FieldType>();
                    ResultSet dataResultSet = statement.executeQuery(String.format(this.conf.getProperty(orderedWhereSelectionQ), "*", dataTable, "id", "'" + id + "'", "fieldRank"));
                    dataResultSet.beforeFirst();
                    while (dataResultSet.next()) {
                        String fieldDef = dataResultSet.getString("fieldType");
                        FieldType fieldType = new FieldType();
                        String fieldName = WikittyUtil.parseField((String)fieldDef, (FieldType)fieldType);
                        fieldTypes.put(fieldName, fieldType);
                    }
                    result = new WikittyExtension(extName, extVersion, extRequires, fieldTypes);
                    WikittyUtil.parseExtensionTagValue((String)extTagValue, (WikittyExtension)result);
                    this.extensionCache.put(id, result);
                }
            }
            catch (SQLException eee) {
                WikittyJDBCUtil.closeConnection(con);
                throw new WikittyException(String.format("Can't load extension %s", id), (Exception)eee);
            }
            WikittyJDBCUtil.closeConnection(con);
        }
        return result;
    }

    class CommandJDBC
    implements WikittyExtensionStorage.Command {
        protected String queries;

        public CommandJDBC(String queries) {
            this.queries = queries;
        }
    }
}

