package com.jurismarches.vradi.ui.search;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.search.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.sharengo.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class CriteriaUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATE_SELECTION_MODEL = "dateSelectionModel";
    public static final String PROPERTY_FORM_TYPE_SELECTION_MODEL = "formTypeSelectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DATE_TYPE_SELECTION_MODEL = "dateTypeSelection.model";
    public static final String BINDING_FORM_TYPE_SELECTION_MODEL = "formTypeSelection.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWVz08TQRTHh0oL5YcKCIEACoIxhriVH0oiBBEIEdIKWozExsRpd6ADuzvr7CwsF+Of4J+gdy8m3jwZD549eDH+C8Z48Gp8s7ttKV2WTZbD0s577zPvfWf22/e/UNLiaHQPO47CbUNQnSjr97e3N4p7pCRWiFXi1BSMI++vKYESBdSuVtctgcYKWVme8cszy0w3mUGMY9VzWdRmiSONWGVChEDD9RUly8rkq+E5x7R5hVptKoj69s/vxBv19bsEQo4J3Q3AKCNnVdUmac6iBFUF6oadDnBGw8YutMGpsQv9dsq1ZQ1b1kOsk5foFWrJopSJOcAEuhp9ZJfh1jumQKkdqgnCBZooMV3Zszm1dMxLZWIpBxyrVLGpYhG5oixzCpkUP1kzTReQglZVLEieaHA2lBk5phJNyJEPsKNYh9C5skJ2sK0J6KjIlpjjptTq+3YY17eOzAbGwHHGKcUt41u4qJFbAvXXiewVuTGZmT5ZMCm/XpKP7mqodXw9i4tEA1j38a29VZnUW8vd4UxfgcFhVMZ3lT24fvuCmV6Jo6xvy+AmLe0THlD5gNmgd2/dLpUJT6T7TbkND9TH2iQqRw1buENeCa6cCqhMCSb7k9+GGiKyuRDedACvVbBT+/AVnwpQPLkFbRwJ1FMnxJItBDNkilKDwI0VkCu/TtWH0jKUY4YoBwT9zadDjnumOs9sNdbVcCerg802AG4HAeRLcRags+S/TpvYkBe+/ta5i/7l5Wiw7nqDOyk1d6rZR1MBJbkNy/A+FBoN7TGEPCvrP2FlEuhG//X1fP/08+Nqxb+GYe/ewNRj9gu+YnJmgodQufUFz7xsQbVMDptzBZS2XBlcbx4KaCzvh6E52K9LliuyXHmArTIgki0/Pn/pe/HtHEqsojaNYXUVy/w1lBZlDiowTXXMe4tuRx2HrfC8KHuD+6zhIwYXCp2fhyPBI0VqqCDvggMiDAWIUO2kmP76tyf/YbEiRBM0NnBqek2M5DOUooZGDeJaue/SgdbdblrEVlnNjYP8uUn+bzN9y1tzn7mgSZsFcWDO7nlv9xEs4HejCO8kzCqLHrlDyE95l9kfhan6LrEZzBiMwEjq0rJDIJcjQFrhN04l3DPTGJwO7yISdU0QPRZLLj+Vj+1gwmgkQjGkh7FIhN3YhLCziUYI0+FaJMLzkB6ux1byRmwloxHClIxGCFNyIrYON2PrEI0QpkM0QpgOk7EJM7EJd2IT7sY+zfnYpxmNEDbFQuwpFmNPEY2wEUJYAsJ/1wsov3cOAAA=";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.search.CriteriaUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton ToDay;
    protected javax.swing.JPanel criteriaPanel;
    protected javax.swing.DefaultComboBoxModel dateSelectionModel;
    protected javax.swing.JComboBox dateTypeSelection;
    protected CriteriaUI filter = this;
    protected javax.swing.JComboBox formTypeSelection;
    protected javax.swing.ComboBoxModel formTypeSelectionModel;
    protected org.jdesktop.swingx.JXDatePicker fromDate;
    protected javax.swing.JComboBox fromHour;
    protected javax.swing.JComboBox fromMinute;
    protected javax.swing.JButton lastDay;
    protected javax.swing.JButton lastMonth;
    protected org.jdesktop.swingx.JXDatePicker toDate;
    protected javax.swing.JComboBox toHour;
    protected javax.swing.JComboBox toMinute;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private jaxx.runtime.swing.Table $Table2;
    private jaxx.runtime.swing.Table $Table3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public SearchHandler getHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    void $afterCompleteSetup() {
        updateDateSelectionModel();
    }
    protected void updateDateSelectionModel(){
        setDateSelectionModel(getHandler().updateDateSelectionModel(
                (WikittyExtension)formTypeSelection.getSelectedItem()));
        log.debug(dateSelectionModel.getSize());
        for(int i = 0 ; i < dateSelectionModel.getSize() ; i++) {
            log.debug(dateSelectionModel.getElementAt(i));
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CriteriaUI() {
        $initialize();
    }

    public CriteriaUI(JAXXContext parentContext) {
        Util.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__ToDay(java.awt.event.ActionEvent event) {
        fromDate.setDate(new Date()); fromHour.setSelectedItem(0); fromMinute.setSelectedItem(0);                                      toDate.setDate(new Date()); toHour.setSelectedItem(23); toMinute.setSelectedItem(59);
    }

    public void doActionPerformed__on__formTypeSelection(java.awt.event.ActionEvent event) {
        updateDateSelectionModel();
    }

    public void doActionPerformed__on__lastDay(java.awt.event.ActionEvent event) {
        fromDate.setDate(VradiHelper.getLastDayDate()); fromHour.setSelectedItem(0); fromMinute.setSelectedItem(0);                                      toDate.setDate(VradiHelper.getLastDayDate()); toHour.setSelectedItem(23); toMinute.setSelectedItem(59);
    }

    public void doActionPerformed__on__lastMonth(java.awt.event.ActionEvent event) {
        fromDate.setDate(VradiHelper.getBeginMonthDate()); fromHour.setSelectedItem(0); fromMinute.setSelectedItem(0);                                      toDate.setDate(new Date()); toHour.setSelectedItem(23); toMinute.setSelectedItem(59);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getCriteriaPanel() {
        return criteriaPanel;
    }

    public javax.swing.DefaultComboBoxModel getDateSelectionModel() {
        return dateSelectionModel;
    }

    public javax.swing.JComboBox getDateTypeSelection() {
        return dateTypeSelection;
    }

    public javax.swing.JComboBox getFormTypeSelection() {
        return formTypeSelection;
    }

    public javax.swing.ComboBoxModel getFormTypeSelectionModel() {
        return formTypeSelectionModel;
    }

    public org.jdesktop.swingx.JXDatePicker getFromDate() {
        return fromDate;
    }

    public javax.swing.JComboBox getFromHour() {
        return fromHour;
    }

    public javax.swing.JComboBox getFromMinute() {
        return fromMinute;
    }

    public javax.swing.JButton getLastDay() {
        return lastDay;
    }

    public javax.swing.JButton getLastMonth() {
        return lastMonth;
    }

    public org.jdesktop.swingx.JXDatePicker getToDate() {
        return toDate;
    }

    public javax.swing.JButton getToDay() {
        return ToDay;
    }

    public javax.swing.JComboBox getToHour() {
        return toHour;
    }

    public javax.swing.JComboBox getToMinute() {
        return toMinute;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setDateSelectionModel(javax.swing.DefaultComboBoxModel newValue) {
        javax.swing.DefaultComboBoxModel oldValue = this.dateSelectionModel;
        this.dateSelectionModel = newValue;
        firePropertyChange(PROPERTY_DATE_SELECTION_MODEL, oldValue, newValue);
    }

    public void setFormTypeSelectionModel(javax.swing.ComboBoxModel newValue) {
        javax.swing.ComboBoxModel oldValue = this.formTypeSelectionModel;
        this.formTypeSelectionModel = newValue;
        firePropertyChange(PROPERTY_FORM_TYPE_SELECTION_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected jaxx.runtime.swing.Table get$Table3() {
        return $Table3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFilter() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
        add(criteriaPanel, BorderLayout.EAST);
    }

    protected void createCriteriaPanel() {
        $objectMap.put("criteriaPanel", criteriaPanel = new javax.swing.JPanel());
        criteriaPanel.setName("criteriaPanel");
        criteriaPanel.setLayout(new BoxLayout(criteriaPanel, BoxLayout.X_AXIS));
    }

    protected void createDateSelectionModel() {
        $objectMap.put("dateSelectionModel", dateSelectionModel = new DefaultComboBoxModel());
    }

    protected void createDateTypeSelection() {
        $objectMap.put("dateTypeSelection", dateTypeSelection = new javax.swing.JComboBox());
        dateTypeSelection.setName("dateTypeSelection");
    }

    protected void createFormTypeSelection() {
        $objectMap.put("formTypeSelection", formTypeSelection = new javax.swing.JComboBox());
        formTypeSelection.setName("formTypeSelection");
        formTypeSelection.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__formTypeSelection"));
    }

    protected void createFormTypeSelectionModel() {
        $objectMap.put("formTypeSelectionModel", formTypeSelectionModel = VradiHelper.getFormTypesModel());
    }

    protected void createFromDate() {
        $objectMap.put("fromDate", fromDate = new org.jdesktop.swingx.JXDatePicker());
        fromDate.setName("fromDate");
    }

    protected void createFromHour() {
        $objectMap.put("fromHour", fromHour = new javax.swing.JComboBox());
        fromHour.setName("fromHour");
    }

    protected void createFromMinute() {
        $objectMap.put("fromMinute", fromMinute = new javax.swing.JComboBox());
        fromMinute.setName("fromMinute");
    }

    protected void createLastDay() {
        $objectMap.put("lastDay", lastDay = new javax.swing.JButton());
        lastDay.setName("lastDay");
        lastDay.setText(_("vradi.criteria.searchLastDay"));
        lastDay.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__lastDay"));
    }

    protected void createLastMonth() {
        $objectMap.put("lastMonth", lastMonth = new javax.swing.JButton());
        lastMonth.setName("lastMonth");
        lastMonth.setText(_("vradi.criteria.searchThisMonth"));
        lastMonth.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__lastMonth"));
    }

    protected void createToDate() {
        $objectMap.put("toDate", toDate = new org.jdesktop.swingx.JXDatePicker());
        toDate.setName("toDate");
    }

    protected void createToDay() {
        $objectMap.put("ToDay", ToDay = new javax.swing.JButton());
        ToDay.setName("ToDay");
        ToDay.setText(_("vradi.criteria.searchToDay"));
        ToDay.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ToDay"));
    }

    protected void createToHour() {
        $objectMap.put("toHour", toHour = new javax.swing.JComboBox());
        toHour.setName("toHour");
    }

    protected void createToMinute() {
        $objectMap.put("toMinute", toMinute = new javax.swing.JComboBox());
        toMinute.setName("toMinute");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToFilter();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($Table3, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(fromDate, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(fromHour, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(fromMinute, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(toDate, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(toHour, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(toMinute, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table2
        $Table2.add(ToDay, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add(lastDay, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add(lastMonth, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table3
        $Table3.add($JLabel4, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table3.add(formTypeSelection, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table3.add($JLabel5, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table3.add(dateTypeSelection, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 2 data bindings
        Util.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        fromDate.setDate(new java.util.Date());
        fromHour.setModel(UIHelper.getHourModel());
        fromHour.setRenderer(UIHelper.get2DigitsRenderer());
        fromHour.setSelectedItem(0);
        fromMinute.setModel(UIHelper.getMinuteModel());
        fromMinute.setRenderer(UIHelper.get2DigitsRenderer());
        fromMinute.setSelectedItem(0);
        toDate.setDate(new java.util.Date());
        toHour.setModel(UIHelper.getHourModel());
        toHour.setRenderer(UIHelper.get2DigitsRenderer());
        toHour.setSelectedItem(23);
        toMinute.setModel(UIHelper.getMinuteModel());
        toMinute.setRenderer(UIHelper.get2DigitsRenderer());
        toMinute.setSelectedItem(59);
        formTypeSelection.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        dateTypeSelection.setRenderer(getHandler().getDateTypeComboBoxRenderer());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 2 data bindings
        $registerDefaultBindings();
        $objectMap.put("filter", this);
        createDateSelectionModel();
        createFormTypeSelectionModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.criteria.from"));
        createFromDate();
        createFromHour();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_(":"));
        createFromMinute();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.criteria.to"));
        createToDate();
        createToHour();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_(":"));
        createToMinute();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new jaxx.runtime.swing.Table());
        $Table2.setName("$Table2");
        createToDay();
        createLastDay();
        createLastMonth();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new jaxx.runtime.swing.Table());
        $Table3.setName("$Table3");
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("vradi.criteria.formType"));
        createFormTypeSelection();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new javax.swing.JLabel());
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("vradi.criteria.typeDate"));
        createDateTypeSelection();
        createCriteriaPanel();
        // inline creation of filter
        setName("filter");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FORM_TYPE_SELECTION_MODEL, true ,"formTypeSelectionModel") {
        
            @Override
            public void processDataBinding() {
                formTypeSelection.setModel(getFormTypeSelectionModel());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DATE_TYPE_SELECTION_MODEL, true ,"dateSelectionModel") {
        
            @Override
            public void processDataBinding() {
                dateTypeSelection.setModel(getDateSelectionModel());
            }
        });
    }

}