/*
 * *##% 
 * vradi-swing
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.admin.AdminThesaurusUI;
import com.jurismarches.vradi.ui.admin.ThesaurusPathChooserUI;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.Util;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.*;
import jaxx.runtime.swing.navigation.NavigationTreeHandler.Strategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;

import javax.swing.*;
import javax.swing.tree.TreePath;
import java.awt.*;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;

/**
 * @author letellier
 */
public class ThesaurusTreeHelper extends NavigationTreeHelper {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(ThesaurusTreeHelper.class);
    /**
     * where the movies are hold in context
     */
    protected JAXXContextEntryDef<VradiThesaurusDTO> THESAURUS;

    protected NavigationTreeNode rootNode = null;

    protected ThesaurusTreeModelBuilder builder = null;

    protected VradiThesaurusDTO rootThesaurus = null;

    protected JAXXContext context = null;

    public ThesaurusTreeHelper(JAXXContext context, VradiThesaurusDTO rootThesaurus) {
        this(context, rootThesaurus, "");
    }

    public ThesaurusTreeHelper(JAXXContext context, VradiThesaurusDTO rootThesaurus, String name) {
        super(rootThesaurus.getName() + name);
        this.context = context;

        // Create entry def with unique name
        THESAURUS = Util.newContextEntryDef("thesaurus" + name, VradiThesaurusDTO.class);

        // Create the model and store it in the given context.
        THESAURUS.setContextValue(context, rootThesaurus);
        this.rootThesaurus = rootThesaurus;
    }

    protected ThesaurusHandler getHandler(JAXXContext context) {
        return UIHelper.getHandler(context, ThesaurusHandler.class);
    }

    public ThesaurusTreeModelBuilder getBuilder() {
        return builder;
    }

    public void setRootThesaurus(VradiThesaurusDTO root) {
        this.rootThesaurus = root;
    }

    public VradiThesaurusDTO getRootThesaurus() {
        return rootThesaurus;
    }

    public NavigationTreeNode getRootNode() {
        return rootNode;
    }

    public String getRootName() {
        return rootThesaurus.getName();
    }

    @Override
    public NavigationTreeModel createTreeModel(JAXXContext context) {
        this.context = context;
        if (builder == null) {
            builder = new ThesaurusTreeModelBuilder(context);
        }

        // construction du noeud root
        // il ne contient pas de context et ne sera passsss visible
        rootNode = builder.buildEmptyRoot(THESAURUS, rootThesaurus.getName());

        getBuilder().buildChildren(context, rootNode);

        NavigationTreeModel model = builder.getModel();

        if (log.isInfoEnabled()) {
            builder.printModel(model.getRoot());
        }

        // save tree model in context
        setTreeModel(context, model);

        return model;
    }


    @Override
    public NavigationTreeHandler createTreeHandler(JAXXObject context) {

        if (log.isDebugEnabled()) {
            log.debug("create handler");
        }

        NavigationTreeHandler handler;

        handler = new NavigationTreeHandler(
                getPrefix(),
                context,
                Strategy.PER_NODE) {

            private static final long serialVersionUID = 1L;

            @Override
            protected NavigationTreeModel getNavigationTreeModel() {
                return getSafeTreeModel(getContext());
            }

            @Override
            protected void treateError(Exception e) {
                ErrorDialogUI.showError(e);
            }

            @Override
            public JAXXContext getContext() {
                return this.context;
            }

            @Override
            protected Component getCurrentUI() {
                return null;
            }

            @Override
            protected Component getUI(NavigationTreeNode node) {
                return (Component) context;
            }

            @Override
            protected boolean closeUI(Component component) throws Exception {
                return true;
            }

            @Override
            protected Component createUI(NavigationTreeNode node) throws Exception {
                return getHandler(context).getUI(context);
            }

            @Override
            protected void openUI(Component newUI, NavigationTreeNode node) throws Exception {
            }
        };
        // Selection multiple
        handler.setSelectionMode(NavigationTreeHandler.DISCONTIGUOUS_TREE_SELECTION);

        // save handler in ui context
        setTreeHandler(context, handler);

        // save tree in context
        // TODO : remove it
        if (context instanceof ThesaurusUI) {
            setTree(context, ((ThesaurusUI) context).getThesaurus());
        } else if (context instanceof AdminThesaurusUI) {
            setTree(context, ((AdminThesaurusUI) context).getThesaurus());
        } else {
            setTree(context, ((ThesaurusPathChooserUI) context).getThesaurus());
        }

        return handler;
    }

    public TreePath expendNode(JAXXContext context, NavigationTreeNode node) {

        javax.swing.tree.TreeNode[] treeNodes = node.getPath();
        TreePath path = new TreePath(treeNodes);
        getTree(context).expandPath(path);

        return path;
    }

    public void tryToSelect(JAXXContext context, Set<String> thesaurusId) {
        if (thesaurusId != null) {
            List<NavigationTreeNode> nodes = new ArrayList<NavigationTreeNode>();

            // Find recursivly
            for (String id : thesaurusId) {
                tryToSelect(id, getRootNode(), nodes);
            }

            // Select all
            JTree tree = getTree(context);
            TreePath[] paths = new TreePath[nodes.size()];
            int i = 0;
            for (NavigationTreeNode node : nodes) {

                // Expend
                TreePath path = expendNode(context, node);

                if (log.isDebugEnabled()) {
                    log.debug("Try to select path : " + path);
                }

                paths[i++] = path;

                if (log.isDebugEnabled()) {
                    log.debug("path " + paths[i - 1] + " for node " + node);
                }
            }
            // Select all
            tree.setSelectionPaths(paths);
        }
    }

    public void tryToSelect(String thesaurusId, NavigationTreeNode node, List<NavigationTreeNode> nodes) {
        if (thesaurusId != null) {
            if (thesaurusId.equals(getWikittyId(node))) {
                // Add to select list
                nodes.add(node);

            } else {
                // Find in child
                Enumeration<NavigationTreeNode> children = node.children();
                while (children.hasMoreElements()) {
                    NavigationTreeNode child = children.nextElement();
                    tryToSelect(thesaurusId, child, nodes);
                }
            }
        }
    }

    protected String getWikittyId(NavigationTreeNode node) {
        VradiThesaurusDTO thesaurus = (VradiThesaurusDTO) node.getBean();
        return thesaurus.getWikittyId();
    }

    public class ThesaurusTreeModelBuilder extends NavigationTreeModelBuilder {
        public ThesaurusTreeModelBuilder(JAXXContext context) {
            super("/", context, null, null);
        }

        // Return true if empty
        public boolean removeNodeFromParent(JAXXContext context, NavigationTreeNode node) {
            NavigationTreeModel treeModel = getTreeModel(context);
            treeModel.removeNodeFromParent(node);
            return treeModel.getRoot().getChildCount() == 0;
        }

        public NavigationTreeNode addThesaurusToSelected(JAXXContext context, VradiThesaurusDTO thesaurus) {
            NavigationTreeNode selectedNode = getSelectedNode(context);

            return addThesaurus(context, selectedNode, thesaurus);
        }

        public NavigationTreeNode addThesaurus(JAXXContext context, NavigationTreeNode parent, VradiThesaurusDTO thesaurus) {
            return addThesaurus(parent, thesaurus.getWikittyId());
        }

        public NavigationTreeNode addThesaurusRecursivly(NavigationTreeNode parent, VradiThesaurusDTO thesaurus) {
            NavigationTreeNode newNode = addThesaurus(parent, thesaurus.getWikittyId());
            for (VradiThesaurusDTO child : thesaurus.getChildren()){
                addThesaurusRecursivly(newNode, child);
            }
            return newNode;
        }

        public NavigationTreeNode addThesaurus(NavigationTreeNode parent, String thesaurusId) {
            NavigationTreeNode result = null;
            Decorator<VradiThesaurusDTO> tDecorator = getThesaurusDecorator();
            String path = "";
            if (parent == null) {
                parent = getRootNode();
                path = "..children[@wikittyId=\"" + thesaurusId + "\"]";
            } else {
                path = "../children[@wikittyId=\"" + thesaurusId + "\"]";
            }

            result = builder.build(parent, tDecorator, path, thesaurusId, null, null);
            if (log.isDebugEnabled()) {
                log.debug("addThesaurus : " + thesaurusId + " to parent : " + parent == null ? "null" : parent.getFullPath() + " fullPath : " + result == null ? "result is null" : result.getFullPath());
            }
            return result;
        }

        public void buildChildren(JAXXContext context, NavigationTreeNode parentNode) {

            VradiThesaurusDTO parent = (VradiThesaurusDTO) parentNode.getBean(context);
            if (parent != null){
                for (VradiThesaurusDTO child : parent.getChildren()) {
                    NavigationTreeNode childNode = addThesaurus(context, parentNode, child);

                    // Build childs
                    if (child.getWikittyId() != null) {
                        buildChildren(context, childNode);
                    }
                }
            }
        }
    }

    protected Decorator<VradiThesaurusDTO> getThesaurusDecorator() {
        Decorator<VradiThesaurusDTO> tDecorator = VradiContext.get().getDecorateurProvinder().getDecorator(VradiThesaurusDTO.class);
        return tDecorator;
    }
}
