package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.dto.*;
import com.jurismarches.vradi.ui.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ProgressBarUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PARAGRAPH = "paragraph";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTW/TQBCduCQlKYHSqqWoBVqQ4Ob8gFZQCIpoFSiiQqrIhU28xBut7WV33LoXxE/gJ8CdCxI3TogDZw5cEH8BIQ5cEbPOh1MwUFEfbGtn5s2bN89++QWKRsNKjyWJq+MQRcDdzes7O1vtHu/gTW46WiiMNPSvggNOC6a80blBuNRq2vLaoLxWjwIVhTwcq15tQsXgvuTG5xwRzh2s6BhT2x6FVxMV6yHqiFQe6vNvX51n3tMXDkCiiN0EjbL8r6pskmNNcISHMEOddllNsrBLNLQIu8S3as/qkhlzhwX8MTyBySaUFNMEhnDx8COnGGl9ohCqSkddzY25wfT9DYQrnShwe7EWJmC643Pj7mrmCTcW7t3xTKVSjBJCmTiwrmbKR5i2JF1L3O0Tz9KmxhohLNjExDV7lONujiHb7LIi3RYP6EYbcbONZJIVWlDUMR0TZOv3Jd6jUH99C7+szwKm0R/zsx/ffH7dGO5sknrP5aaOWY60pHEU1yhs61P9hcUoZO02U6stKBsuya+pH5dyiG0PwkSO+p1OZbPl7i1mfIIoTn56+27+4YcJcBpQkRHzGszmb0AZfZLKj6SXqGvrKaMTe8fpPm25Icx5/BGLJdZlZPgWUWQoohDh5JrHkC23ReiR5lcT0mQpR5MRsXb5/ffZ7VfrQ10KxPPsH9MzbYoPoCRCKUKeunlg1Fz3TinDYy/KDJln0YJ9VtTASGfS+2Le4CWfi65P38LMWr//MkPyYDtGTtPasgvpGPZt5fCoku1HMdr4+f9HKQaRx6QNXz4CCAqU/Kgge/SH8Y8IUiUTceQ6ECHDvzGaJrCf8NEgWdMFAAA=";
    protected static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.ProgressBarUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.String paragraph;
    protected javax.swing.JProgressBar progressBar;
    protected ProgressBarUI progressBarUI = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void $afterCompleteSetup() {
            Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            Double x = (bounds.getWidth() - this.getWidth()) / 2;
            Double y = (bounds.getHeight() - this.getHeight()) / 2;
            this.setLocation(x.intValue(), y.intValue());      
        }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ProgressBarUI() {
        $initialize();
    }

    public ProgressBarUI(JAXXContext parentContext) {
        Util.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doWindowClosing__on__progressBarUI(java.awt.event.WindowEvent event) {
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.String getParagraph() {
        return paragraph;
    }

    public javax.swing.JProgressBar getProgressBar() {
        return progressBar;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setParagraph(java.lang.String newValue) {
        java.lang.String oldValue = this.paragraph;
        this.paragraph = newValue;
        firePropertyChange(PROPERTY_PARAGRAPH, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToProgressBarUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(progressBar);
    }

    protected void createParagraph() {
        $objectMap.put("paragraph", paragraph = null);
    }

    protected void createProgressBar() {
        $objectMap.put("progressBar", progressBar = new javax.swing.JProgressBar());
        progressBar.setName("progressBar");
        progressBar.setIndeterminate(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToProgressBarUI();
        
        // apply 2 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("progressBarUI", this);
        createParagraph();
        createProgressBar();
        // inline creation of progressBarUI
        setName("progressBarUI");
        SwingUtil.setComponentHeight(progressBarUI,50);
        progressBarUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.progressBar.title"));
        SwingUtil.setComponentWidth(progressBarUI,250);
        progressBarUI.addWindowListener(Util.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__progressBarUI"));
        
        $completeSetup();
    }

}