/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiClientDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import com.jurismarches.vradi.ui.email.ClientEmailContentTableModel;
import com.jurismarches.vradi.ui.email.EmailListByClientUI;
import com.jurismarches.vradi.ui.email.EmailListByFormUI;
import com.jurismarches.vradi.ui.email.EmailPopupUI;
import com.jurismarches.vradi.ui.email.FormEmailContentTableModel;
import com.jurismarches.vradi.ui.email.ParagraphEditorDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.WikittyExtension;

public class EmailHandler
implements JAXXAction {
    private static final Log log = LogFactory.getLog(EmailHandler.class);

    public JAXXInitialContext init(JAXXContext parentContext, Object ... datas) {
        return new JAXXInitialContext().add((Object)parentContext).add((Object)this);
    }

    EmailPopupUI getUI(JAXXContext context) {
        if (context instanceof EmailPopupUI) {
            return (EmailPopupUI)context;
        }
        EmailPopupUI ui = (EmailPopupUI)VradiContext.EMAIL_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    void close(JAXXContext context) {
        EmailPopupUI ui = this.getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    protected VradiStorageService getVradiStorageService() {
        return ServiceHelper.getVradiStorageService();
    }

    List<VradiSendingDTO> getFormsByClients(EmailListByClientUI ui) {
        List<Object> result = new ArrayList<VradiSendingDTO>();
        try {
            result = this.getVradiStorageService().getFormsByClients((String)ui.getCriteria().getDateTypeSelection().getSelectedItem(), ui.getCriteria().getFromDate().getDate(), ui.getCriteria().getToDate().getDate(), (WikittyExtension)ui.getCriteria().getFormTypeSelection().getSelectedItem());
        }
        catch (TechnicalException e) {
            e.printStackTrace();
        }
        return result;
    }

    Map<Form, List<Client>> getClientsByForms(EmailListByFormUI ui) {
        Map<Object, List<Object>> result = new HashMap<Form, List<Client>>();
        try {
            result = this.getVradiStorageService().getClientsByForms((String)ui.getCriteria().getDateTypeSelection().getSelectedItem(), ui.getCriteria().getFromDate().getDate(), ui.getCriteria().getToDate().getDate(), (WikittyExtension)ui.getCriteria().getFormTypeSelection().getSelectedItem());
        }
        catch (TechnicalException e) {
            e.printStackTrace();
        }
        for (Map.Entry entry : result.entrySet()) {
            log.info((Object)(entry.getKey() + " : " + entry.getValue()));
        }
        return result;
    }

    public void bindEmailsWithForms() {
        try {
            this.getVradiStorageService().bindFormsToClients();
        }
        catch (TechnicalException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClientEmailContentTableModel(EmailListByClientUI ui) {
        ClientEmailContentTableModel contentModel = ui.getContentModel();
        contentModel.setValueIsAdjusting(true);
        try {
            contentModel.clear();
            int maxForms = 0;
            for (VradiSendingDTO sendingDTO : this.getFormsByClients(ui)) {
                maxForms = Math.max(maxForms, sendingDTO.getFormDTOs().size());
                contentModel.addEntry(sendingDTO);
            }
            ui.getContent().setRowHeight(maxForms > 1 ? 19 * maxForms : 19);
        }
        finally {
            contentModel.fireTableDataChanged();
            contentModel.setValueIsAdjusting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFormEmailContentTableModel(EmailListByFormUI ui) {
        FormEmailContentTableModel contentModel = ui.getContentModel();
        contentModel.setValueIsAdjusting(true);
        ui.getContent().getColumnModel().getColumn(1).setCellRenderer(new ClientListCellRenderer());
        try {
            contentModel.clear();
            int maxClients = 0;
            for (Map.Entry<Form, List<Client>> entry : this.getClientsByForms(ui).entrySet()) {
                maxClients = Math.max(maxClients, entry.getValue().size());
                contentModel.addEntry(entry.getKey().getName(), entry.getValue());
            }
            ui.getContent().setRowHeight(maxClients > 1 ? 19 * maxClients : 19);
        }
        finally {
            contentModel.fireTableDataChanged();
            contentModel.setValueIsAdjusting(false);
        }
    }

    public class ParagraphCellRenderer
    extends JPanel
    implements TableCellRenderer {
        protected JAXXContext context = null;

        public ParagraphCellRenderer(JAXXContext context) {
            this.context = context;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            String paragraph = (String)value;
            this.add(new JTextArea(paragraph));
            JButton edit = new JButton("...");
            edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new ParagraphEditorDialog(ParagraphCellRenderer.this.context).setVisible(true);
                }
            });
            this.add(new JButton());
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public class ClientCellRenderer
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            VradiClientDTO client = (VradiClientDTO)value;
            this.setText(client.getName());
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public class ClientListCellRenderer
    extends JList
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            List values = (List)value;
            String[] clientNames = new String[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                clientNames[i] = ((Client)values.get(i)).getName();
            }
            this.setListData(clientNames);
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public class FormListCellRenderer
    extends JList
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            List values = (List)value;
            String[] formNames = new String[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                formNames[i] = ((Form)values.get(i)).getName();
            }
            this.setListData(formNames);
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }
}

