package com.jurismarches.vradi.ui;

import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.*;
import java.util.Arrays;
import java.util.Collection;

/**
 * Classe de méthodes utiles pour les ui.
 * <p/>
 * User: chemit
 * Date: 23 nov. 2009
 * Time: 11:51:14
 */
public class UIHelper extends SwingUtil {

    /**
     * Logger
     */
    private static final Log log = LogFactory.getLog(UIHelper.class);


    private UIHelper() {
        // pas d'instance
    }

    /**
     * Met à jour le modèle de sélection {@code list} donnée avec l'objet {@code value} entrant.
     * <p/>
     * {@code value} represente normalement une collection de données.
     *
     * @param list  la liste à updater
     * @param value la liste des valeurs de la selection de la liste.
     */
    public static void updateListSelection(JList list, Object value) {

        list.setValueIsAdjusting(true);
        list.clearSelection();

        try {
            if (value != null) {

                // la valeur doit être une collection, on met a jour le model de selection

                int size = list.getModel().getSize();
                Collection<?> valuesToSelect = (Collection<?>) value;
                int[] indexToSelect = new int[valuesToSelect.size()];
                int index = 0;
                for (Object v : valuesToSelect) {
                    for (int i = 0; i < size; i++) {
                        Object o = list.getModel().getElementAt(i);
                        if (o.equals(v)) {
                            indexToSelect[index++] = i;
                            break;
                        }
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("index to select = " + Arrays.toString(indexToSelect));
                }
                list.setSelectedIndices(indexToSelect);
            }

        } finally {

            list.setValueIsAdjusting(false);
        }
    }
}
