/*
 * *##% 
 * vradi-swing
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Thesaurus {
    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(Thesaurus.class);

    protected boolean toSave = false;
    protected boolean toDelete = false;
    protected TreeNode bean;
    protected String name;
    protected String wikittyId;
    protected TreeNode parent;
    protected Map<String, Thesaurus> children = new HashMap<String, Thesaurus>();

    public Thesaurus(TreeNode bean) {
        setBean(bean);
    }

    public boolean isToDelete() {
        return toDelete;
    }

    public void setToDelete(boolean toDelete) {
        this.toDelete = toDelete;
        if (children != null){
            for (Thesaurus child : getChildren()){
                child.setToDelete(toDelete);
            }
        }
    }

    public boolean isToSave() {
        return toSave;
    }

    public void setToSave(boolean toSave) {
        this.toSave = toSave;
    }

    public TreeNode getBean() {
        bean.setName(getName());
        bean.clearChildren();
        for (Thesaurus child : getChildren()) {
            bean.addChildren(child.getWikittyId());
        }
        if (parent != null) {
            bean.setParent(parent.getWikittyId());
        }
        return bean;
    }

    public void setBean(TreeNode bean) {
        this.bean = bean;
        setName(bean.getName());
        this.setWikittyId(bean.getWikittyId());
        VradiStorageService service = ServiceHelper.getVradiStorageService();
        try {
            if (bean.getChildren() != null) {
                for (String thesaurusId : bean.getChildren()) {
                    TreeNode treeNodeChild = service.getThesaurus(thesaurusId);
                    if (treeNodeChild != null) {
                        addChild(new Thesaurus(treeNodeChild));
                    }
                }
            }
            String parent = bean.getParent();
            if (parent != null) {
                TreeNode treeNodeParent = service.getThesaurus(parent);
                if (treeNodeParent != null) {
                    setParent(treeNodeParent);
                }
            }
        } catch (TechnicalException e) {
            log.error("Cant find thesaurus ", e);
            ErrorDialogUI.showError(e);
        }
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWikittyId() {
        return wikittyId;
    }

    public void setWikittyId(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public TreeNode getParent() {
        return parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public Collection<Thesaurus> getChildren() {
        return children.values();
    }

    public void addChild(Thesaurus element) {
        bean.addChildren(element.getWikittyId());
        children.put(element.getWikittyId(), element);
    }

    public void clearChildren() {
        bean.clearChildren();
        children.clear();
    }

    public void removeChild(Thesaurus child) {
        bean.removeChildren(child.getWikittyId());
        children.remove(child);
    }

    public boolean addChildRecursif(Thesaurus child) {
        TreeNode p = child.getParent();
        if (bean.equals(p)) {
            children.put(child.getWikittyId(), child);
            return true;
        } else {
            for (Thesaurus c : children.values()) {
                return c.addChildRecursif(child);
            }
        }
        return false;
    }

    public Thesaurus removeThesaurusRecursivly(String id) {
        Thesaurus thesaurus = children.get(id);
        if (thesaurus != null) {
            return children.remove(id);
        } else {
            for (Thesaurus c : children.values()) {
                return c.removeThesaurusRecursivly(id);
            }
        }
        return null;
    }

    public Thesaurus findThesaurus(String id) {
        Thesaurus thesaurus = children.get(id);
        if (thesaurus != null) {
            return thesaurus;
        } else {
            for (Thesaurus c : children.values()) {
                return c.findThesaurus(id);
            }
        }
        return null;
    }

    public String getRecursifName() {
        return getRecursifName(getName());
    }

    protected String getRecursifName(String name){
        Collection<Thesaurus> children = getChildren();
        if (children != null){
            for (Thesaurus child : children){
                name += ", " + child.getRecursifName(); 
            }
        }
        return name;
    }
}
