/*
 * *##% 
 * vradi-swing
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.n_;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;

import javax.swing.table.AbstractTableModel;
import java.text.DateFormat;
import java.util.*;

/**
 * @author letellier
 */
public class OfferListTableModel extends AbstractTableModel {

    /**
     * to use log facility, just put in your code: log.info(\"...\");
     */
    static private Log log = LogFactory.getLog(OfferListTableModel.class);

    protected List<Form> datas;
    protected Map<String, TreeNode> thesaurus;
    protected List<String> columnNames;

    public OfferListTableModel(List<Form> datas) {

        columnNames = new ArrayList<String>();
        columnNames.add(n_("vradi.offer.name"));
        columnNames.add(n_("vradi.offerEdit.datePub"));
        columnNames.add(n_("vradi.offer.statut"));

        // Adding thesaurus to display
        thesaurus = new HashMap<String, TreeNode>();
        List<String> columnsThesaurusId = VradiHelper.getVradiListColumns();
        for (String id : columnsThesaurusId) {
            try {
                TreeNode t = ServiceHelper.getVradiStorageService().getThesaurus(id);
                if (t != null) {
                    thesaurus.put(t.getName(), t);
                    columnNames.add(t.getName());
                    if (log.isDebugEnabled()) {
                        log.debug("Adding Thesaurus name : " + t.getName());
                    }
                } else {
                    log.error("Cant get thesaurus : " + id);
                }
            } catch (TechnicalException e) {
                log.error("Cant get thesaurus : " + id, e);
                ErrorDialogUI.showError(e);
            }
        }

        this.datas = datas != null ? datas : new ArrayList<Form>();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public String getColumnName(int col) {
        if (col > 0) {
            return columnNames.get(col);
        }
        return "";
    }

    @Override
    public int getRowCount() {
        int count = datas.size();
        return count;
    }

    @Override
    public int getColumnCount() {
        return columnNames.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < datas.size() && datas.get(row) != null) {
            if (col < 3) {
                // Data
                if (col == 0) {
                    return datas.get(row).getName();
                } else if (col == 1) {
                    return DateFormat.getDateInstance(DateFormat.SHORT, Locale.FRANCE)
                            .format(datas.get(row).getDatePub());
                } else if (col == 2) {
                    return datas.get(row).getStatut();
                }
            } else {
                // Thesaurus
                Set<String> thesaurusIdOfBean = datas.get(row).getThesaurus();

                String result = "";
                if (thesaurusIdOfBean != null) {
                    String name = columnNames.get(col);
                    if (log.isDebugEnabled()) {
                        log.debug("Want thesaurus name : " + name);
                    }
                    TreeNode thesaurusOfColumns = thesaurus.get(name);
                    for (String idOfBean : thesaurusIdOfBean) {
                        Set<String> children = thesaurusOfColumns.getChildren();
                        if (children != null) {
                            if (children.contains(idOfBean)) {
                                TreeNode thesaurusToDisplay = null;
                                try {
                                    thesaurusToDisplay = ServiceHelper.getVradiStorageService().getThesaurus(idOfBean);
                                } catch (TechnicalException e) {
                                    log.error("cant get thesaurus : " + idOfBean, e);
                                }
                                if (thesaurusToDisplay != null) {
                                    result += thesaurusToDisplay.getName() + ", ";
                                }
                            }
                        }
                    }
                    if (result.length() > 0) {
                        result = result.substring(0, result.length() - 2);
                    }
                }
                return result;
            }
        }
        return null;
    }

    @Override
    public Class getColumnClass(int c) {
        return getValueAt(0, c) == null ? null : getValueAt(0, c).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    public List<Form> getDatas() {
        return datas;
    }

    public void setDatas(List<Form> datas) {
        this.datas = datas != null ? datas : new ArrayList<Form>();
//        if (datas != null && !datas.isEmpty()){
        fireTableDataChanged();
//        }
    }

    public TreeNode getThesaurusByName(String name) {
        return thesaurus.get(name);
    }
}
