/*
 * *##% 
 * vradi-swing
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.ui.editors.*;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

import javax.swing.*;
import java.awt.*;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * @author letellier
 */
public class OfferEditHandler {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(OfferEditHandler.class);

    /**
     * Methode pour initialiser l'ui principale sans l'afficher.
     *
     * @param rootContext le context applicatif
     * @param data
     * @return l'ui instancie et initialisee mais non visible encore
     */
    public OfferEditUI initUI(JAXXContext rootContext, Form data) {

        JAXXInitialContext context = new JAXXInitialContext().add(rootContext);

        // show main ui
        context.add(data);
        context.add(this);
        context.add(new ThesaurusHandler());
        OfferEditUI ui = new OfferEditUI(context);

        fillfields(ui, data);

        // Adding in referenciel
        List<OfferEditUI> editUIs = VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(VradiContext.get());
        if (editUIs == null) {
            editUIs = new ArrayList<OfferEditUI>();
            VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.setContextValue(VradiContext.get(), editUIs);
        }
        VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(VradiContext.get()).add(ui);

        initThesaurus(context, ui);

        if (log.isDebugEnabled()) {
            log.debug("There is " + VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(VradiContext.get()).size() + " OfferEditUI in referenciel");
        }

        return ui;
    }

    public void initThesaurus(JAXXContext context, OfferEditUI ui) {
        // Remove all thsuaurus
        JPanel thesaurusPanel = ui.getThesaurus();
        thesaurusPanel.removeAll();

        ThesaurusHandler thesaurusHandler = new ThesaurusHandler();

        List<String> thesaurusId = VradiHelper.getVradiListThesaurus();

        // Get rootThesaurus
        Thesaurus rootThesaurus = null;
        try {
            TreeNode rootTreeNode = ServiceHelper.getVradiStorageService().getRootThesaurus();
            rootThesaurus = new Thesaurus(rootTreeNode);
        } catch (TechnicalException e) {
            log.error("Cant get root thesaurus ", e);
            ErrorDialogUI.showError(e);
        }
        // If no properties found and if root dont hav children display root thesaurus
        Collection<Thesaurus> thesaurusChildren = rootThesaurus.getChildren();
        List<Thesaurus> thesaurusSaved = new ArrayList<Thesaurus>();
        log.info("chidren size : " + thesaurusChildren.size());
        if (thesaurusChildren != null && !thesaurusChildren.isEmpty()) {
            // Find saved thesaurus
            if (thesaurusId != null) {
                for (String id : thesaurusId) {
                    Thesaurus savedThesaurus = rootThesaurus.findThesaurus(id);
                    if (savedThesaurus != null) {
                        thesaurusSaved.add(savedThesaurus);
                        for (Thesaurus child : thesaurusChildren) {
                            // Remove child thesaurus
                            child.removeThesaurusRecursivly(id);
                        }
                    }
                }
            }
            // Display children thesaurus
            for (Thesaurus child : thesaurusChildren) {
                thesaurusPanel.add(thesaurusHandler.initUI(context, child, ui.getData(), false));
            }

            // Display saved thesaurus
            for (Thesaurus saved : thesaurusSaved) {
                thesaurusPanel.add(thesaurusHandler.initUI(context, saved, ui.getData(), true));
            }
        }
    }

    protected void fillfields(OfferEditUI ui, Form data) {
        // FIXME : to be removed in future version
        for (WikittyExtension ext : data.getExtensions()) {
            for (String fieldName : ext.getFieldNames()) {
                FieldType type = ext.getFieldType(fieldName);
                createField(ui, ext.getName(), fieldName, type, data);
            }
        }
    }

    protected void createField(OfferEditUI ui, String ext, String fieldName, FieldType type, BusinessEntity data) {
        JPanel content = ui.getContent();
        if (!type.isCollection()) {
            if (FieldTypeEnum.DATE.isType(type) || FieldType.TYPE.DATE.equals(type.getType())) {
                DateEditor editor = new DateEditor();
                editor.setFieldName(fieldName);
                editor.setExtensionName(ext);
                editor.setData((Date) data.getField(ext, fieldName));
                content.add(editor);
            } else if (FieldTypeEnum.EMAIL.isType(type)) {
                EmailEditor editor = new EmailEditor();
                editor.setFieldName(fieldName);
                editor.setExtensionName(ext);
                editor.setData((String) data.getField(ext, fieldName));
                content.add(editor);
            } else if (FieldTypeEnum.NUMBER.isType(type) || FieldType.TYPE.NUMERIC.equals(type.getType())) {
                NumEditor editor = new NumEditor();
                editor.setFieldName(fieldName);
                editor.setExtensionName(ext);
                log.info((BigDecimal) data.getField(ext, fieldName));
                editor.setData((BigDecimal) data.getField(ext, fieldName));
                content.add(editor);
            } else if (FieldTypeEnum.TEXT.isType(type)) {
                TextEditor editor = new TextEditor();
                editor.setFieldName(fieldName);
                editor.setExtensionName(ext);
                editor.setData((String) data.getField(ext, fieldName));
                content.add(editor);
            } else if (FieldTypeEnum.URL.isType(type)) {
                UrlEditor editor = new UrlEditor();
                editor.setFieldName(fieldName);
                editor.setExtensionName(ext);
                editor.setData((String) data.getField(ext, fieldName));
                content.add(editor);
            } else {
                StringEditor editor = new StringEditor();
                editor.setFieldName(fieldName);
                editor.setExtensionName(ext);
                editor.setData((String) data.getField(ext, fieldName));
                content.add(editor);
            }
        }
    }

    OfferEditUI getUI(JAXXContext context) {
        if (context instanceof OfferEditUI) {
            return (OfferEditUI) context;
        }
//        OfferEditUI ui = VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue(context);
        return null;
    }

    public void openThesaurusPopup(JAXXContext context) {
//        ThesaurusHandler handler = new ThesaurusHandler();
//        ThesaurusUI ui = handler.initUI(context);
//        ui.setVisible(true);
    }

    public void openRequestPopup(JAXXContext context, List<String> queries) {
        RequestFormViewHandler handler = new RequestFormViewHandler();
        RequestFormViewUI ui = handler.initUI(context);
        for (String query : queries) {
            ui.getContent().add(new JLabel(query));
        }
        ui.setVisible(true);
    }

    protected void addPropositions(JAXXContext context, Object[] props) {
        for (Object p : props) {
            getUI(context).propositionListModel.removeElement(p);
        }
    }

    protected void save(JAXXContext context, Form form) {
        log.info("Save form " + form.getName());
        // Remove all thesaurus
        form.clearThesaurus();
        // Find all thesaurus selected
        for (Component c : getUI(context).getThesaurus().getComponents()) {
            ThesaurusUI thesaurusUI = (ThesaurusUI) c;
            DefaultListModel model = thesaurusUI.getThesaurusSelectedModel();
            Object[] selected = model.toArray();

            for (Object s : selected) {
                TreeNode treeNode = (TreeNode) s;
                if (log.isDebugEnabled()) {
                    log.debug("treeNode to save : " + treeNode.getName() + " in form : " + form.getName());
                }
                // Save thesaurus
                form.addThesaurus(treeNode.getWikittyId());
            }
        }
        for (Component c : getUI(context).getContent().getComponents()) {
            VradiEditor editor = (VradiEditor) c;
            FieldType type = form.getFieldType(editor.getExtensionName(), editor.getFieldName());
            if (FieldTypeEnum.DATE.isType(type) || FieldType.TYPE.DATE.equals(type.getType())) {
                DateEditor dateEditor = (DateEditor) editor;
                form.setField(editor.getExtensionName(), editor.getFieldName(), dateEditor.getEditor().getDate());
                if (log.isDebugEnabled()) {
                    log.debug("field to save : " + editor.getFieldName() + " = " + dateEditor.getEditor().getDate() + " in form : " + form.getName());
                }
            } else if (FieldTypeEnum.EMAIL.isType(type)) {
                EmailEditor emailEditor = (EmailEditor) editor;
                form.setField(editor.getExtensionName(), editor.getFieldName(), emailEditor.getEditor().getText());
                if (log.isDebugEnabled()) {
                    log.debug("field to save : " + editor.getFieldName() + " = " + emailEditor.getEditor().getText() + " in form : " + form.getName());
                }
            } else if (FieldTypeEnum.NUMBER.isType(type) || FieldType.TYPE.NUMERIC.equals(type.getType())) {
                NumEditor numEditor = (NumEditor) editor;
                form.setField(editor.getExtensionName(), editor.getFieldName(), numEditor.getEditor().getModel());
                if (log.isDebugEnabled()) {
                    log.debug("field to save : " + editor.getFieldName() + " = " + numEditor.getEditor().getModel() + " in form : " + form.getName());
                }
            } else if (FieldTypeEnum.TEXT.isType(type)) {
                TextEditor textEditor = (TextEditor) editor;
                form.setField(editor.getExtensionName(), editor.getFieldName(), textEditor.getEditor().getText());
                if (log.isDebugEnabled()) {
                    log.debug("field to save : " + editor.getFieldName() + " = " + textEditor.getEditor().getText() + " in form : " + form.getName());
                }
            } else if (FieldTypeEnum.URL.isType(type)) {
                UrlEditor urlEditor = (UrlEditor) editor;
                form.setField(editor.getExtensionName(), editor.getFieldName(), urlEditor.getEditor().getText());
                if (log.isDebugEnabled()) {
                    log.debug("field to save : " + editor.getFieldName() + " = " + urlEditor.getEditor().getText() + " in form : " + form.getName());
                }
            } else {
                StringEditor stringEditor = (StringEditor) editor;
                form.setField(editor.getExtensionName(), editor.getFieldName(), stringEditor.getEditor().getText());
                if (log.isDebugEnabled()) {
                    log.debug("field to save : " + editor.getFieldName() + " = " + stringEditor.getEditor().getText() + " in form : " + form.getName());
                }
            }
        }
        try {
            ServiceHelper.getVradiStorageService().updateForm(form);
        } catch (TechnicalException eee) {
            log.error("Cant save form : " + form.getName(), eee);
            ErrorDialogUI.showError(eee);
        }
    }

    protected void update(JAXXContext context) {
        VradiMainUIHandler rootHandler = VradiContext.get().getContextValue(VradiMainUIHandler.class);
        rootHandler.goToHome(context);
    }

    protected void add(JAXXContext context) {
        openThesaurusPopup(context);
    }

    protected void test(JAXXContext context, Form form) {
        List<String> queries = new ArrayList<String>();
        try {
            queries = ServiceHelper.getVradiStorageService().getQueriesReturningForm(form);
        } catch (TechnicalException eee) {
            log.error(eee);
            ErrorDialogUI.showError(eee);
        }
        openRequestPopup(context, queries);
    }

    protected void addFile(JAXXContext context) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.showOpenDialog(getUI(context));

        File file = fileChooser.getSelectedFile();
//        getUI(context).fileList.addItem(new Item(file.getName(), file.getName(), file.getPath(), false));
    }

    protected void removeFile(JAXXContext context) {
//        java.util.List<Item> itemsToRemove = getUI(context).fileList.getSelectedItems();
//        getUI(context).fileList.removeAllItems(itemsToRemove);
    }

    public void addThesaurus(JAXXContext context, Thesaurus thesToAdd) {
        for (Component c : getUI(context).getThesaurus().getComponents()) {
            ThesaurusUI ui = (ThesaurusUI) c;
            ThesaurusTreeHelper helper = ui.helper;
            NavigationTreeNode rootNode = helper.getRootNode();
            Thesaurus root = (Thesaurus) rootNode.getBean();
            log.info("Try to add " + thesToAdd.getName() + " to " + root.getName());
            if (root.addChildRecursif(thesToAdd)) {
                log.info("succes");
                helper.setRootThesaurus(root);
                helper.createTreeModel(context);
                ui.getThesaurus().setModel(helper.getTreeModel(context));
                break;
            }
        }
    }
}
