/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.ui.OfferEditHandler;
import com.jurismarches.vradi.ui.OfferListHandler;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.email.EmailHandler;
import com.jurismarches.vradi.ui.email.EmailPopupUI;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.editor.config.ConfigUI;
import jaxx.runtime.swing.editor.config.ConfigUIBuilder;
import jaxx.runtime.swing.editor.config.model.ConfigUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;

@DefaultApplicationContext.AutoLoad
public class VradiMainUIHandler {
    private static Log log = LogFactory.getLog(VradiMainUIHandler.class);

    public VradiMainUI initUI(JAXXContext rootContext, boolean fullscreen) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        VradiMainUI ui = new VradiMainUI((JAXXContext)context);
        VradiContext.MAIN_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        ErrorDialogUI.init((Frame)ui);
        ui.getGraphicsConfiguration().getDevice().setFullScreenWindow(fullscreen ? ui : null);
        OfferListHandler handler = new OfferListHandler();
        context.add((Object)handler);
        this.changeContent((JAXXContext)context, handler.initUI((JAXXContext)ui, this));
        return ui;
    }

    public void changeContent(JAXXContext context, JComponent content) {
        VradiMainUI ui = this.getUI(context);
        ui.setContentPane(content);
        ui.setVisible(true);
    }

    public void edit(JAXXContext context, Form data) {
        OfferEditHandler handler = new OfferEditHandler();
        this.changeContent((JAXXContext)VradiContext.get(), handler.initUI(context, data));
    }

    public void goToHome(JAXXContext context) {
        OfferListHandler handler = new OfferListHandler();
        this.changeContent(context, handler.initUI(context, this));
    }

    public void changeLanguage(VradiMainUI mainUI, Locale newLocale) {
        VradiConfig config = mainUI.getConfig();
        config.setLocale(newLocale);
        I18n.init((Locale)newLocale);
        this.reloadUI(VradiContext.get(), config.isFullScreen());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(VradiMainUI ui) {
        log.info((Object)"Vradi quitting...");
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        try {
            ui.dispose();
        }
        finally {
            System.exit(0);
        }
    }

    public void changeScreen(VradiMainUI ui, boolean fullscreen) {
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        ui.getConfig().setFullscreen(fullscreen);
        this.reloadUI(VradiContext.get(), fullscreen);
    }

    protected void openAdminPopup(JAXXContext rootContext, int i) {
        AdminPopupUI ui = (AdminPopupUI)VradiContext.ADMIN_UI_ENTRY_DEF.getContextValue(rootContext);
        if (ui == null) {
            VradiMainUI mainUI = this.getUI(rootContext);
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)new AdminHandler());
            ui = new AdminPopupUI((JAXXContext)context, mainUI);
            VradiContext.ADMIN_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        }
        ui.showTab(i);
    }

    public void showAdminClient(JAXXContext context) {
        this.openAdminPopup(context, 0);
    }

    public void showAdminGroup(JAXXContext context) {
        this.openAdminPopup(context, 1);
    }

    public void showAdminForm(JAXXContext context) {
        this.openAdminPopup(context, 2);
    }

    public void showAdminXmlStream(JAXXContext context) {
        this.openAdminPopup(context, 3);
    }

    public void showAdminThesaurus(JAXXContext context) {
        this.openAdminPopup(context, 4);
    }

    protected void openEmailPopup(JAXXContext rootContext, int i) {
        EmailPopupUI ui = (EmailPopupUI)VradiContext.EMAIL_UI_ENTRY_DEF.getContextValue(rootContext);
        if (ui == null) {
            VradiMainUI mainUI = this.getUI(rootContext);
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)new EmailHandler());
            ui = new EmailPopupUI((JAXXContext)context);
            VradiContext.EMAIL_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        }
        ui.showTab(i);
        ui.setVisible(true);
    }

    public void showEmailByClient(JAXXContext context) {
        this.openEmailPopup(context, 0);
    }

    public void showEmailByForm(JAXXContext context) {
        this.openEmailPopup(context, 1);
    }

    public void showConfig(JAXXContext context) {
        VradiMainUI ui = this.getUI(context);
        VradiConfig config = (VradiConfig)((Object)context.getContextValue(VradiConfig.class));
        ConfigUIModel model = new ConfigUIModel((ApplicationConfig)config);
        model.addCategory(I18n.n_((String)"vradi.config.category.directories"), I18n.n_((String)"vradi.config.category.directories.description"), new ApplicationConfig.OptionDef[]{VradiConfig.Option.CONFIG_FILE});
        model.addCategory(I18n.n_((String)"vradi.config.category.other"), I18n.n_((String)"vradi.config.category.other.description"), new ApplicationConfig.OptionDef[]{VradiConfig.Option.FULL_SCREEN, VradiConfig.Option.LOCALE});
        ConfigUI configUI = ConfigUIBuilder.newConfigUI((JAXXContext)context, (ConfigUIModel)model, (String)"vradi.config.category.directories");
        ConfigUIBuilder.showConfigUI((ConfigUI)configUI, (Frame)ui, (boolean)false);
    }

    public void showHelp(JAXXContext context, String helpId) {
    }

    public void closeHelp(JAXXContext context) {
    }

    public void gotoSite(JAXXContext rootContext) {
        VradiConfig config = (VradiConfig)((Object)rootContext.getContextValue(VradiConfig.class));
        URL siteURL = config.getOptionAsURL("application.site.url");
        log.info((Object)("goto " + siteURL));
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(siteURL.toURI());
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                ErrorDialogUI.showError((Exception)ex);
            }
        }
    }

    public void showAbout(VradiMainUI ui) {
        AboutPanel about = new AboutPanel(){
            private static final long serialVersionUID = 1L;
        };
        about.setTitle(I18n._((String)"vradi.title.about"));
        about.setAboutText(I18n._((String)"vradi.about.message"));
        about.setBottomText(ui.getConfig().getCopyrightText());
        about.setLicenseFile("META-INF/vradi-swing-LICENSE.txt");
        about.setThirdpartyFile("META-INF/vradi-swing-THIRD-PARTY.txt");
        about.init();
        about.showInDialog((Frame)ui, true);
    }

    protected void reloadUI(VradiContext rootContext, boolean fullscreen) {
        ((VradiConfig)((Object)rootContext.getContextValue(VradiConfig.class))).removeJaxxPropertyChangeListener();
        VradiMainUI ui = this.getUI((JAXXContext)rootContext);
        if (ui != null) {
            ErrorDialogUI.init(null);
            VradiContext.MAIN_UI_ENTRY_DEF.removeContextValue((JAXXContext)rootContext);
            VradiContext.ADMIN_UI_ENTRY_DEF.removeContextValue((JAXXContext)rootContext);
            ui.dispose();
            ui.setVisible(false);
        }
        ui = this.initUI((JAXXContext)rootContext, fullscreen);
        ui.setVisible(true);
    }

    protected boolean ensureModification(JAXXContext rootContext) throws IllegalArgumentException {
        if (rootContext == null) {
            throw new IllegalArgumentException("rootContext can not be null");
        }
        VradiMainUI ui = this.getUI(rootContext);
        if (ui == null) {
            return true;
        }
        return true;
    }

    VradiMainUI getUI(JAXXContext context) {
        if (context instanceof VradiMainUI) {
            return (VradiMainUI)context;
        }
        VradiMainUI ui = (VradiMainUI)VradiContext.MAIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    public void createForm(JAXXContext rootContext, WikittyExtension extension) {
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(rootContext);
        if (ui != null) {
            String formName = null;
            formName = JOptionPane.showInputDialog(ui, I18n._((String)"vradi.menu.form.new.message", (Object[])new Object[]{extension.getName()}), I18n._((String)"vradi.menu.form.new.title", (Object[])new Object[]{extension.getName()}), 3);
            if (formName == null) {
                return;
            }
            while (formName.trim().equals("")) {
                formName = JOptionPane.showInputDialog(ui, I18n._((String)"vradi.menu.form.new.message.repeat", (Object[])new Object[]{extension.getName()}), I18n._((String)"vradi.menu.form.new.title", (Object[])new Object[]{extension.getName()}), 3);
            }
            log.debug((Object)("FormType selected : " + extension));
            if (extension == null) {
                return;
            }
            FormImpl form = new FormImpl();
            BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty)form;
            Wikitty wikitty = entityWikitty.getWikitty();
            wikitty.addExtension(extension);
            form = (Form)entityWikitty;
            if (formName != null && !formName.isEmpty()) {
                form.setName(formName);
            } else {
                form.setName(I18n._((String)"vradi.forms.new.defaultName"));
            }
            ui.getHandler().addEditPane(ui.getDelegateContext(), (Form)form);
        }
    }

    public void createFormMenu(final VradiMainUI ui) {
        try {
            List extensions = ServiceHelper.getVradiStorageService().getAllFormTypes();
            for (final WikittyExtension extension : extensions) {
                JMenuItem item = new JMenuItem(I18n._((String)"vradi.menu.form.new", (Object[])new Object[]{extension.getName()}));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        VradiMainUIHandler.this.createForm((JAXXContext)ui, extension);
                    }
                });
                ui.getMenuForm().add(item);
            }
        }
        catch (TechnicalException eee) {
            log.error((Object)("Can't load the form types : " + (Object)((Object)eee)));
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
    }
}

