/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.ui.OfferEditUI;
import com.jurismarches.vradi.ui.RequestFormViewHandler;
import com.jurismarches.vradi.ui.RequestFormViewUI;
import com.jurismarches.vradi.ui.Thesaurus;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.ThesaurusUI;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import com.jurismarches.vradi.ui.editors.DateEditor;
import com.jurismarches.vradi.ui.editors.EmailEditor;
import com.jurismarches.vradi.ui.editors.NumEditor;
import com.jurismarches.vradi.ui.editors.StringEditor;
import com.jurismarches.vradi.ui.editors.TextEditor;
import com.jurismarches.vradi.ui.editors.UrlEditor;
import com.jurismarches.vradi.ui.editors.VradiEditor;
import java.awt.Component;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreeModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

public class OfferEditHandler {
    private static final Log log = LogFactory.getLog(OfferEditHandler.class);

    public OfferEditUI initUI(JAXXContext rootContext, Form data) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        context.add((Object)data);
        context.add((Object)this);
        context.add((Object)new ThesaurusHandler());
        OfferEditUI ui = new OfferEditUI((JAXXContext)context);
        this.fillfields(ui, data);
        ArrayList editUIs = (ArrayList)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
        if (editUIs == null) {
            editUIs = new ArrayList();
            VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.setContextValue((JAXXContext)VradiContext.get(), editUIs);
        }
        ((List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get())).add(ui);
        this.initThesaurus((JAXXContext)context, ui);
        if (log.isDebugEnabled()) {
            log.debug((Object)("There is " + ((List)VradiContext.OFFERT_EDIT_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get())).size() + " OfferEditUI in referenciel"));
        }
        return ui;
    }

    public void initThesaurus(JAXXContext context, OfferEditUI ui) {
        JPanel thesaurusPanel = ui.getThesaurus();
        thesaurusPanel.removeAll();
        ThesaurusHandler thesaurusHandler = new ThesaurusHandler();
        List<String> thesaurusId = VradiHelper.getVradiListThesaurus();
        Thesaurus rootThesaurus = null;
        try {
            TreeNode rootTreeNode = ServiceHelper.getVradiStorageService().getRootThesaurus();
            rootThesaurus = new Thesaurus(rootTreeNode);
        }
        catch (TechnicalException e) {
            log.error((Object)"Cant get root thesaurus ", (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
        Collection<Thesaurus> thesaurusChildren = rootThesaurus.getChildren();
        ArrayList<Thesaurus> thesaurusSaved = new ArrayList<Thesaurus>();
        log.info((Object)("chidren size : " + thesaurusChildren.size()));
        if (thesaurusChildren != null && !thesaurusChildren.isEmpty()) {
            if (thesaurusId != null) {
                for (String id : thesaurusId) {
                    Thesaurus savedThesaurus = rootThesaurus.findThesaurus(id);
                    if (savedThesaurus == null) continue;
                    thesaurusSaved.add(savedThesaurus);
                    for (Thesaurus child : thesaurusChildren) {
                        child.removeThesaurusRecursivly(id);
                    }
                }
            }
            for (Thesaurus child : thesaurusChildren) {
                thesaurusPanel.add((Component)((Object)thesaurusHandler.initUI(context, child, ui.getData(), false)));
            }
            for (Thesaurus saved : thesaurusSaved) {
                thesaurusPanel.add((Component)((Object)thesaurusHandler.initUI(context, saved, ui.getData(), true)));
            }
        }
    }

    protected void fillfields(OfferEditUI ui, Form data) {
        for (WikittyExtension ext : data.getExtensions()) {
            for (String fieldName : ext.getFieldNames()) {
                FieldType type = ext.getFieldType(fieldName);
                this.createField(ui, ext.getName(), fieldName, type, data);
            }
        }
    }

    protected void createField(OfferEditUI ui, String ext, String fieldName, FieldType type, BusinessEntity data) {
        JPanel content = ui.getContent();
        if (!type.isCollection()) {
            if (FieldTypeEnum.DATE.isType(type) || FieldType.TYPE.DATE.equals((Object)type.getType())) {
                DateEditor editor = new DateEditor();
                editor.setFieldName(fieldName);
                editor.setExtensionName(ext);
                editor.setData((Date)data.getField(ext, fieldName));
                content.add((Component)((Object)editor));
            } else if (FieldTypeEnum.EMAIL.isType(type)) {
                EmailEditor editor = new EmailEditor();
                editor.setFieldName(fieldName);
                editor.setExtensionName(ext);
                editor.setData((String)data.getField(ext, fieldName));
                content.add((Component)((Object)editor));
            } else if (FieldTypeEnum.NUMBER.isType(type) || FieldType.TYPE.NUMERIC.equals((Object)type.getType())) {
                NumEditor editor = new NumEditor();
                editor.setFieldName(fieldName);
                editor.setExtensionName(ext);
                log.info((Object)((BigDecimal)data.getField(ext, fieldName)));
                editor.setData((BigDecimal)data.getField(ext, fieldName));
                content.add((Component)((Object)editor));
            } else if (FieldTypeEnum.TEXT.isType(type)) {
                TextEditor editor = new TextEditor();
                editor.setFieldName(fieldName);
                editor.setExtensionName(ext);
                editor.setData((String)data.getField(ext, fieldName));
                content.add((Component)((Object)editor));
            } else if (FieldTypeEnum.URL.isType(type)) {
                UrlEditor editor = new UrlEditor();
                editor.setFieldName(fieldName);
                editor.setExtensionName(ext);
                editor.setData((String)data.getField(ext, fieldName));
                content.add((Component)((Object)editor));
            } else {
                StringEditor editor = new StringEditor();
                editor.setFieldName(fieldName);
                editor.setExtensionName(ext);
                editor.setData((String)data.getField(ext, fieldName));
                content.add((Component)((Object)editor));
            }
        }
    }

    OfferEditUI getUI(JAXXContext context) {
        if (context instanceof OfferEditUI) {
            return (OfferEditUI)context;
        }
        return null;
    }

    public void openThesaurusPopup(JAXXContext context) {
    }

    public void openRequestPopup(JAXXContext context, List<String> queries) {
        RequestFormViewHandler handler = new RequestFormViewHandler();
        RequestFormViewUI ui = handler.initUI(context);
        for (String query : queries) {
            ui.getContent().add((Component)new JLabel(query));
        }
        ui.setVisible(true);
    }

    protected void addPropositions(JAXXContext context, Object[] props) {
        for (Object p : props) {
            this.getUI((JAXXContext)context).propositionListModel.removeElement(p);
        }
    }

    protected void save(JAXXContext context, Form form) {
        log.info((Object)("Save form " + form.getName()));
        form.clearThesaurus();
        for (Component c : this.getUI(context).getThesaurus().getComponents()) {
            Object[] selected;
            ThesaurusUI thesaurusUI = (ThesaurusUI)((Object)c);
            DefaultListModel model = thesaurusUI.getThesaurusSelectedModel();
            for (Object s : selected = model.toArray()) {
                TreeNode treeNode = (TreeNode)s;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("treeNode to save : " + treeNode.getName() + " in form : " + form.getName()));
                }
                form.addThesaurus(treeNode.getWikittyId());
            }
        }
        for (Component c : this.getUI(context).getContent().getComponents()) {
            VradiEditor editor = (VradiEditor)((Object)c);
            FieldType type = form.getFieldType(editor.getExtensionName(), editor.getFieldName());
            if (FieldTypeEnum.DATE.isType(type) || FieldType.TYPE.DATE.equals((Object)type.getType())) {
                DateEditor dateEditor = (DateEditor)editor;
                form.setField(editor.getExtensionName(), editor.getFieldName(), dateEditor.getEditor().getDate());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("field to save : " + editor.getFieldName() + " = " + dateEditor.getEditor().getDate() + " in form : " + form.getName()));
                continue;
            }
            if (FieldTypeEnum.EMAIL.isType(type)) {
                EmailEditor emailEditor = (EmailEditor)editor;
                form.setField(editor.getExtensionName(), editor.getFieldName(), emailEditor.getEditor().getText());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("field to save : " + editor.getFieldName() + " = " + emailEditor.getEditor().getText() + " in form : " + form.getName()));
                continue;
            }
            if (FieldTypeEnum.NUMBER.isType(type) || FieldType.TYPE.NUMERIC.equals((Object)type.getType())) {
                NumEditor numEditor = (NumEditor)editor;
                form.setField(editor.getExtensionName(), editor.getFieldName(), numEditor.getEditor().getModel());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("field to save : " + editor.getFieldName() + " = " + numEditor.getEditor().getModel() + " in form : " + form.getName()));
                continue;
            }
            if (FieldTypeEnum.TEXT.isType(type)) {
                TextEditor textEditor = (TextEditor)editor;
                form.setField(editor.getExtensionName(), editor.getFieldName(), textEditor.getEditor().getText());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("field to save : " + editor.getFieldName() + " = " + textEditor.getEditor().getText() + " in form : " + form.getName()));
                continue;
            }
            if (FieldTypeEnum.URL.isType(type)) {
                UrlEditor urlEditor = (UrlEditor)editor;
                form.setField(editor.getExtensionName(), editor.getFieldName(), urlEditor.getEditor().getText());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("field to save : " + editor.getFieldName() + " = " + urlEditor.getEditor().getText() + " in form : " + form.getName()));
                continue;
            }
            StringEditor stringEditor = (StringEditor)editor;
            form.setField(editor.getExtensionName(), editor.getFieldName(), stringEditor.getEditor().getText());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("field to save : " + editor.getFieldName() + " = " + stringEditor.getEditor().getText() + " in form : " + form.getName()));
        }
        try {
            ServiceHelper.getVradiStorageService().updateForm(form);
        }
        catch (TechnicalException eee) {
            log.error((Object)("Cant save form : " + form.getName()), (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
    }

    protected void update(JAXXContext context) {
        VradiMainUIHandler rootHandler = (VradiMainUIHandler)VradiContext.get().getContextValue(VradiMainUIHandler.class);
        rootHandler.goToHome(context);
    }

    protected void add(JAXXContext context) {
        this.openThesaurusPopup(context);
    }

    protected void test(JAXXContext context, Form form) {
        ArrayList<String> queries = new ArrayList();
        try {
            queries = ServiceHelper.getVradiStorageService().getQueriesReturningForm(form);
        }
        catch (TechnicalException eee) {
            log.error((Object)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        this.openRequestPopup(context, queries);
    }

    protected void addFile(JAXXContext context) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.showOpenDialog(this.getUI(context));
        File file = fileChooser.getSelectedFile();
    }

    protected void removeFile(JAXXContext context) {
    }

    public void addThesaurus(JAXXContext context, Thesaurus thesToAdd) {
        for (Component c : this.getUI(context).getThesaurus().getComponents()) {
            ThesaurusUI ui = (ThesaurusUI)((Object)c);
            ThesaurusTreeHelper helper = ui.helper;
            NavigationTreeNode rootNode = helper.getRootNode();
            Thesaurus root = (Thesaurus)rootNode.getBean();
            log.info((Object)("Try to add " + thesToAdd.getName() + " to " + root.getName()));
            if (!root.addChildRecursif(thesToAdd)) continue;
            log.info((Object)"succes");
            helper.setRootThesaurus(root);
            helper.createTreeModel(context);
            ui.getThesaurus().setModel((TreeModel)helper.getTreeModel(context));
            break;
        }
    }
}

