/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.LocaleConverter;

public class I18nUtil {
    private static final Log log = LogFactory.getLog(I18nUtil.class);
    public static final String ISO_8859_1_ENCONDING = "ISO-8859-1";
    public static final String UTF_8_ENCONDING = "UTF-8";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final Locale DEFAULT_LOCALE = Locale.UK;

    public static Locale[] parseLocales(String str) throws IllegalArgumentException {
        ArrayList<Locale> result = new ArrayList<Locale>();
        String[] bundlesToUse = str.split(",");
        int j = bundlesToUse.length;
        for (int i = 0; i < j; ++i) {
            String s = bundlesToUse[i].trim();
            try {
                Locale l = (Locale)new LocaleConverter().convert(Locale.class, s);
                result.add(l);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("bundle " + s + " is not a valid locale,e");
            }
        }
        return result.toArray(new Locale[result.size()]);
    }

    public static Locale newLocale(String str) {
        if (str == null) {
            return I18nUtil.newLocale(null, null);
        }
        try {
            return (Locale)new LocaleConverter().convert(Locale.class, str);
        }
        catch (Exception e) {
            Logger.getLogger("org.nuiton.i18n.I18n").warning("could not load locale '" + str + " for reason : " + e.getMessage());
            return DEFAULT_LOCALE;
        }
    }

    public static Locale newLocale(String language, String country) {
        if (language == null) {
            language = System.getProperty("user.language", DEFAULT_LOCALE.getLanguage());
            country = System.getProperty("user.country", DEFAULT_LOCALE.getCountry());
        }
        return I18nUtil.newLocale(language + (country == null ? "" : '_' + country));
    }

    public static boolean containsDirectDirectory(URL url, String directory) throws IOException {
        String fileName = url.getFile();
        File file = new File(fileName.replaceAll("%20", " "));
        if (!file.exists()) {
            return false;
        }
        if (I18nUtil.isJar(fileName) || I18nUtil.isZip(fileName)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("zip to search " + file));
            }
            return new ZipFile(file).getEntry(directory + "/") != null;
        }
        if (file.isDirectory()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("directory to search " + file));
            }
            return new File(file, directory).exists();
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("unknown resource type " + url));
        }
        return false;
    }

    public static boolean isJar(String name) {
        if (name != null && name.length() > 4) {
            String ext = name.substring(name.length() - 4, name.length());
            return ".jar".equalsIgnoreCase(ext);
        }
        return false;
    }

    public static boolean isZip(String name) {
        if (name != null && name.length() > 4) {
            String ext = name.substring(name.length() - 4, name.length());
            return ".zip".equalsIgnoreCase(ext);
        }
        return false;
    }

    public static List<URL> getURLsFromDirectory(File repository, String pattern) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("search '" + pattern + "' in " + repository));
            }
            ArrayList<URL> urlList = new ArrayList<URL>();
            File[] filesList = repository.listFiles();
            if (filesList != null) {
                for (File file : filesList) {
                    String name = file.getAbsolutePath();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("directory: " + repository + " name: " + name));
                    }
                    if (file.exists() && file.isDirectory()) {
                        urlList.addAll(I18nUtil.getURLsFromDirectory(file, pattern));
                        continue;
                    }
                    if (pattern != null && !name.matches(pattern)) continue;
                    URL url = file.toURI().toURL();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("directory: " + repository + " url: " + url));
                    }
                    urlList.add(url);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("found with pattern '" + pattern + "' : " + urlList));
            }
            return urlList;
        }
        catch (MalformedURLException eee) {
            throw new IllegalArgumentException("Erreur lors de la conversion de l'url " + repository + " (pattern " + pattern + ") " + eee.getMessage(), eee);
        }
    }
}

