/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.solr.core.SolrConfig;

public class SolrIndexConfig {
    public static final String defaultsName = "indexDefaults";
    static final SolrIndexConfig defaultDefaults = new SolrIndexConfig();
    public static final String DEFAULT_MERGE_POLICY_CLASSNAME = LogByteSizeMergePolicy.class.getName();
    public static final String DEFAULT_MERGE_SCHEDULER_CLASSNAME = ConcurrentMergeScheduler.class.getName();
    public final boolean useCompoundFile;
    public final int maxBufferedDocs;
    public final int maxMergeDocs;
    public final int mergeFactor;
    public final double ramBufferSizeMB;
    public final int maxFieldLength;
    public final int writeLockTimeout;
    public final int commitLockTimeout;
    public final String lockType;
    public final String mergePolicyClassName;
    public final String mergeSchedulerClassname;
    public final boolean luceneAutoCommit;

    private SolrIndexConfig() {
        this.useCompoundFile = true;
        this.maxBufferedDocs = -1;
        this.maxMergeDocs = -1;
        this.mergeFactor = -1;
        this.ramBufferSizeMB = 16.0;
        this.maxFieldLength = -1;
        this.writeLockTimeout = -1;
        this.commitLockTimeout = -1;
        this.lockType = null;
        this.mergePolicyClassName = DEFAULT_MERGE_POLICY_CLASSNAME;
        this.mergeSchedulerClassname = DEFAULT_MERGE_SCHEDULER_CLASSNAME;
        this.luceneAutoCommit = false;
    }

    public SolrIndexConfig(SolrConfig solrConfig, String prefix, SolrIndexConfig def) {
        if (prefix == null) {
            prefix = defaultsName;
        }
        if (def == null) {
            def = defaultDefaults;
        }
        this.useCompoundFile = solrConfig.getBool(prefix + "/useCompoundFile", def.useCompoundFile);
        this.maxBufferedDocs = solrConfig.getInt(prefix + "/maxBufferedDocs", def.maxBufferedDocs);
        this.maxMergeDocs = solrConfig.getInt(prefix + "/maxMergeDocs", def.maxMergeDocs);
        this.mergeFactor = solrConfig.getInt(prefix + "/mergeFactor", def.mergeFactor);
        this.ramBufferSizeMB = solrConfig.getDouble(prefix + "ramBufferSizeMB", def.ramBufferSizeMB);
        this.maxFieldLength = solrConfig.getInt(prefix + "/maxFieldLength", def.maxFieldLength);
        this.writeLockTimeout = solrConfig.getInt(prefix + "/writeLockTimeout", def.writeLockTimeout);
        this.commitLockTimeout = solrConfig.getInt(prefix + "/commitLockTimeout", def.commitLockTimeout);
        this.lockType = solrConfig.get(prefix + "/lockType", def.lockType);
        this.mergePolicyClassName = solrConfig.get(prefix + "/mergePolicy", def.mergePolicyClassName);
        this.mergeSchedulerClassname = solrConfig.get(prefix + "/mergeScheduler", def.mergeSchedulerClassname);
        this.luceneAutoCommit = solrConfig.getBool(prefix + "/luceneAutoCommit", def.luceneAutoCommit);
    }
}

