/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.UpdateResponse;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyCache;
import org.nuiton.wikitty.WikittyCopyOnWrite;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceListener;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.WikittyTree;
import org.nuiton.wikitty.WikittyTreeNode;

public class WikittyServiceCached
implements WikittyService {
    private static Log log = LogFactory.getLog(WikittyServiceCached.class);
    public static final String WIKITTY_CACHE_LISTENEVENTS_OPTION = "wikitty.service.cache.listenevents";
    public static final String WIKITTY_CACHE_ALLWAYS_RESTORE_COPIES_POLICY_OPTION = "wikitty.service.cache.allwaysRestoreCopies";
    protected WikittyCache cache = null;
    protected WikittyService ws;
    protected boolean allwaysRestoreCopies = false;

    public WikittyServiceCached(WikittyService ws) {
        this(ws, null);
    }

    public WikittyServiceCached(WikittyService ws, Properties props) {
        this.ws = ws;
        this.cache = new WikittyCache();
        this.registerWikittyServiceListener(props);
        if (props != null && props.containsKey(WIKITTY_CACHE_ALLWAYS_RESTORE_COPIES_POLICY_OPTION)) {
            this.allwaysRestoreCopies = Boolean.parseBoolean(props.getProperty(WIKITTY_CACHE_ALLWAYS_RESTORE_COPIES_POLICY_OPTION));
        }
    }

    protected Wikitty wrapWikitty(Wikitty wikitty) {
        if (wikitty == null) {
            return null;
        }
        Wikitty result = null;
        if (this.allwaysRestoreCopies) {
            try {
                result = wikitty.clone();
            }
            catch (CloneNotSupportedException e) {
                log.error((Object)("unable to clone " + wikitty), (Throwable)e);
            }
        }
        if (result == null) {
            result = new WikittyCopyOnWrite(wikitty);
        }
        return result;
    }

    protected void registerWikittyServiceListener(Properties props) {
        String listenEvents;
        if (props != null && "true".equalsIgnoreCase(listenEvents = props.getProperty(WIKITTY_CACHE_LISTENEVENTS_OPTION, "false"))) {
            this.addWikittyServiceListener(this.cache, WikittyService.ServiceListenerType.REMOTE);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Listen remote event on service");
            }
        }
    }

    @Override
    public String login(String login, String password) {
        return this.ws.login(login, password);
    }

    @Override
    public void logout(String securityToken) {
        this.ws.logout(securityToken);
    }

    @Override
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        return this.ws.canWrite(securityToken, wikitty);
    }

    @Override
    public boolean canDelete(String securityToken, String wikittyId) {
        return this.ws.canDelete(securityToken, wikittyId);
    }

    @Override
    public boolean canRead(String securityToken, String wikittyId) {
        return this.ws.canRead(securityToken, wikittyId);
    }

    @Override
    public void clear(String securityToken) {
        this.ws.clear(securityToken);
        this.cache.clearWikitty();
    }

    @Override
    public void delete(String securityToken, String id) {
        this.ws.delete(securityToken, id);
        this.cache.removeWikitty(id);
    }

    @Override
    public void delete(String securityToken, Collection<String> ids) {
        this.ws.delete(securityToken, ids);
        this.cache.removeAllWikitty(ids);
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, Criteria criteria) {
        return this.ws.findAllByCriteria(securityToken, criteria);
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        return this.ws.findAllByCriteria(securityToken, transaction, criteria);
    }

    @Override
    public Wikitty findByCriteria(String securityToken, Criteria criteria) {
        return this.ws.findByCriteria(securityToken, criteria);
    }

    @Override
    public Wikitty findByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        return this.ws.findByCriteria(securityToken, transaction, criteria);
    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        return this.ws.getAllExtensionIds(securityToken);
    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        return this.ws.getAllExtensionsRequires(securityToken, extensionName);
    }

    @Override
    public Wikitty restore(String securityToken, String id) {
        Wikitty result = this.cache.getWikitty(id);
        if (result == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Wikitty " + id + " not found in cache"));
            }
            if ((result = this.ws.restore(securityToken, id)) != null) {
                this.cache.putWikitty(result);
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Use cached wikitty " + id));
        }
        result = this.wrapWikitty(result);
        return result;
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> ids) {
        ArrayList<String> notInCache = new ArrayList<String>();
        LinkedHashMap<String, Wikitty> fromCache = new LinkedHashMap<String, Wikitty>();
        for (String id : ids) {
            Wikitty w = this.cache.getWikitty(id);
            fromCache.put(id, w);
            if (w != null) continue;
            notInCache.add(id);
        }
        List<Wikitty> missingInCache = this.ws.restore(securityToken, notInCache);
        this.cache.putAllWikitty(missingInCache);
        for (Wikitty w : missingInCache) {
            if (w == null) continue;
            fromCache.put(w.getId(), w);
        }
        Collection tmp = fromCache.values();
        ArrayList<Wikitty> result = new ArrayList<Wikitty>();
        for (Wikitty w : tmp) {
            result.add(this.wrapWikitty(w));
        }
        return result;
    }

    @Override
    public List<Wikitty> restore(String securityToken, WikittyTransaction transaction, List<String> ids) {
        ArrayList<String> notInCache = new ArrayList<String>();
        LinkedHashMap<String, Wikitty> fromCache = new LinkedHashMap<String, Wikitty>();
        for (String id : ids) {
            Wikitty w = this.cache.getWikitty(id);
            fromCache.put(id, w);
            if (w != null) continue;
            notInCache.add(id);
        }
        List<Wikitty> missingInCache = this.ws.restore(securityToken, transaction, notInCache);
        this.cache.putAllWikitty(missingInCache);
        for (Wikitty w : missingInCache) {
            fromCache.put(w.getId(), w);
        }
        Collection tmp = fromCache.values();
        ArrayList<Wikitty> result = new ArrayList<Wikitty>();
        for (Wikitty w : tmp) {
            result.add(this.wrapWikitty(w));
        }
        return result;
    }

    @Override
    public Map<WikittyTreeNode, Integer> restoreChildren(String securityToken, String wikittyId, Criteria filter) {
        return this.ws.restoreChildren(securityToken, wikittyId, filter);
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, String id) {
        return this.ws.restoreExtension(securityToken, id);
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, String name) {
        return this.ws.restoreExtensionLastVersion(securityToken, name);
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, WikittyTransaction transaction, String name) {
        return this.ws.restoreExtensionLastVersion(securityToken, transaction, name);
    }

    @Override
    public Map.Entry<WikittyTreeNode, Integer> restoreNode(String securityToken, String wikittyId, Criteria filter) {
        return this.ws.restoreNode(securityToken, wikittyId, filter);
    }

    @Override
    public WikittyTree restoreTree(String securityToken, String wikittyId) {
        return this.ws.restoreTree(securityToken, wikittyId);
    }

    @Override
    public List<String> deleteTree(String securityToken, String wikittyId) {
        return this.ws.deleteTree(securityToken, wikittyId);
    }

    @Override
    public UpdateResponse store(String securityToken, Wikitty wikitty) {
        UpdateResponse result = this.ws.store(securityToken, wikitty);
        result.update(wikitty);
        this.cache.putWikitty(wikitty);
        return result;
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties) {
        UpdateResponse result = this.ws.store(securityToken, wikitties);
        for (Wikitty w : wikitties) {
            result.update(w);
        }
        this.cache.putAllWikitty(wikitties);
        return result;
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        UpdateResponse result = this.ws.store(securityToken, wikitties, force);
        for (Wikitty w : wikitties) {
            result.update(w);
        }
        this.cache.putAllWikitty(wikitties);
        return result;
    }

    @Override
    public UpdateResponse store(String securityToken, WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean force) {
        UpdateResponse result = this.ws.store(securityToken, transaction, wikitties, force);
        for (Wikitty w : wikitties) {
            result.update(w);
        }
        transaction.getCache().putAllWikitty(wikitties);
        return result;
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyExtension ext) {
        return this.ws.storeExtension(securityToken, ext);
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        return this.ws.storeExtension(securityToken, exts);
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyTransaction transaction, Collection<WikittyExtension> exts) {
        return this.ws.storeExtension(securityToken, transaction, exts);
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, WikittyTransaction transaction, String id) {
        return this.ws.restoreExtension(securityToken, transaction, id);
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        return this.ws.restoreVersion(securityToken, wikittyId, version);
    }

    @Override
    public void addWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        this.ws.addWikittyServiceListener(listener, type);
    }

    @Override
    public void removeWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        this.ws.removeWikittyServiceListener(listener, type);
    }

    @Override
    public UpdateResponse syncEngin(String securityToken) {
        return this.ws.syncEngin(securityToken);
    }
}

