/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Choose;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.TraceWrapper;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;

public class XSLChoose
extends StyleElement {
    private StyleElement otherwise;
    private int numberOfWhens = 0;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            this.checkUnknownAttribute(n);
        }
    }

    public void validate() throws XPathException {
        NodeInfo nodeInfo;
        this.checkWithinTemplate();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo instanceof XSLWhen) {
                if (this.otherwise != null) {
                    this.compileError("xsl:otherwise must come last", "XTSE0010");
                }
                ++this.numberOfWhens;
                continue;
            }
            if (nodeInfo instanceof XSLOtherwise) {
                if (this.otherwise != null) {
                    this.compileError("Only one xsl:otherwise allowed in an xsl:choose", "XTSE0010");
                    continue;
                }
                this.otherwise = (StyleElement)nodeInfo;
                continue;
            }
            this.compileError("Only xsl:when and xsl:otherwise are allowed here", "XTSE0010");
        }
        if (this.numberOfWhens == 0) {
            this.compileError("xsl:choose must contain at least one xsl:when", "XTSE0010");
        }
    }

    public void markTailCalls() {
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).markTailCalls();
        }
        return;
    }

    public Expression compile(Executable executable) throws XPathException {
        Object object;
        Expression[] expressionArray;
        int n = this.numberOfWhens + (this.otherwise == null ? 0 : 1);
        Expression[] expressionArray2 = new Expression[n];
        Expression[] expressionArray3 = new Expression[n];
        int n2 = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((expressionArray = (NodeInfo)axisIterator.next()) != null) {
            TraceWrapper traceWrapper;
            if (expressionArray instanceof XSLWhen) {
                expressionArray2[n2] = ((XSLWhen)expressionArray).getCondition();
                object = ((XSLWhen)expressionArray).compileSequenceConstructor(executable, expressionArray.iterateAxis((byte)3), true);
                if (object == null) {
                    object = EmptySequence.getInstance();
                }
                try {
                    expressionArray3[n2] = object = object.simplify(((XSLWhen)expressionArray).getStaticContext());
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException);
                }
                if (this.getConfiguration().getTraceListener() != null) {
                    traceWrapper = XSLChoose.makeTraceInstruction((XSLWhen)expressionArray, expressionArray3[n2]);
                    traceWrapper.setParentExpression((XSLWhen)expressionArray);
                    expressionArray3[n2] = traceWrapper;
                }
                if (expressionArray2[n2] instanceof BooleanValue) {
                    if (((BooleanValue)expressionArray2[n2]).getBooleanValue()) {
                        n = n2 + 1;
                        break;
                    }
                    --n2;
                    --n;
                }
                ++n2;
                continue;
            }
            if (expressionArray instanceof XSLOtherwise) {
                expressionArray2[n2] = BooleanValue.TRUE;
                object = ((XSLOtherwise)expressionArray).compileSequenceConstructor(executable, expressionArray.iterateAxis((byte)3), true);
                if (object == null) {
                    object = EmptySequence.getInstance();
                }
                try {
                    expressionArray3[n2] = object = object.simplify(((XSLOtherwise)expressionArray).getStaticContext());
                }
                catch (XPathException xPathException) {
                    this.compileError(xPathException);
                }
                if (this.getConfiguration().getTraceListener() != null) {
                    traceWrapper = XSLChoose.makeTraceInstruction((XSLOtherwise)expressionArray, expressionArray3[n2]);
                    traceWrapper.setParentExpression((XSLOtherwise)expressionArray);
                    expressionArray3[n2] = traceWrapper;
                }
                ++n2;
                continue;
            }
            new AssertionError((Object)"Expected xsl:when or xsl:otherwise");
        }
        if (expressionArray2.length != n) {
            if (n == 0) {
                return null;
            }
            if (n == 1 && expressionArray2[0] instanceof BooleanValue) {
                if (((BooleanValue)expressionArray2[0]).getBooleanValue()) {
                    return expressionArray3[0];
                }
                return null;
            }
            expressionArray = new Expression[n];
            System.arraycopy(expressionArray2, 0, expressionArray, 0, n);
            object = new Expression[n];
            System.arraycopy(expressionArray3, 0, object, 0, n);
            expressionArray2 = expressionArray;
            expressionArray3 = object;
        }
        expressionArray = new Choose(expressionArray2, expressionArray3);
        ExpressionTool.makeParentReferences((Expression)expressionArray);
        return expressionArray;
    }
}

