/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.util.Util;

public class DiscoveryTest {
    Channel ch;

    public static void main(String[] args) throws Exception {
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            System.out.println("DiscoveryTest [-props <properties>]");
        }
        new DiscoveryTest().start(props);
    }

    private void start(String props) throws Exception {
        this.ch = new JChannel(props);
        this.ch.connect("discovery");
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        DiscoveryTest.this.ch.send(null, null, new Data(1, null));
                    }
                    catch (ChannelNotConnectedException e) {
                        e.printStackTrace();
                    }
                    catch (ChannelClosedException e) {
                        e.printStackTrace();
                    }
                    Util.sleep(5000L);
                }
            }
        }.start();
        block4: while (this.ch.isConnected()) {
            Object obj = this.ch.receive(0L);
            if (!(obj instanceof Message)) continue;
            Message msg = (Message)obj;
            Data d = (Data)msg.getObject();
            switch (d.type) {
                case 1: {
                    this.ch.send(msg.getSrc(), null, new Data(2, (Serializable)((Object)(" my address is " + this.ch.getAddress()))));
                    continue block4;
                }
                case 2: {
                    Address sender = msg.getSrc();
                    System.out.println("received response from " + sender + ": " + d.payload);
                    continue block4;
                }
            }
            System.err.println("type " + d.type + " not known");
        }
        this.ch.close();
    }

    private static class Data
    implements Serializable {
        private static final int DISCOVERY_REQ = 1;
        private static final int DISCOVEY_RSP = 2;
        private static final long serialVersionUID = 9193522684840201133L;
        int type = 0;
        Serializable payload = null;

        public Data(int type, Serializable payload) {
            this.type = type;
            this.payload = payload;
        }
    }
}

