/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiServiceConfiguration;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.SendingImpl;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.SessionImpl;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.StatusImpl;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.SearchManager;
import com.jurismarches.vradi.services.managers.ThesaurusManager;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtil;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class FormManager {
    private static final Log log = LogFactory.getLog(FormManager.class);
    protected WikittyProxy wikittyProxy;
    protected ThesaurusManager thesaurusManager;
    protected SearchManager searchManager;

    public FormManager(WikittyProxy wikittyProxy, ThesaurusManager thesaurusManager, SearchManager searchManager) {
        this.wikittyProxy = wikittyProxy;
        this.thesaurusManager = thesaurusManager;
        this.searchManager = searchManager;
    }

    public List<Form> updateForms(List<Form> forms, Set<String> thesaurus) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateForms(forms)");
        }
        if (forms == null || forms.isEmpty()) {
            return forms;
        }
        ArrayList<Thesaurus> entitiesToSave = new ArrayList<Thesaurus>();
        for (Form form : forms) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("updating form: " + form.getId()));
            }
            Date now = new Date();
            if (form.getCreationDate() == null) {
                form.setCreationDate(now);
            } else {
                ModificationTag modificationTag = (ModificationTag)this.wikittyProxy.cast((BusinessEntity)form, ModificationTag.class);
                modificationTag.setLastModified(now);
            }
            if (thesaurus == null) continue;
            List<Thesaurus> attachedThesauruses = this.thesaurusManager.getThesaurusAttachedToForm(form);
            for (Thesaurus attachedThesaurus : attachedThesauruses) {
                attachedThesaurus.removeAttachment(form.getId());
                if (entitiesToSave.contains(attachedThesaurus)) continue;
                entitiesToSave.add(attachedThesaurus);
            }
            for (String thesaurusId : thesaurus) {
                Thesaurus node = this.thesaurusManager.getThesaurus(thesaurusId);
                if (node.getAttachment() != null && node.getAttachment().contains(form.getWikittyId())) continue;
                node.addAttachment(form.getWikittyId());
                if (entitiesToSave.contains(node)) continue;
                entitiesToSave.add(node);
            }
        }
        List result = this.wikittyProxy.store(forms);
        if (!entitiesToSave.isEmpty()) {
            this.wikittyProxy.store(entitiesToSave);
        }
        return result;
    }

    public Session getLastCloseSession() {
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Session");
        search.eq("Session.status", String.valueOf(VradiConstants.SessionStatus.SENT.getValue())).criteria();
        Criteria criteria = search.criteria();
        criteria.addSortDescending("Session.sessionDate");
        PagedResult result = this.wikittyProxy.findAllByCriteria(Session.class, criteria);
        if (result == null || result.size() == 0) {
            return null;
        }
        return (Session)result.getFirst();
    }

    public Session getLastOpenSession() throws VradiException {
        Session lastClose = this.getLastCloseSession();
        String formatedLastCloseDate = null;
        if (lastClose != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Last closed session : " + lastClose.getSessionDate()));
            }
            try {
                formatedLastCloseDate = WikittyUtil.formatDate((Date)lastClose.getSessionDate());
            }
            catch (ParseException e) {
                log.error((Object)"Cant parse date");
            }
        }
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Session");
        if (formatedLastCloseDate != null) {
            search.ge("Session.sessionDate", formatedLastCloseDate);
        }
        search.or().eq("Session.status", String.valueOf(VradiConstants.SessionStatus.ACTIVE.getValue())).eq("Session.status", String.valueOf(VradiConstants.SessionStatus.STOPPED.getValue())).eq("Session.status", String.valueOf(VradiConstants.SessionStatus.ERROR.getValue()));
        Criteria criteria = search.criteria();
        criteria.addSortDescending("Session.sessionDate");
        PagedResult result = this.wikittyProxy.findAllByCriteria(Session.class, criteria);
        Session session = null;
        if (result != null && result.size() > 0) {
            session = (Session)result.getFirst();
        }
        if (log.isDebugEnabled() && session != null) {
            log.debug((Object)("Last sessions found : " + session.getWikittyId() + " - " + session.getSessionDate() + " with status : " + session.getStatus()));
        }
        return session;
    }

    public List<Session> getSessions(Date sessionDate) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSessions for date " + sessionDate.toString()));
        }
        Search search = Search.query().eq(Element.ELT_EXTENSION, "Session");
        search.bw("Session.sessionDate", FormManager.getBeginOfDaySolrDate(sessionDate), FormManager.getEndOfDaySolrDate(sessionDate));
        Criteria criteria = search.criteria();
        List allSession = this.wikittyProxy.findAllByCriteria(Session.class, criteria).getAll();
        if (log.isDebugEnabled()) {
            log.debug((Object)(allSession.size() + " sessions found"));
        }
        return allSession;
    }

    protected static String getBeginOfDaySolrDate(Date date) throws VradiException {
        Date localDate = DateUtil.setMinTimeOfDay((Date)date);
        try {
            return WikittyUtil.formatDate((Date)localDate);
        }
        catch (ParseException eee) {
            throw new VradiException("Cant format date " + date, eee);
        }
    }

    protected static String getEndOfDaySolrDate(Date date) throws VradiException {
        Date localDate = DateUtil.setMaxTimeOfDay((Date)date);
        try {
            return WikittyUtil.formatDate((Date)localDate);
        }
        catch (ParseException eee) {
            throw new VradiException("Cant format date " + date, eee);
        }
    }

    public Session createNewSession() throws VradiException {
        Session lastSession = this.getLastOpenSession();
        if (lastSession != null) {
            throw new VradiException(I18n._((String)"Already opened session on %tF", (Object[])new Object[]{lastSession.getSessionDate()}));
        }
        Date now = new Date();
        List<Session> sessionList = this.getSessions(now);
        int num = sessionList.size() + 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)("No session found, creating a new one with num : " + num));
        }
        Session currentSession = new SessionImpl();
        currentSession.setSessionDate(now);
        currentSession.setNum(num);
        currentSession.setStatus(VradiConstants.SessionStatus.ACTIVE.getValue());
        currentSession.setParagraph(VradiServiceConfiguration.getInstance(new String[0]).getSessionDefaultParagraph());
        currentSession = (Session)this.wikittyProxy.store((BusinessEntity)currentSession);
        return currentSession;
    }

    public Session bindForms(Session currentSession) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("bindForms " + currentSession.getSessionDate()));
        }
        try {
            ArrayList<Sending> toSend = new ArrayList<Sending>(this.attachForms(currentSession));
            Session reloadedSession = (Session)this.wikittyProxy.restore(Session.class, currentSession.getWikittyId());
            if (reloadedSession != null) {
                currentSession = reloadedSession;
            }
            if (currentSession.getStatus() != VradiConstants.SessionStatus.ACTIVE.getValue()) {
                throw new VradiException("Session is not active, abording");
            }
            for (Sending s : toSend) {
                currentSession.addSending(s.getWikittyId());
            }
            currentSession = (Session)this.wikittyProxy.store((BusinessEntity)currentSession);
            this.wikittyProxy.store(toSend);
            if (log.isDebugEnabled()) {
                Set<String> sending = currentSession.getSending();
                int size = sending == null ? 0 : sending.size();
                log.debug((Object)("Saving session '" + currentSession.getSessionDate() + "' number '" + currentSession.getNum() + "' status '" + VradiConstants.SessionStatus.getStatus(currentSession.getStatus()).getDescription() + "' with '" + size + "' sending"));
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't bind form : ", (Throwable)e);
            }
            throw new VradiException("Can't bind form : ", e);
        }
        return currentSession;
    }

    protected Set<Sending> attachForms(Session currentSession) throws VradiException {
        String status = this.getSelectionneStatus().getWikittyId();
        HashSet<Sending> toSend = new HashSet<Sending>();
        List<Group> groups = this.searchManager.findGroupsWithQueries();
        for (Group group : groups) {
            ArrayList<Form> formsToBind = new ArrayList<Form>();
            Set<String> queries = group.getQueries();
            for (String queryEntry : queries) {
                try {
                    QueryBean queryBean = new QueryBean(queryEntry);
                    String query = queryBean.getQuery();
                    Search filter = Search.query();
                    filter.eq("Infogene.status", status);
                    Search filterDatePublication = filter.or();
                    Date olderInscriptionDate = this.getOlderInscriptionDate(group.getUser());
                    filterDatePublication.isNull("Form.datePub");
                    filterDatePublication.ge("Form.datePub", WikittyUtil.formatDate((Date)olderInscriptionDate));
                    Search filterDatePeremption = filter.or();
                    filterDatePeremption.isNull("Form.datePeremption");
                    filterDatePeremption.ge("Form.datePeremption", WikittyUtil.formatDate((Date)new Date()));
                    Criteria criteria = filter.criteria();
                    FormPagedResult vradiFormPage = new FormPagedResult();
                    vradiFormPage = this.searchManager.findForms(query, criteria, vradiFormPage);
                    List<Form> resultForms = vradiFormPage.getFormsToShow();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Query " + query + " return " + resultForms.size() + " forms"));
                    }
                    formsToBind.addAll(resultForms);
                }
                catch (IOException ex) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"Can't parse group query", (Throwable)ex);
                }
                catch (UnsupportedQueryException ex) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"Can't execute group query", (Throwable)ex);
                }
                catch (ParseException eee) {
                    throw new VradiException("Cant format date : ", eee);
                }
            }
            if (formsToBind.isEmpty()) continue;
            List<Sending> sendings = this.createAllSending(currentSession, group, formsToBind, true, false);
            toSend.addAll(sendings);
        }
        return toSend;
    }

    protected Date getOlderInscriptionDate(Set<String> usersIds) {
        Date result = new Date();
        for (String userId : usersIds) {
            User user = (User)this.wikittyProxy.restore(User.class, userId);
            Date beginSearchDate = user.getBeginSearchDate();
            if (beginSearchDate != null && result.after(DateUtil.setMinTimeOfDay((Date)beginSearchDate))) {
                result = beginSearchDate;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("The older inscription date for user " + user.getName() + " is " + result));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("The older inscription date " + result));
        }
        return result;
    }

    public List<Sending> createAllSending(Session currentSession, Group group, List<Form> formsToBind, boolean removeAlreadyBind) {
        return this.createAllSending(currentSession, group, formsToBind, removeAlreadyBind, true);
    }

    protected List<Sending> createAllSending(Session currentSession, Group group, List<Form> formsToBind, boolean removeAlreadyBind, boolean save) {
        ArrayList<Sending> result = new ArrayList<Sending>();
        List users = this.wikittyProxy.restore(User.class, new ArrayList<String>(group.getUser()));
        for (User user : users) {
            Sending sending = this.createUserSending(currentSession, user, formsToBind, removeAlreadyBind, save);
            if (sending == null) continue;
            result.add(sending);
        }
        return result;
    }

    public Sending createUserSending(Session currentSession, User user, List<Form> formsToBind, boolean removeAlreadyBind) {
        return this.createUserSending(currentSession, user, formsToBind, removeAlreadyBind, true);
    }

    protected Sending createUserSending(Session currentSession, User user, List<Form> formsToBind, boolean removeAlreadyBind, boolean save) {
        currentSession = (Session)this.wikittyProxy.restore(Session.class, currentSession.getWikittyId());
        Sending sending = this.findExistingOrCreateSending(currentSession, user);
        sending.setUser(user.getWikittyId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add user " + user.getWikittyId()));
        }
        List<Form> finalFormsToBind = new ArrayList<Form>(formsToBind);
        if (removeAlreadyBind) {
            finalFormsToBind = this.removeAlreadyBound(currentSession, finalFormsToBind, user);
            Date beginSearchDate = user.getBeginSearchDate();
            for (Form f : new ArrayList<Form>(finalFormsToBind)) {
                Date formCreationDate = f.getCreationDate();
                if (user.getEnable() && !formCreationDate.before(beginSearchDate)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing form '" + f.getObjet() + "' because date of creation (" + formCreationDate + ") is before user begin search date (" + beginSearchDate + ") for user : " + user.getName()));
                }
                finalFormsToBind.remove(f);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding " + finalFormsToBind.size() + " forms to sending"));
            }
        }
        for (Form f : finalFormsToBind) {
            String fid = f.getWikittyId();
            sending.removeForm(fid);
            sending.addForm(fid);
        }
        Set<String> formsAttached = sending.getForm();
        if (formsAttached != null && !formsAttached.isEmpty()) {
            currentSession = (Session)this.wikittyProxy.restore(Session.class, currentSession.getWikittyId());
            currentSession.addSending(sending.getWikittyId());
            if (save) {
                this.wikittyProxy.store((BusinessEntity)currentSession);
                sending = (Sending)this.wikittyProxy.store((BusinessEntity)sending);
            }
            return sending;
        }
        return null;
    }

    public List<Sending> removeAllSending(Session session, Form form, Group group) throws VradiException {
        ArrayList<Sending> result = new ArrayList<Sending>();
        List users = this.wikittyProxy.restore(User.class, new ArrayList<String>(group.getUser()));
        for (User user : users) {
            result.add(this.removeSending(session, form, user));
        }
        return result;
    }

    public Sending removeSending(Session session, Form form, User user) throws VradiException {
        try {
            Set<String> sendingSet = session.getSending();
            ArrayList<Object> sendingList = new ArrayList();
            if (sendingSet != null) {
                sendingList = new ArrayList<String>(sendingSet);
            }
            List sendings = this.wikittyProxy.restore(Sending.class, sendingList);
            for (Sending sending : sendings) {
                Set<String> formsIds;
                if (sending == null || !user.getWikittyId().equals(sending.getUser())) continue;
                String formId = form.getWikittyId();
                Set<String> forms = sending.getForm();
                if (forms != null && forms.contains(formId)) {
                    sending.removeForm(form.getWikittyId());
                    sending.addDeletedForms(form.getWikittyId());
                }
                if ((formsIds = sending.getForm()) == null || formsIds.isEmpty()) {
                    sending.setStatus(VradiConstants.SendingStatus.DELETED.getValue());
                }
                this.wikittyProxy.store((BusinessEntity)sending);
                return sending;
            }
            return null;
        }
        catch (Exception eee) {
            throw new VradiException("Cant remove forms for user " + user.getName(), eee);
        }
    }

    protected Sending findExistingOrCreateSending(Session currentSession, User user) {
        Set<String> sendingsId = currentSession.getSending();
        List sendings = sendingsId != null ? this.wikittyProxy.restore(Sending.class, new ArrayList<String>(sendingsId)) : new ArrayList();
        for (Sending sending : sendings) {
            String userId = user.getWikittyId();
            if (sending == null || !userId.equals(sending.getUser()) || sending.getStatus() == VradiConstants.SendingStatus.DELETED.getValue()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending is existing for queryMaker : " + user.getName()));
            }
            return sending;
        }
        SendingImpl newSending = new SendingImpl();
        newSending.setSentDate(null);
        newSending.setReceptionDate(null);
        newSending.setParagraph("");
        newSending.setReceptionProof(false);
        newSending.setStatus(VradiConstants.SendingStatus.TO_SEND.getValue());
        newSending.setUser(user.getWikittyId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending dont exist for queryMaker : " + user + ", creating one"));
        }
        return newSending;
    }

    protected List<Form> removeAlreadyBound(Session currentSession, List<Form> forms, User user) {
        ArrayList<String> formIds = new ArrayList<String>();
        for (Form form : forms) {
            formIds.add(form.getWikittyId());
        }
        String userId = user.getWikittyId();
        Search search = Search.query();
        Set<String> sendingIds = currentSession.getSending();
        if (sendingIds != null) {
            for (String currentSendingId : sendingIds) {
                search.neq(Element.ELT_ID, currentSendingId);
            }
        }
        search.or().contains("Sending.form", formIds).contains("Sending.deletedForms", formIds);
        search.eq("Sending.user", userId);
        search.neq("Sending.status", String.valueOf(VradiConstants.SendingStatus.DELETED.getValue()));
        PagedResult pagedResult = this.wikittyProxy.findAllByCriteria(Sending.class, search.criteria());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remove " + pagedResult.size() + " already bounds forms"));
        }
        for (Sending send : pagedResult.getAll()) {
            Set<String> formsIds = send.getForm();
            if (formsIds == null) continue;
            formIds.removeAll(formsIds);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rest " + formIds.size() + " forms"));
        }
        List result = this.wikittyProxy.restore(Form.class, formIds);
        return result;
    }

    public Status getStatus(String statusId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getStatus(" + statusId + ")"));
        }
        Status status = (Status)this.wikittyProxy.restore(Status.class, statusId);
        return status;
    }

    public List<Status> getStatuses(List<String> statusIds) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getStatuses(statusIds)");
        }
        List statuses = this.wikittyProxy.restore(Status.class, statusIds);
        return new ArrayList<Status>(statuses);
    }

    public List<Status> createDefaultStatuses() throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createDefaultStatuses()");
        }
        ArrayList<Status> all = new ArrayList<Status>();
        all.add(this.getNonTraiteStatus());
        all.add(this.getNonSelectionneStatus());
        all.add(this.getPreselectionneStatus());
        all.add(this.getSelectionneStatus());
        return new ArrayList<Status>(all);
    }

    public Status getNonTraiteStatus() {
        return this.getOrCreateStatus(VradiConstants.FormStatus.NON_TRAITE);
    }

    public Status getNonSelectionneStatus() {
        return this.getOrCreateStatus(VradiConstants.FormStatus.NON_SELECTIONNE);
    }

    public Status getPreselectionneStatus() {
        return this.getOrCreateStatus(VradiConstants.FormStatus.PRESELECTIONNE);
    }

    public Status getSelectionneStatus() {
        return this.getOrCreateStatus(VradiConstants.FormStatus.SELECTIONNE);
    }

    protected Status getOrCreateStatus(VradiConstants.FormStatus type) {
        Search search;
        Criteria criteria;
        Status status;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getOrCreateStatus(" + type.getName() + ")"));
        }
        if ((status = (Status)this.wikittyProxy.findByCriteria(Status.class, criteria = (search = Search.query().eq(Element.ELT_EXTENSION, "Status").eq("Status.name", type.getName())).criteria())) == null) {
            log.warn((Object)("Status not found creating : " + type.getName()));
            status = new StatusImpl();
            status.setName(type.getName());
            status.setValue(type.getValue());
            status.setDescription(type.getDescription());
            status.setModifiable(false);
            status = (Status)this.wikittyProxy.store((BusinessEntity)status);
        }
        return status;
    }

    public List<Status> updateStatuses(List<Status> statuses) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateStatuses(statuses)");
        }
        try {
            List result = this.wikittyProxy.store(statuses);
            return result;
        }
        catch (Exception eee) {
            log.error((Object)"Cant update statuses : ", (Throwable)eee);
            throw new VradiException("Cant update statuses : ", eee);
        }
    }

    public Status updateStatus(Status status) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateStatus(status)");
        }
        try {
            status = (Status)this.wikittyProxy.store((BusinessEntity)status);
            return status;
        }
        catch (Exception eee) {
            log.error((Object)"Cant update status : ", (Throwable)eee);
            throw new VradiException("Cant update status : ", eee);
        }
    }

    public boolean deleteStatuses(List<String> statusIds) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteStatus(" + statusIds + ")"));
        }
        boolean result = true;
        for (String id : statusIds) {
            Search search = Search.query().eq(Element.ELT_EXTENSION, "Form").eq("Infogene.status", id);
            Criteria criteria = search.criteria();
            PagedResult forms = this.wikittyProxy.findAllByCriteria(Form.class, criteria);
            if (forms.size() > 0) {
                result = false;
                continue;
            }
            try {
                this.wikittyProxy.delete(id);
            }
            catch (Exception e) {
                log.error((Object)"Cant delete status : ", (Throwable)e);
                throw new VradiException("Cant delete status : ", e);
            }
        }
        return result;
    }

    protected List<User> getUsersOfClient(String clientId) {
        Search search = Search.query().eq(Element.ELT_EXTENSION, "User").eq("User.client", clientId);
        Criteria criteria = search.criteria();
        PagedResult usersPageResult = this.wikittyProxy.findAllByCriteria(User.class, criteria);
        return new ArrayList<User>(usersPageResult.getAll());
    }

    public void deleteSession(String sessionId) throws VradiException {
        if (sessionId == null) {
            return;
        }
        Session sessionToDelete = (Session)this.wikittyProxy.restore(Session.class, sessionId);
        if (sessionToDelete.getStatus() != VradiConstants.SessionStatus.ACTIVE.getValue()) {
            throw new VradiException("Session is not active, abording");
        }
        Set<String> sendings = sessionToDelete.getSending();
        if (sendings != null) {
            this.wikittyProxy.delete(sendings);
        }
        this.wikittyProxy.delete(sessionId);
    }

    public Session getSessionOfSending(String sendingId) throws VradiException {
        try {
            Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Session").contains("Session.sending", sendingId).criteria();
            return (Session)this.wikittyProxy.findByCriteria(Session.class, criteria);
        }
        catch (Exception eee) {
            log.error((Object)("Cant restore session for sending '" + sendingId + "' : "), (Throwable)eee);
            throw new VradiException("Cant restore session for sending '" + sendingId + "' : ", eee);
        }
    }

    public boolean removeFormsFromSession(List<Form> forms) throws VradiException {
        Session session = this.getLastOpenSession();
        if (session == null) {
            return false;
        }
        ArrayList<String> formsIds = new ArrayList<String>();
        for (Form form : forms) {
            formsIds.add(form.getWikittyId());
        }
        for (String sendingId : session.getSending()) {
            Sending sending = (Sending)this.wikittyProxy.restore(Sending.class, sendingId);
            if (sending == null) continue;
            for (String formId : formsIds) {
                sending.removeForm(formId);
                sending.addDeletedForms(formId);
            }
            if (sending.getForm() == null || sending.getForm().isEmpty()) {
                sending.setStatus(VradiConstants.SendingStatus.DELETED.getValue());
            }
            this.wikittyProxy.store((BusinessEntity)sending);
        }
        return true;
    }
}

