/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.webharvest.exception.PluginException;

public class ClassLoaderUtil {
    private static URLClassLoader rootClassLoader = null;

    private static void defineRootLoader() {
        ArrayList<URL> urls = new ArrayList<URL>();
        String rootDirPath = new File("").getAbsolutePath();
        try {
            urls.add(new File("").toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        File[] entries = new File(rootDirPath).listFiles();
        if (entries != null) {
            for (int f = 0; f < entries.length; ++f) {
                File entry = entries[f];
                if (entry == null || entry.isDirectory() || !entry.getName().toLowerCase().endsWith(".jar")) continue;
                try {
                    String jarAbsolutePath = entry.getAbsolutePath();
                    urls.add(new URL("jar:file:/" + jarAbsolutePath.replace('\\', '/') + "!/"));
                    continue;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        URL[] urlsArray = new URL[urls.size()];
        for (int i = 0; i < urls.size(); ++i) {
            urlsArray[i] = (URL)urls.get(i);
        }
        rootClassLoader = new URLClassLoader(urlsArray);
    }

    public static void registerJDBCDriver(String driverClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        if (rootClassLoader == null) {
            ClassLoaderUtil.defineRootLoader();
        }
        Driver driver = (Driver)Class.forName(driverClassName, true, rootClassLoader).newInstance();
        DriverManager.registerDriver(new DriverShim(driver));
    }

    public static Class getPluginClass(String fullClassName) throws PluginException {
        if (rootClassLoader == null) {
            ClassLoaderUtil.defineRootLoader();
        }
        try {
            return Class.forName(fullClassName, true, rootClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Error finding plugin class \"" + fullClassName + "\": " + e.getMessage(), e);
        }
        catch (NoClassDefFoundError e) {
            throw new PluginException("Error finding plugin class \"" + fullClassName + "\": " + e.getMessage(), e);
        }
    }

    private static class DriverShim
    implements Driver {
        private Driver driver;

        DriverShim(Driver d) {
            this.driver = d;
        }

        @Override
        public boolean acceptsURL(String u) throws SQLException {
            return this.driver.acceptsURL(u);
        }

        @Override
        public Connection connect(String u, Properties p) throws SQLException {
            return this.driver.connect(u, p);
        }

        @Override
        public int getMajorVersion() {
            return this.driver.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.driver.getMinorVersion();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String u, Properties p) throws SQLException {
            return this.driver.getPropertyInfo(u, p);
        }

        @Override
        public boolean jdbcCompliant() {
            return this.driver.jdbcCompliant();
        }
    }
}

