/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package com.jurismarches.vradi.beans;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import com.jurismarches.vradi.entities.Thesaurus;

import com.jurismarches.vradi.entities.Form;

/**
 * Thesaurus cartography.
 * 
 * Contains association between thesaurus and number of associated forms.
 *
 * @author schorlet
 * @version $Revision: 1178 $ $Date: 2010-08-03 14:04:40 +0200 (mar., 03 août 2010) $
 * @since 19 avr. 2010 16:58:00
 */
public class ThesaurusCartography implements Serializable {

    protected static final long serialVersionUID = -2575746133856007541L;

    protected final Map<String, Integer> cartography;
    protected final List<Form> forms;
    
    public ThesaurusCartography(Map<String, Integer> cartography, List<Form> forms) {
        this.cartography = cartography;
        this.forms = forms;
    }

    public Map<String, Integer> getCartography() {
        return cartography;
    }

    public List<Form> getForms() {
        return forms;
    }
}
