/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package com.jurismarches.vradi;

import com.jurismarches.vradi.services.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ArgumentsParserException;

import java.util.Arrays;

/**
 * This module do nothing exept with options :
 *
 * -- reIndexSolr
 *
 * @author sletellier <letellier@codelutin.com>
 */
public class VradiServiceMain {

    /** log. */
    private static final Log log = LogFactory.getLog(VradiServiceMain.class);

    public static void main(String[] args) {

        // Initialise config
        Configuration config = Configuration.getInstance();

        // Initialise actions
        config.initActions();
        try {

            // Parse args
            config.parse(args);
        } catch (ArgumentsParserException eee) {
            log.error("Illegal options " + Arrays.toString(args), eee);
        }
        try {
            // Lunch actions
            config.doAction(0);
        } catch (Exception eee) {
            log.error("Cant run actions ", eee);
        }
    }
}
