/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.SessionBean;
import com.jurismarches.vradi.services.dto.VradiClientDTO;
import com.jurismarches.vradi.services.dto.VradiDTO;
import com.jurismarches.vradi.services.dto.VradiFormDTO;
import com.jurismarches.vradi.services.dto.VradiGroupDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import com.jurismarches.vradi.services.dto.VradiUserDTO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VradiSessionDTO
extends SessionBean
implements VradiDTO<Session> {
    private static final long serialVersionUID = 1L;
    protected List<VradiSendingDTO> sendingList = new ArrayList<VradiSendingDTO>();

    @Override
    public void fromWikitty(Session wikitty) {
        if (wikitty == null) {
            this.reset();
        } else {
            this.setWikittyId(wikitty.getWikittyId());
            this.setSessionDate(wikitty.getSessionDate());
            this.setNum(wikitty.getNum());
            this.setStatus(wikitty.getStatus());
            this.setParagraph(wikitty.getParagraph());
        }
    }

    @Override
    public void reset() {
        this.setWikittyId(null);
        this.setSessionDate(null);
        this.setNum(0);
        this.setStatus(0);
        this.setParagraph("");
    }

    public void setSessionDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        super.setSessionDate(calendar.getTime());
    }

    @Override
    public void toWikitty(Session wikitty) {
        wikitty.setSessionDate(this.getSessionDate());
        wikitty.setNum(this.getNum());
        wikitty.setStatus(this.getStatus());
        wikitty.setParagraph(this.getParagraph());
    }

    @Override
    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        this.propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public void setSendingList(List<VradiSendingDTO> sending) {
        List<VradiSendingDTO> old = this.sendingList;
        this.sendingList = sending;
        this.propertyChange.firePropertyChange("sendingList", old, this.sendingList);
    }

    public List<VradiSendingDTO> getSendingList() {
        return this.sendingList;
    }

    public void addSending(VradiSendingDTO sending) {
        List<VradiSendingDTO> old = this.sendingList;
        this.sendingList.add(sending);
        this.propertyChange.firePropertyChange("sendingList", old, this.sendingList);
    }

    public void addAllSending(List<VradiSendingDTO> sending) {
        List<VradiSendingDTO> old = this.sendingList;
        this.sendingList.addAll(sending);
        this.propertyChange.firePropertyChange("sendingList", old, this.sendingList);
    }

    public void removeSending(VradiSendingDTO sending) {
        List<VradiSendingDTO> old = this.sendingList;
        this.sendingList.remove(sending);
        this.propertyChange.firePropertyChange("sendingList", old, this.sendingList);
    }

    public void removeAllSending(List<VradiSendingDTO> sending) {
        List<VradiSendingDTO> old = this.sendingList;
        this.sendingList.removeAll(sending);
        this.propertyChange.firePropertyChange("sendingList", old, this.sendingList);
    }

    public void clearSending() {
        List<VradiSendingDTO> old = this.sendingList;
        this.sendingList.clear();
        this.propertyChange.firePropertyChange("sendingList", old, this.sendingList);
    }

    public Map<VradiClientDTO, VradiSendingDTO> getClientsSendingConcernedBy(VradiFormDTO form) {
        HashMap<VradiClientDTO, VradiSendingDTO> result = new HashMap<VradiClientDTO, VradiSendingDTO>();
        for (VradiSendingDTO sending : this.getSendingList()) {
            if (!sending.getForm().contains(form.getWikittyId()) || sending.getClient() == null) continue;
            result.put(sending.getClientDTO(), sending);
        }
        return result;
    }

    public Map<VradiUserDTO, VradiSendingDTO> getUsersSendingConcernedBy(VradiFormDTO form) {
        HashMap<VradiUserDTO, VradiSendingDTO> result = new HashMap<VradiUserDTO, VradiSendingDTO>();
        for (VradiSendingDTO sending : this.getSendingList()) {
            if (!sending.getForm().contains(form.getWikittyId()) || sending.getUser() == null) continue;
            result.put(sending.getUserDTO(), sending);
        }
        return result;
    }

    public Map<VradiGroupDTO, VradiSendingDTO> getGroupsSendingConcernedBy(VradiFormDTO form) {
        HashMap<VradiGroupDTO, VradiSendingDTO> result = new HashMap<VradiGroupDTO, VradiSendingDTO>();
        for (VradiSendingDTO sending : this.getSendingList()) {
            if (!sending.getForm().contains(form.getWikittyId()) || sending.getGroup() == null) continue;
            result.put(sending.getGroupDTO(), sending);
        }
        return result;
    }

    public int getNbFormToSend() {
        int result = 0;
        for (VradiSendingDTO sending : this.getSendingList()) {
            if (sending.getUserDTO() == null) continue;
            result += sending.getFormDTOs().size();
        }
        return result;
    }

    public String toString() {
        SimpleDateFormat simpleFormat = new SimpleDateFormat("dd/MM/yyyy");
        return simpleFormat.format(this.getSessionDate());
    }
}

