/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.migration;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.migration.MigrationWikittyService;
import com.jurismarches.vradi.services.Configuration;
import com.jurismarches.vradi.services.ServiceFactory;
import com.jurismarches.vradi.services.managers.FormManager;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ZipUtil;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.jdbc.WikittyJDBCUtil;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Search;

public class Migration005 {
    private static final Log log = LogFactory.getLog(Migration005.class);
    final File vradi005;
    final File vradi004 = new File(Configuration.getUserHome() + File.separator + ".vradi" + File.separator + "vradi-0.0.4");
    boolean performMigration = false;

    public Migration005() {
        this.vradi005 = Configuration.getInstance().getDataDirAsFile();
    }

    public void prepareMigration() {
        if (!this.isDataDirExists(this.vradi004)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Directory " + this.vradi004 + " doesn't exists"));
            }
            return;
        }
        if (this.isDataDirExists(this.vradi005)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Directory " + this.vradi005 + " already exists"));
            }
            return;
        }
        log.info((Object)"Begin of data migration from 0.0.4 to 0.0.5");
        this.performMigration = true;
        try {
            this.archivePreviousVersion(this.vradi004);
            this.vradi004.renameTo(this.vradi005);
            this.updateExtensionVersion();
        }
        catch (Exception e) {
            throw new UnhandledException("Prepare migration failed", (Throwable)e);
        }
    }

    public void performMigration(WikittyProxy proxy) {
        try {
            if (this.performMigration) {
                this.performMigration = false;
                this.updateStatusNextVersion(proxy);
                this.deleteUserClientNextVersion(proxy);
                this.cleanThesaurus(proxy);
                this.rebuildIndex(proxy);
                log.info((Object)"End of data migration !");
            }
        }
        catch (Exception e) {
            try {
                FileUtils.deleteDirectory((File)this.vradi005);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new UnhandledException("Data migration failed", (Throwable)e);
        }
    }

    protected void rebuildIndex(WikittyProxy proxy) {
        if (log.isInfoEnabled()) {
            log.info((Object)"Reindexing solr...");
        }
        proxy.getWikittyService().syncEngin();
    }

    protected boolean isDataDirExists(File dataDir) {
        if (!dataDir.exists()) {
            return false;
        }
        String[] list = dataDir.list();
        return list.length != 0;
    }

    void archivePreviousVersion(File dataDir) throws IOException {
        File archive = new File(dataDir.getAbsolutePath() + ".zip");
        log.info((Object)("Creating backup archive: " + archive.getAbsolutePath()));
        ZipUtil.compress((File)archive, (File)dataDir);
    }

    void updateStatusNextVersion(WikittyProxy proxy) {
        try {
            Search search = Search.query().eq(Element.ELT_EXTENSION, "Status");
            Criteria criteria = search.criteria();
            PagedResult statuses = proxy.findAllByCriteria(Status.class, criteria);
            if (statuses.getNumFound() > 0) {
                for (Status status : statuses.getAll()) {
                    if ("Valid\u00e9".equals(status.getName())) {
                        VradiConstants.FormStatus selectionne = VradiConstants.FormStatus.SELECTIONNE;
                        status.setName(selectionne.getName());
                        status.setValue(selectionne.getValue());
                        status.setDescription(selectionne.getDescription());
                        status.setModifiable(false);
                        proxy.store((BusinessEntity)status);
                        continue;
                    }
                    if (!"\u00c0 tra\u00eeter".equals(status.getName())) continue;
                    VradiConstants.FormStatus nonTraite = VradiConstants.FormStatus.NON_TRAITE;
                    status.setName(nonTraite.getName());
                    status.setValue(nonTraite.getValue());
                    status.setDescription(nonTraite.getDescription());
                    status.setModifiable(false);
                    proxy.store((BusinessEntity)status);
                }
            }
            FormManager formManager = new FormManager(proxy, null, null);
            formManager.getNonSelectionneStatus();
            formManager.getPreselectionneStatus();
        }
        catch (Exception e) {
            throw new WikittyException(e);
        }
    }

    void deleteUserClientNextVersion(WikittyProxy proxy) {
        PagedResult clients = proxy.findAllByCriteria(Client.class, null);
        if (log.isInfoEnabled()) {
            log.info((Object)("Delete " + clients.getNumFound() + " clients"));
        }
        for (Client client : clients.getAll()) {
            proxy.delete(client.getWikittyId());
        }
        PagedResult users = proxy.findAllByCriteria(User.class, null);
        if (log.isInfoEnabled()) {
            log.info((Object)("Delete " + clients.getNumFound() + " users"));
        }
        for (User user : users.getAll()) {
            proxy.delete(user.getWikittyId());
        }
    }

    protected void cleanThesaurus(WikittyProxy proxy) throws Exception {
        Criteria thesaurusCriteria = Search.query().eq(Element.ELT_EXTENSION, "TreeNode").criteria();
        MigrationWikittyService wikittyService = (MigrationWikittyService)proxy.getWikittyService();
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            HashSet<String> deleteList = new HashSet<String>();
            PagedResult wikittyIds = wikittyService.getSearchEngin().findAllByCriteria(transaction, thesaurusCriteria);
            for (String wikittyId : wikittyIds.getAll()) {
                boolean exists = wikittyService.getWikittyStorage().exists(transaction, wikittyId);
                if (!exists) {
                    deleteList.add(wikittyId);
                    continue;
                }
                this.cleanThesaurusChildren(wikittyService, transaction, wikittyId);
            }
            log.info((Object)("Deleting: " + deleteList));
            wikittyService.getSearchEngin().delete(transaction, deleteList);
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            throw e;
        }
    }

    private void cleanThesaurusChildren(MigrationWikittyService wikittyService, WikittyTransaction transaction, String wikittyId) {
        Wikitty wikitty = wikittyService.getWikittyStorage().restore(transaction, wikittyId, new String[0]);
        TreeNodeImpl node = new TreeNodeImpl(wikitty);
        Set children = node.getChildren();
        if (children != null) {
            log.info((Object)("Checking childrens :  " + children));
            StringBuilder sb = new StringBuilder();
            for (String id : children) {
                boolean exists = wikittyService.getWikittyStorage().exists(transaction, id);
                if (exists) continue;
                sb.append(id);
                sb.append(',');
            }
            if (sb.length() > 0) {
                Object[] splits;
                log.info((Object)("Deleting children :  " + sb.toString()));
                for (String string : splits = sb.toString().split(",")) {
                    node.removeChildren(string);
                }
                log.info((Object)("Updating: " + wikittyId));
                log.info((Object)("   Removed thesaurus children: " + Arrays.toString(splits)));
                wikittyService.getWikittyStorage().store(transaction, Arrays.asList(wikitty), true);
            }
        }
    }

    void updateExtensionVersion() {
        Connection connection = null;
        try {
            String update;
            String newID;
            String computeVersion2;
            String computeVersion;
            String name;
            String id;
            Properties conf = Configuration.getInstance().getJdbcConfigProperties();
            if (conf.isEmpty()) {
                conf = WikittyJDBCUtil.loadProperties(null);
            }
            Class.forName(conf.getProperty("jdbc.con.driver"));
            connection = WikittyJDBCUtil.getJDBCConnection((Properties)conf);
            Statement updateStatement = connection.createStatement();
            updateStatement.executeUpdate("ALTER TABLE EXTENSION_DATA SET REFERENTIAL_INTEGRITY FALSE");
            updateStatement.close();
            Statement statement = connection.createStatement();
            ResultSet resultset = statement.executeQuery("select ID from EXTENSION_DATA");
            while (resultset.next()) {
                id = resultset.getString("ID");
                name = WikittyExtension.computeName((String)id);
                computeVersion = WikittyExtension.computeVersion((String)id);
                if (computeVersion.equals(computeVersion2 = this.computeVersion(id))) continue;
                newID = WikittyExtension.computeId((String)name, (String)computeVersion);
                update = "update EXTENSION_DATA set ID = '%s' where ID = '%s'";
                updateStatement = connection.createStatement();
                updateStatement.executeUpdate(String.format(update, newID, id));
                updateStatement.close();
            }
            statement.close();
            statement = connection.createStatement();
            resultset = statement.executeQuery("select ID from EXTENSION_ADMIN");
            while (resultset.next()) {
                id = resultset.getString("ID");
                name = WikittyExtension.computeName((String)id);
                computeVersion = WikittyExtension.computeVersion((String)id);
                if (computeVersion.equals(computeVersion2 = this.computeVersion(id))) continue;
                newID = WikittyExtension.computeId((String)name, (String)computeVersion);
                update = "update EXTENSION_ADMIN set ID = '%s', VERSION = '%s' where ID = '%s'";
                updateStatement = connection.createStatement();
                updateStatement.executeUpdate(String.format(update, newID, computeVersion, id));
                updateStatement.close();
            }
            statement.close();
            updateStatement = connection.createStatement();
            updateStatement.executeUpdate("ALTER TABLE EXTENSION_DATA SET REFERENTIAL_INTEGRITY TRUE");
            updateStatement.close();
            statement = connection.createStatement();
            resultset = statement.executeQuery("select ID, EXTENSION_LIST from WIKITTY_ADMIN");
            while (resultset.next()) {
                id = resultset.getString("ID");
                String extensionList = resultset.getString("EXTENSION_LIST");
                if (extensionList == null || extensionList.isEmpty()) continue;
                StringBuilder extensionListBuilder = new StringBuilder();
                for (String extensionId : extensionList.split(",")) {
                    String computeVersion22;
                    String name2 = WikittyExtension.computeName((String)extensionId);
                    String computeVersion3 = WikittyExtension.computeVersion((String)extensionId);
                    if (!computeVersion3.equals(computeVersion22 = this.computeVersion(extensionId))) {
                        extensionListBuilder.append(WikittyExtension.computeId((String)name2, (String)computeVersion3)).append(",");
                        continue;
                    }
                    extensionListBuilder.append(extensionId).append(",");
                }
                String newExtensionList = extensionListBuilder.substring(0, extensionListBuilder.length() - 1);
                String update2 = "update WIKITTY_ADMIN set EXTENSION_LIST = '%s' where ID = '%s'";
                updateStatement = connection.createStatement();
                updateStatement.executeUpdate(String.format(update2, newExtensionList, id));
                updateStatement.close();
            }
            statement.close();
            connection.commit();
        }
        catch (ClassNotFoundException e) {
            throw new WikittyException((Exception)e);
        }
        catch (Exception e) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new WikittyException(e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e1) {}
        }
    }

    String computeVersion(String id) {
        int b = id.lastIndexOf("[");
        int e = id.lastIndexOf("]");
        String result = null;
        if (b != -1 && e != -1) {
            result = id.substring(b + 1, e);
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            ServiceFactory.getWikittyProxy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

