/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import java.text.SimpleDateFormat;
import java.util.*;

import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.SessionBean;

/**
 * User: sletellier
 * Date: 18 fev. 2010
 * Time: 16:00:19
 */
public class VradiSessionDTO extends SessionBean implements VradiDTO<Session> {

    private static final long serialVersionUID = 1L;

    protected List<VradiSendingDTO> sendingList;

    public VradiSessionDTO() {
        sendingList = new ArrayList<VradiSendingDTO>();
    }

    @Override
    public void fromWikitty(Session wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());
            setSessionDate(wikitty.getSessionDate());
            setNum(wikitty.getNum());
            setStatus(wikitty.getStatus());
            setParagraph(wikitty.getParagraph());
        }
    }

    public void reset() {
        setWikittyId(null);
        setSessionDate(null);
        setNum(0);
        setStatus(0);
        setParagraph("");
    }

    @Override
    public void setSessionDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        super.setSessionDate(calendar.getTime());
    }

    @Override
    public void toWikitty(Session wikitty) {
        wikitty.setSessionDate(getSessionDate());
        wikitty.setNum(getNum());
        wikitty.setStatus(getStatus());
        wikitty.setParagraph(getParagraph());
    }

    @Override
    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public void setSendingList(List<VradiSendingDTO> sending){
        List<VradiSendingDTO> old = this.sendingList;
        sendingList = sending;
        propertyChange.firePropertyChange("sendingList", old, sendingList);
    }

    public List<VradiSendingDTO> getSendingList(){
        return this.sendingList;
    }

    public void addSending(VradiSendingDTO sending){
        List<VradiSendingDTO> old = this.sendingList;
        sendingList.add(sending);
        propertyChange.firePropertyChange("sendingList", old, sendingList);
    }

    public void addAllSending(List<VradiSendingDTO> sending){
        List<VradiSendingDTO> old = this.sendingList;
        sendingList.addAll(sending);
        propertyChange.firePropertyChange("sendingList", old, sendingList);
    }

    public void removeSending(VradiSendingDTO sending){
        List<VradiSendingDTO> old = this.sendingList;
        sendingList.remove(sending);
        propertyChange.firePropertyChange("sendingList", old, sendingList);
    }

    public void removeAllSending(List<VradiSendingDTO> sending){
        List<VradiSendingDTO> old = this.sendingList;
        sendingList.removeAll(sending);
        propertyChange.firePropertyChange("sendingList", old, sendingList);
    }


    public void clearSending(){
        List<VradiSendingDTO> old = this.sendingList;
        sendingList.clear();
        propertyChange.firePropertyChange("sendingList", old, sendingList);
    }

    public Map<VradiClientDTO, VradiSendingDTO> getClientsSendingConcernedBy(VradiFormDTO form){
        Map<VradiClientDTO, VradiSendingDTO> result = new HashMap<VradiClientDTO, VradiSendingDTO>();
        for (VradiSendingDTO sending : getSendingList()){
            if (sending.getForm().contains(form.getWikittyId())){
                if (sending.getClient() != null){
                    result.put(sending.getClientDTO(), sending);
                }
            }
        }
        return result;
    }

    public Map<VradiUserDTO, VradiSendingDTO> getUsersSendingConcernedBy(VradiFormDTO form){
        Map<VradiUserDTO, VradiSendingDTO> result = new HashMap<VradiUserDTO, VradiSendingDTO>();
        for (VradiSendingDTO sending : getSendingList()){
            if (sending.getForm().contains(form.getWikittyId())){
                if (sending.getUser() != null){
                    result.put(sending.getUserDTO(), sending);
                }
            }
        }
        return result;

    }

    public Map<VradiGroupDTO, VradiSendingDTO> getGroupsSendingConcernedBy(VradiFormDTO form){
        Map<VradiGroupDTO, VradiSendingDTO> result = new HashMap<VradiGroupDTO, VradiSendingDTO>();
        for (VradiSendingDTO sending : getSendingList()){
            if (sending.getForm().contains(form.getWikittyId())){
                if (sending.getGroup() != null){
                    result.put(sending.getGroupDTO(), sending);
                }
            }
        }
        return result;
    }

    public int getNbFormToSend() {
        int result = 0;
        for (VradiSendingDTO sending : getSendingList()){

            // Only users forms
            if (sending.getUserDTO() != null){
                result = result + sending.getFormDTOs().size();
            }
        }
        return result;
    }

    @Override
    public String toString() {
        SimpleDateFormat simpleFormat = new SimpleDateFormat("dd/MM/yyyy");
		return simpleFormat.format(getSessionDate());
    }
}
