/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.server;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.exceptions.AWSExceptionFactory;
import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import com.amazonaws.services.dynamodbv2.local.dispatchers.BatchGetItemDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.BatchWriteItemDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.CreateTableDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.DeleteItemDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.DeleteTableDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.DescribeTableDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.Dispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.GetItemDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.ListTablesDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.PutItemDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.QueryDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.ScanDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.UpdateItemDispatcher;
import com.amazonaws.services.dynamodbv2.local.dispatchers.UpdateTableDispatcher;
import com.amazonaws.services.dynamodbv2.local.exceptions.ExceptionBean;
import com.amazonaws.services.dynamodbv2.local.server.AbstractLocalDynamoDBServerHandler;
import com.amazonaws.services.dynamodbv2.local.server.DynamoDBRequestHandler;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Request;

public class LocalDynamoDBServerHandler
extends AbstractLocalDynamoDBServerHandler {
    static Logger logger = Logger.getLogger(LocalDynamoDBServerHandler.class);
    private static Map<String, Dispatcher> dispatchers;
    private static Map<String, Class> classes;
    private static final int MAX_REQUEST_SIZE = 0x100000;

    public LocalDynamoDBServerHandler(DynamoDBRequestHandler primaryHandler) {
        super(primaryHandler);
        Logger.getLogger((String)"org.apache.http").setLevel(Level.OFF);
        dispatchers = new HashMap<String, Dispatcher>();
        dispatchers.put("BatchGetItem", new BatchGetItemDispatcher(this.jsonMapper));
        dispatchers.put("BatchWriteItem", new BatchWriteItemDispatcher(this.jsonMapper));
        dispatchers.put("CreateTable", new CreateTableDispatcher(this.jsonMapper));
        dispatchers.put("DeleteItem", new DeleteItemDispatcher(this.jsonMapper));
        dispatchers.put("DeleteTable", new DeleteTableDispatcher(this.jsonMapper));
        dispatchers.put("DescribeTable", new DescribeTableDispatcher(this.jsonMapper));
        dispatchers.put("GetItem", new GetItemDispatcher(this.jsonMapper));
        dispatchers.put("ListTables", new ListTablesDispatcher(this.jsonMapper));
        dispatchers.put("PutItem", new PutItemDispatcher(this.jsonMapper));
        dispatchers.put("Query", new QueryDispatcher(this.jsonMapper));
        dispatchers.put("Scan", new ScanDispatcher(this.jsonMapper));
        dispatchers.put("UpdateItem", new UpdateItemDispatcher(this.jsonMapper));
        dispatchers.put("UpdateTable", new UpdateTableDispatcher(this.jsonMapper));
        classes = new HashMap<String, Class>();
        classes.put("BatchGetItem", BatchGetItemRequest.class);
        classes.put("BatchWriteItem", BatchWriteItemRequest.class);
        classes.put("CreateTable", CreateTableRequest.class);
        classes.put("DeleteItem", DeleteItemRequest.class);
        classes.put("DeleteTable", DeleteTableRequest.class);
        classes.put("DescribeTable", DescribeTableRequest.class);
        classes.put("GetItem", GetItemRequest.class);
        classes.put("ListTables", ListTablesRequest.class);
        classes.put("PutItem", PutItemRequest.class);
        classes.put("Query", QueryRequest.class);
        classes.put("Scan", ScanRequest.class);
        classes.put("UpdateItem", UpdateItemRequest.class);
        classes.put("UpdateTable", UpdateTableRequest.class);
    }

    private static byte[] fromStream(InputStream inStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[0x100000];
        int totalBytesRead = 0;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((bytesRead = inStream.read(buffer)) != -1) {
            if ((totalBytesRead += bytesRead) > 0x100000) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.REQUEST_TOO_LARGE);
            }
            output.write(buffer, 0, bytesRead);
        }
        return output.toByteArray();
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.info((Object)"-----request start-----");
        int responseCode = 0;
        byte[] responseBody = null;
        try {
            if (baseRequest.getHeader("Authorization") == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.MISSING_AUTHENTICATION_TOKEN);
            }
            String[] auth = baseRequest.getHeader("Authorization").split("=|/");
            String accessKey = auth[1];
            String region = auth[3];
            String[] amzTargetComponents = baseRequest.getHeader("X-Amz-Target").split("\\.");
            if (!amzTargetComponents[0].equals("DynamoDB_20120810")) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INVALID_ACTION);
            }
            String amzTarget = amzTargetComponents[1];
            byte[] body = LocalDynamoDBServerHandler.fromStream((InputStream)request.getInputStream());
            logger.info((Object)String.format("accessKey: %s\tregion: %s", accessKey, region));
            logger.info((Object)("target: " + amzTarget));
            logger.info((Object)("body: \n" + new String(body, StandardCharsets.UTF_8)));
            Dispatcher dispatcher = dispatchers.get(amzTarget);
            if (dispatcher == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INVALID_ACTION);
            }
            Class requestClass = classes.get(amzTarget);
            responseBody = dispatcher.enact(accessKey, region, this.jsonMapper.readValue(body, requestClass), this.primaryHandler);
            responseCode = 200;
            for (DynamoDBRequestHandler handler : this.secondaryHandlers.values()) {
                try {
                    dispatcher.enact(accessKey, region, this.jsonMapper.readValue(body, requestClass), handler);
                }
                catch (Exception e) {
                    logger.error((Object)"Secondary Handler failed:\n", (Throwable)e);
                }
            }
        }
        catch (AmazonServiceException e) {
            responseCode = e.getStatusCode();
            responseBody = this.jsonMapper.writeValueAsBytes(new ExceptionBean(e.getErrorCode(), e.getMessage()));
        }
        catch (Exception e) {
            AmazonServiceExceptionType internalFailure = AmazonServiceExceptionType.INTERNAL_FAILURE;
            responseCode = internalFailure.getResponseStatus();
            responseBody = this.jsonMapper.writeValueAsBytes(new ExceptionBean(internalFailure));
            logger.error((Object)"Unknown error", (Throwable)e);
        }
        logger.info((Object)("status: " + responseCode));
        logger.info((Object)("response body:\n" + new String(responseBody, StandardCharsets.UTF_8)));
        logger.info((Object)"-----request end-----");
        response.setStatus(responseCode);
        response.setContentType("application/x-amz-json-1.0");
        baseRequest.setHandled(true);
        response.getOutputStream().write(responseBody);
    }
}

