/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.SgqService;
import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.model.ProductSearchModel;
import com.herbocailleau.sgq.business.services.csv.ClientImportModel;
import com.herbocailleau.sgq.business.services.csv.PlaceBean;
import com.herbocailleau.sgq.business.services.csv.PlaceImportModel;
import com.herbocailleau.sgq.business.services.csv.SupplierImportModel;
import com.herbocailleau.sgq.entities.AnalyzeCategory;
import com.herbocailleau.sgq.entities.AnalyzeCategoryDAO;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.AnalyzeTypeDAO;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.entities.ClientDAO;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.PlaceDAO;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductDAO;
import com.herbocailleau.sgq.entities.ProductPlace;
import com.herbocailleau.sgq.entities.ProductPlaceDAO;
import com.herbocailleau.sgq.entities.ProductStatus;
import com.herbocailleau.sgq.entities.ProductStatusDAO;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.entities.SupplierDAO;
import com.herbocailleau.sgq.entities.Zone;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.csv.AbstractImportErrorInfo;
import org.nuiton.util.csv.Import2;
import org.nuiton.util.csv.ImportConf;
import org.nuiton.util.csv.ImportModel;
import org.nuiton.util.csv.ImportRow;

public class ReferentialService
extends SgqService {
    private static final Log log = LogFactory.getLog(ReferentialService.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ImportLog<Client>> importClients(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing client from file " + file.getAbsolutePath()));
        }
        ArrayList<ImportLog<Client>> importLogs = new ArrayList<ImportLog<Client>>();
        InputStreamReader reader = null;
        try {
            ClientDAO clientDAO = this.daoHelper.getClientDAO();
            reader = new InputStreamReader((InputStream)new FileInputStream(file), this.config.getImportCsvFileEncoding());
            ClientImportModel model = new ClientImportModel();
            boolean noErrors = true;
            ImportConf conf = new ImportConf();
            conf.setStrictMode(false);
            Import2 importCsv = Import2.newImport((ImportConf)conf, (ImportModel)model, (Reader)reader);
            for (ImportRow row : importCsv) {
                Client bean = (Client)row.getBean();
                if (row.isValid()) {
                    ImportLog importLog = new ImportLog();
                    Object client = clientDAO.findByCode(bean.getCode());
                    if (client == null) {
                        client = (Client)clientDAO.create(new Object[]{"code", bean.getCode()});
                        importLog.setMessage(I18n._((String)"Creation d'un nouveau client", (Object[])new Object[0]));
                    } else {
                        importLog.setMessage(I18n._((String)"Mise \u00e0 jour du client", (Object[])new Object[0]));
                    }
                    client.setName(bean.getName());
                    importLog.setBean(client);
                    importLog.setLine(row.getLineNumber());
                    importLog.setCode(client.getCode());
                    importLogs.add(importLog);
                    continue;
                }
                noErrors = false;
                Set rowErrors = row.getErrors();
                for (AbstractImportErrorInfo rowError : rowErrors) {
                    ImportLog importLog = new ImportLog(true);
                    importLog.setLine(row.getLineNumber());
                    importLog.setCode(((Client)row.getBean()).getCode());
                    importLog.setMessage(rowError.getCause().getMessage());
                    importLogs.add(importLog);
                }
            }
            if (noErrors) {
                this.daoHelper.commit();
            }
        }
        catch (TopiaException ex) {
            try {
                throw new SgqBusinessException("Can't commit modification in database", ex);
                catch (IOException ex2) {
                    throw new SgqBusinessException("Can't read csv file", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return importLogs;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ImportLog<Product>> importProducts(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing product from file " + file.getAbsolutePath()));
        }
        ArrayList<ImportLog<Product>> importLogs = new ArrayList<ImportLog<Product>>();
        CSVReader csvReader = null;
        try {
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            ProductStatusDAO productStatusDAO = this.daoHelper.getProductStatusDAO();
            AnalyzeCategoryDAO analyzeCategoryDAO = this.daoHelper.getAnalyzeCategoryDAO();
            AnalyzeTypeDAO analyzeTypeDAO = this.daoHelper.getAnalyzeTypeDAO();
            csvReader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), this.config.getImportCsvFileEncoding()), ';');
            String[] metaHeaders = csvReader.readNext();
            Object[] headers = csvReader.readNext();
            Object[] mandatoryHeaders = (String[])ArrayUtils.subarray((Object[])headers, (int)0, (int)5);
            Object[] expHeaders = new String[]{"Code Produit", "Nom Produit", "Cat\u00e9gorie", "D\u00e9signation Latine", "Famille"};
            if (!Arrays.equals(mandatoryHeaders, expHeaders)) {
                throw new SgqBusinessException(I18n._((String)"Le fichier ne contient pas au moins les entetes obligatoires %s, trouv\u00e9s %s", (Object[])new Object[]{StringUtils.join((Object[])expHeaders, (char)';'), StringUtils.join((Object[])mandatoryHeaders, (char)';')}));
            }
            String[] row = null;
            while ((row = csvReader.readNext()) != null) {
                if (row.length <= 1) continue;
                String code = row[0];
                Product product = (Product)productDAO.create(new Object[]{"code", code});
                product.setName(row[1]);
                product.setCategory(row[2]);
                product.setLatinName(row[3]);
                product.setFamily(row[4]);
                StringBuilder commentaires = new StringBuilder();
                for (int index = 5; index < row.length; ++index) {
                    String data = row[index].trim();
                    String metaHeader = metaHeaders[index].trim();
                    String header = ((String)headers[index]).trim();
                    if (header.startsWith("Commentaire")) {
                        if (!StringUtils.isNotBlank((CharSequence)data)) continue;
                        commentaires.append(header + "\n");
                        commentaires.append("-----------\n");
                        commentaires.append(data + "\n");
                        continue;
                    }
                    if (header.startsWith("Lieu d'analyse ")) continue;
                    if ("statut".equalsIgnoreCase(metaHeader)) {
                        if (!data.equalsIgnoreCase("Oui") && !data.equalsIgnoreCase("Oui avec limite")) continue;
                        Object status = productStatusDAO.findByName(header);
                        if (status == null) {
                            status = (ProductStatus)productStatusDAO.create(new Object[0]);
                            status.setName(header);
                        }
                        product.addProductStatus((ProductStatus)status);
                        if (!data.equalsIgnoreCase("Oui avec limite")) continue;
                        commentaires.append(header + " : " + data + "\n");
                        continue;
                    }
                    if ("analyse".equalsIgnoreCase(metaHeader)) {
                        String[] analyzes;
                        for (String analyze : analyzes = data.split("\\s*[,;]\\s*")) {
                            if (analyze.isEmpty()) continue;
                            Object analyzeType = analyzeTypeDAO.findByName(analyze);
                            if (analyzeType == null) {
                                Object analyzeCategory = analyzeCategoryDAO.findByName(header);
                                if (analyzeCategory == null) {
                                    analyzeCategory = (AnalyzeCategory)analyzeCategoryDAO.create(new Object[0]);
                                    analyzeCategory.setName(header);
                                }
                                analyzeType = (AnalyzeType)analyzeTypeDAO.create(new Object[0]);
                                analyzeType.setName(analyze);
                                analyzeType.setAnalyzeCategory((AnalyzeCategory)analyzeCategory);
                                analyzeType.setDurationDays(30);
                            }
                            product.addAnalyzeType((AnalyzeType)analyzeType);
                        }
                        continue;
                    }
                    if (!"contr\u00f4le".equalsIgnoreCase(metaHeader) || !data.equalsIgnoreCase("Oui")) continue;
                    if ("Botanique".equalsIgnoreCase(header)) {
                        product.setBotanicControl(true);
                        continue;
                    }
                    if (!"Identification".equalsIgnoreCase(header)) continue;
                    product.setIdentificationControl(true);
                }
                product.setComment(commentaires.toString());
                productDAO.update(product);
            }
            csvReader.close();
            this.daoHelper.commit();
        }
        catch (IOException ex) {
            try {
                throw new SgqBusinessException("Can't import product file", ex);
                catch (TopiaException ex2) {
                    throw new SgqBusinessException("Can't import product file", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(csvReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)csvReader);
        return importLogs;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ImportLog<Place>> importPlaces(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing places from file " + file.getAbsolutePath()));
        }
        ArrayList<ImportLog<Place>> importLogs = new ArrayList<ImportLog<Place>>();
        InputStreamReader reader = null;
        try {
            PlaceDAO placeDAO = this.daoHelper.getPlaceDAO();
            ProductPlaceDAO productPlaceDAO = this.daoHelper.getProductPlaceDAO();
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            HashMap<String, Product> products = new HashMap<String, Product>();
            for (Product product : productDAO.findAll()) {
                products.put(product.getCode(), product);
            }
            reader = new InputStreamReader((InputStream)new FileInputStream(file), this.config.getImportCsvFileEncoding());
            PlaceImportModel model = new PlaceImportModel(products);
            ImportConf conf = new ImportConf();
            conf.setStrictMode(false);
            Import2 importCsv = Import2.newImport((ImportConf)conf, (ImportModel)model, (Reader)reader);
            productPlaceDAO.deleteAll();
            HashSet placeCache = new HashSet();
            for (ImportRow row : importCsv) {
                PlaceBean bean = (PlaceBean)row.getBean();
                String placeCode = bean.getCode();
                if (row.isValid()) {
                    ImportLog importLog = new ImportLog();
                    importLog.setLine(row.getLineNumber());
                    importLog.setCode(placeCode);
                    Object place = placeDAO.findByCode(placeCode);
                    if (place == null) {
                        place = placeDAO.createByNaturalId(placeCode);
                        importLog.setMessage(I18n._((String)"L'emplacement %s a \u00e9t\u00e9 cr\u00e9\u00e9 dans le r\u00e9f\u00e9rentiel pour la plante %s et sa pr\u00e9sentation %c", (Object[])new Object[]{placeCode, bean.getProduct().getCode(), Character.valueOf(bean.getPresentationCode().getCode())}));
                    }
                    importLog.setBean(place);
                    place.setZone(bean.getZone());
                    place.setName(bean.getName());
                    place = (Place)placeDAO.update((TopiaEntity)place);
                    ProductPlace productPlace = (ProductPlace)productPlaceDAO.create(new Object[0]);
                    productPlace.setPlace((Place)place);
                    productPlace.setProduct(bean.getProduct());
                    productPlace.setPresentationCode(bean.getPresentationCode());
                    placeCache.add(place);
                    importLogs.add(importLog);
                    continue;
                }
                Set rowErrors = row.getErrors();
                for (AbstractImportErrorInfo rowError : rowErrors) {
                    ImportLog importLog = new ImportLog(true);
                    importLog.setLine(row.getLineNumber());
                    importLog.setCode(placeCode);
                    importLog.setMessage(rowError.getCause().getMessage());
                    importLogs.add(importLog);
                }
            }
            List allPlaces = placeDAO.findAll();
            Collection toDeletes = CollectionUtils.subtract((Collection)allPlaces, placeCache);
            for (Place toDelete : toDeletes) {
                long usedBy = placeDAO.getProductInventoredIntoPlace(toDelete);
                if (usedBy == 0L) {
                    placeDAO.delete(toDelete);
                    continue;
                }
                ImportLog importLog = new ImportLog(true);
                importLog.setCode(toDelete.getCode());
                importLog.setMessage(I18n._((String)"Impossible de supprimer l'emplacement %s/%s car %d pr\u00e9sentations y ont \u00e9t\u00e9 localis\u00e9 par l'inventaire", (Object[])new Object[]{toDelete.getZone().name(), toDelete.getCode(), usedBy}));
                importLogs.add(importLog);
            }
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            try {
                throw new SgqBusinessException("Can't commit modification in database", ex);
                catch (IOException ex2) {
                    throw new SgqBusinessException("Can't import csv file", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return importLogs;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ImportLog<Supplier>> importSuppliers(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing suppliers from file " + file.getAbsolutePath()));
        }
        ArrayList<ImportLog<Supplier>> importLogs = new ArrayList<ImportLog<Supplier>>();
        InputStreamReader reader = null;
        try {
            SupplierDAO supplierDAO = this.daoHelper.getSupplierDAO();
            reader = new InputStreamReader((InputStream)new FileInputStream(file), this.config.getImportCsvFileEncoding());
            SupplierImportModel model = new SupplierImportModel();
            ImportConf conf = new ImportConf();
            conf.setStrictMode(false);
            Import2 importCsv = Import2.newImport((ImportConf)conf, (ImportModel)model, (Reader)reader);
            for (ImportRow row : importCsv) {
                Supplier bean = (Supplier)row.getBean();
                String supplierCode = bean.getCode();
                if (row.isValid()) {
                    ImportLog importLog = new ImportLog();
                    importLog.setLine(row.getLineNumber());
                    importLog.setCode(supplierCode);
                    Object supplier = supplierDAO.findByCode(supplierCode);
                    if (supplier == null) {
                        supplier = supplierDAO.createByNaturalId(bean.getCode());
                        importLog.setMessage(I18n._((String)"Creation d'un nouveau fournisseur : %s", (Object[])new Object[]{supplierCode}));
                    } else {
                        importLog.setMessage(I18n._((String)"Mise \u00e0 jour du fournisseur : %s", (Object[])new Object[]{supplierCode}));
                    }
                    supplier.setName(bean.getName());
                    supplier.setLaboratory(bean.isLaboratory());
                    supplierDAO.update((TopiaEntity)supplier);
                    importLogs.add(importLog);
                    continue;
                }
                Set rowErrors = row.getErrors();
                for (AbstractImportErrorInfo rowError : rowErrors) {
                    ImportLog importLog = new ImportLog(true);
                    importLog.setLine(row.getLineNumber());
                    importLog.setCode(supplierCode);
                    importLog.setMessage(rowError.getCause().getMessage());
                    importLogs.add(importLog);
                }
            }
            this.daoHelper.commit();
        }
        catch (IOException ex) {
            try {
                throw new SgqBusinessException("Can't read csv file", ex);
                catch (TopiaException ex2) {
                    throw new SgqBusinessException("Can't commit modification in database", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return importLogs;
    }

    public long getClientsCount() {
        long result = 0L;
        try {
            ClientDAO clientDAO = this.daoHelper.getClientDAO();
            result = clientDAO.count();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return result;
    }

    public List<Client> getClients(int offset, int count) {
        List results = null;
        try {
            ClientDAO clientDAO = this.daoHelper.getClientDAO();
            results = clientDAO.findAllByQueryWithBound("from " + Client.class.getName() + " order by " + "code", offset, offset + count - 1, new Object[0]);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return results;
    }

    public Client findClientById(String id) {
        Client result = null;
        try {
            ClientDAO clientDAO = this.daoHelper.getClientDAO();
            result = (Client)clientDAO.findByTopiaId(id);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get client", ex);
        }
        return result;
    }

    public void saveClient(Client client) {
        try {
            ClientDAO clientDAO = this.daoHelper.getClientDAO();
            if (StringUtils.isEmpty((CharSequence)client.getTopiaId())) {
                clientDAO.create(client);
            } else {
                clientDAO.update(client);
            }
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't save client", ex);
        }
    }

    public long getPlacesCount() {
        long result = 0L;
        try {
            PlaceDAO placeDAO = this.daoHelper.getPlaceDAO();
            result = placeDAO.count();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return result;
    }

    public List<Place> getPlaces() {
        return this.getPlaces(null);
    }

    public List<Place> getPlaces(Zone zone) {
        List<Place> results = null;
        try {
            PlaceDAO placeDAO = this.daoHelper.getPlaceDAO();
            results = placeDAO.findAllForZone(zone);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get places", ex);
        }
        return results;
    }

    public Place getPlaceById(String placeId) {
        Place result = null;
        try {
            PlaceDAO placeDAO = this.daoHelper.getPlaceDAO();
            result = (Place)placeDAO.findByTopiaId(placeId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get place", ex);
        }
        return result;
    }

    protected Place getPlaceByCode(String code) {
        Place result = null;
        try {
            PlaceDAO productDAO = this.daoHelper.getPlaceDAO();
            result = (Place)productDAO.findByCode(code);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get place", ex);
        }
        return result;
    }

    public long getSuppliersCount() {
        long result = 0L;
        try {
            SupplierDAO supplierDAO = this.daoHelper.getSupplierDAO();
            result = supplierDAO.count();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return result;
    }

    public List<Supplier> getSuppliers(int offset, int count) {
        List results = null;
        try {
            SupplierDAO supplierDAO = this.daoHelper.getSupplierDAO();
            results = supplierDAO.findAllByQueryWithBound("from " + Supplier.class.getName() + " order by " + "code", offset, offset + count - 1, new Object[0]);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return results;
    }

    public Supplier getSupplierById(String supplierId) {
        Supplier result = null;
        try {
            SupplierDAO supplierDAO = this.daoHelper.getSupplierDAO();
            result = (Supplier)supplierDAO.findByTopiaId(supplierId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get supplier", ex);
        }
        return result;
    }

    public long getProductsCount() {
        long result = 0L;
        try {
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            result = productDAO.count();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return result;
    }

    public Pair<List<Product>, Long> getProducts(ProductSearchModel search, int offset, int count) {
        Pair result = null;
        try {
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            List<Product> products = productDAO.findAllModel(search, offset, count);
            long totalCount = productDAO.findAllCount(search);
            result = Pair.of(products, (Object)totalCount);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return result;
    }

    public InputStream getProductsAsCsv(ProductSearchModel search) {
        FileInputStream result = null;
        try {
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            List<Product> products = productDAO.findAllModel(search);
            File file = File.createTempFile("sgq-search", ".csv");
            file.deleteOnExit();
            CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(file), ';');
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("Code");
            headers.add("Nom");
            headers.add("Cat\u00e9gorie");
            headers.add("Nom latin");
            headers.add("Famille");
            headers.add("Statuts");
            headers.add("Analyses");
            headers.add("Contr\u00f4le");
            headers.add("Commentaire");
            csvWriter.writeNext(headers.toArray(new String[headers.size()]));
            for (Product product : products) {
                ArrayList<String> data = new ArrayList<String>(headers.size());
                data.add(product.getCode());
                data.add(product.getName());
                data.add(product.getCategory());
                data.add(product.getLatinName());
                data.add(product.getFamily());
                StringBuffer statusSB = new StringBuffer();
                String separator = "";
                if (product.getProductStatus() != null) {
                    for (ProductStatus productStatus : product.getProductStatus()) {
                        statusSB.append(separator);
                        statusSB.append(productStatus.getName());
                        separator = ", ";
                    }
                }
                data.add(statusSB.toString());
                StringBuffer analyzeTypeSB = new StringBuffer();
                separator = "";
                if (product.getAnalyzeType() != null) {
                    for (AnalyzeType analyzeType : product.getAnalyzeType()) {
                        analyzeTypeSB.append(separator);
                        analyzeTypeSB.append(analyzeType.getName());
                        separator = ", ";
                    }
                }
                data.add(analyzeTypeSB.toString());
                String control = "";
                if (product.isBotanicControl()) {
                    control = "Botanique";
                }
                if (product.isIdentificationControl()) {
                    if (!control.isEmpty()) {
                        control = control + ", ";
                    }
                    control = control + "Identification";
                }
                data.add(control);
                data.add(product.getComment());
                csvWriter.writeNext(data.toArray(new String[data.size()]));
            }
            csvWriter.close();
            result = new FileInputStream(file);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        catch (IOException ex) {
            throw new SgqBusinessException("Can't output csv file", ex);
        }
        return result;
    }

    public Product getProductById(String productId) {
        Product result = null;
        try {
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            result = (Product)productDAO.findByTopiaId(productId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get product", ex);
        }
        return result;
    }

    public void saveProduct(Product product, String productStatusName) {
        try {
            String productCode = product.getCode();
            if (StringUtils.isBlank((CharSequence)productCode)) {
                throw new SgqBusinessException(I18n._((String)"Impossible de cr\u00e9er un produit avec un code vide", (Object[])new Object[0]));
            }
            productCode = productCode.toUpperCase();
            product.setCode(productCode);
            if (StringUtils.isNotEmpty((CharSequence)productStatusName)) {
                ProductStatusDAO productStatusDAO = this.daoHelper.getProductStatusDAO();
                Object productStatus = productStatusDAO.findByName(productStatusName);
                if (productStatus == null) {
                    productStatus = (ProductStatus)productStatusDAO.create(new Object[0]);
                    productStatus.setName(productStatusName);
                }
                product.addProductStatus((ProductStatus)productStatus);
            }
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            if (StringUtils.isEmpty((CharSequence)product.getTopiaId())) {
                if (productDAO.findByCode(productCode) != null) {
                    throw new SgqBusinessException(I18n._((String)"Impossible de cr\u00e9er un produit avec le code d\u00e9j\u00e0 utilis\u00e9 %s", (Object[])new Object[]{productCode}));
                }
                productDAO.create(product);
            } else {
                productDAO.update(product);
            }
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't save product", ex);
        }
    }

    public boolean canBeDeleteProduct(Product product) {
        boolean result;
        try {
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            result = !productDAO.isUsedByAnyBatch(product);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't delete product", ex);
        }
        return result;
    }

    public boolean canBeArchivedProduct(Product product) {
        boolean result;
        try {
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            result = !productDAO.isUsedByNonExpiredBatch(product);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't delete product", ex);
        }
        return result;
    }

    public void deleteProduct(Product product) {
        try {
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            productDAO.delete(product);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't delete product", ex);
        }
    }

    public void archiveProduct(Product product) {
        try {
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            product.setArchived(true);
            productDAO.update(product);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't archive product", ex);
        }
    }

    public void unArchiveProduct(Product product) {
        try {
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            product.setArchived(false);
            productDAO.update(product);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't unarchive product", ex);
        }
    }

    public List<AnalyzeType> findAllAnalyzeTypes() {
        List result = null;
        try {
            AnalyzeTypeDAO analyzeTypeDAO = this.daoHelper.getAnalyzeTypeDAO();
            result = analyzeTypeDAO.findAllWithOrder(new String[]{"analyzeCategory.name", "name"});
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analyze types", ex);
        }
        return result;
    }

    public Map<AnalyzeType, Long> findAllAnalyzeTypesWithCount() {
        Map<AnalyzeType, Long> result = null;
        try {
            AnalyzeTypeDAO analyzeTypeDAO = this.daoHelper.getAnalyzeTypeDAO();
            result = analyzeTypeDAO.findAllWithUsageCount();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analyze types", ex);
        }
        return result;
    }

    public AnalyzeType findAnalyzeTypeById(String id) {
        AnalyzeType result = null;
        try {
            AnalyzeTypeDAO analyzeTypeDAO = this.daoHelper.getAnalyzeTypeDAO();
            result = (AnalyzeType)analyzeTypeDAO.findByTopiaId(id);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analyze type", ex);
        }
        return result;
    }

    public void deleteAnalyzeType(AnalyzeType analyzeType) {
        try {
            AnalyzeTypeDAO analyzeTypeDAO = this.daoHelper.getAnalyzeTypeDAO();
            analyzeTypeDAO.delete(analyzeType);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't delete analyze type", ex);
        }
    }

    public void saveAnalyzeType(AnalyzeType analyzeType) {
        try {
            AnalyzeTypeDAO analyzeTypeDAO = this.daoHelper.getAnalyzeTypeDAO();
            if (StringUtils.isEmpty((CharSequence)analyzeType.getTopiaId())) {
                analyzeTypeDAO.create(analyzeType);
            } else {
                analyzeTypeDAO.update(analyzeType);
            }
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't save analyze type", ex);
        }
    }

    public void saveAnalyzeCategory(AnalyzeCategory analyzeCategory) {
        try {
            AnalyzeCategoryDAO analyzeCategoryDAO = this.daoHelper.getAnalyzeCategoryDAO();
            if (StringUtils.isEmpty((CharSequence)analyzeCategory.getTopiaId())) {
                analyzeCategoryDAO.create(analyzeCategory);
            } else {
                analyzeCategoryDAO.update(analyzeCategory);
            }
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't save analyze category", ex);
        }
    }

    public List<AnalyzeCategory> findAllAnalyzeCategories() {
        List result = null;
        try {
            AnalyzeCategoryDAO analyzeCategoryDAO = this.daoHelper.getAnalyzeCategoryDAO();
            result = analyzeCategoryDAO.findAllWithOrder(new String[]{"name"});
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analyze categories", ex);
        }
        return result;
    }

    public Map<AnalyzeCategory, Long> findAllAnalyzeCategoriesWithCount() {
        Map<AnalyzeCategory, Long> result = null;
        try {
            AnalyzeCategoryDAO analyzeCategoryDAO = this.daoHelper.getAnalyzeCategoryDAO();
            result = analyzeCategoryDAO.findAllWithUsageCount();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analyze categories", ex);
        }
        return result;
    }

    public AnalyzeCategory findAnalyzeCategoryById(String id) {
        AnalyzeCategory result = null;
        try {
            AnalyzeCategoryDAO analyzeCategoryDAO = this.daoHelper.getAnalyzeCategoryDAO();
            result = (AnalyzeCategory)analyzeCategoryDAO.findByTopiaId(id);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analyze category", ex);
        }
        return result;
    }

    public void deleteAnalyzeCategory(AnalyzeCategory analyzeCategory) {
        try {
            AnalyzeCategoryDAO analyzeCategoryDAO = this.daoHelper.getAnalyzeCategoryDAO();
            analyzeCategoryDAO.delete(analyzeCategory);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't delete analyze category", ex);
        }
    }

    public List<Supplier> getAllSupplierOnlyLabs() {
        List<Supplier> result;
        try {
            SupplierDAO supplierDAO = this.daoHelper.getSupplierDAO();
            result = supplierDAO.findAllOnlyLabs();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analyze category", ex);
        }
        return result;
    }

    public List<ProductStatus> findAllProductStatus() {
        List result;
        try {
            ProductStatusDAO productStatusDAO = this.daoHelper.getProductStatusDAO();
            result = productStatusDAO.findAllWithOrder(new String[]{"name ASC"});
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get product status", ex);
        }
        return result;
    }

    public Map<ProductStatus, Long> findAllProductStatusWithCount() {
        Map<ProductStatus, Long> result;
        try {
            ProductStatusDAO productStatusDAO = this.daoHelper.getProductStatusDAO();
            result = productStatusDAO.findAllWithProductCount();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get product status", ex);
        }
        return result;
    }

    public ProductStatus getProductStatusById(String productStatusId) {
        ProductStatus result = null;
        try {
            ProductStatusDAO productStatusDAO = this.daoHelper.getProductStatusDAO();
            result = (ProductStatus)productStatusDAO.findByTopiaId(productStatusId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get product status", ex);
        }
        return result;
    }

    public void deleteProductStatus(ProductStatus productStatus) {
        try {
            ProductStatusDAO productStatusDAO = this.daoHelper.getProductStatusDAO();
            productStatusDAO.delete(productStatus);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't delete product status", ex);
        }
    }

    public List<String> findAllProductCategories() {
        List<String> result = null;
        try {
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            result = productDAO.findDistinctCategories();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get product categories", ex);
        }
        return result;
    }
}

