package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class AnalyzeCategoryDAOAbstract<E extends AnalyzeCategory> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)AnalyzeCategory.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.AnalyzeCategory;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<AnalyzeType> list = getContext()
                                                    .getDAO(AnalyzeType.class)
                                                    .findAllByProperties(AnalyzeType.PROPERTY_ANALYZE_CATEGORY, entity);
                                            for (AnalyzeType item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getAnalyzeCategory())) {
                                                    item.setAnalyzeCategory(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(AnalyzeCategory.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(AnalyzeCategory.PROPERTY_NAME, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == AnalyzeType.class) {
            AnalyzeTypeDAO dao = (AnalyzeTypeDAO)
                getContext().getDAO(AnalyzeType.class);
            tmp = dao.findAllByAnalyzeCategory(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(AnalyzeType.class, entity);
        if (!list.isEmpty()) {
            result.put(AnalyzeType.class, list);
        }

        return result;
    }

} //AnalyzeCategoryDAOAbstract<E extends AnalyzeCategory>
