/*
 * #%L
 * SGQ :: Business
 * $Id: BatchModel.java 324 2013-04-18 15:36:39Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.2/sgq-business/src/main/java/com/herbocailleau/sgq/business/model/BatchModel.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.model;

import java.util.Date;
import java.util.List;

import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchAnalyze;

/**
 * Model de presentation d'un lot, englobant en plus la quantité totale
 * restante suivant les quantités des présentations.
 * 
 * @author echatellier
 */
public class BatchModel {

    protected Batch batch;

    protected double totalPresentation;

    protected double totalSale;

    protected Date dmes;

    /** Batch analyzes. (can be null if not requested by search query) */
    protected List<BatchAnalyze> batchAnalyzes;

    public BatchModel(Batch batch, double totalPresentation, double totalSale, Date dmes) {
        this.batch = batch;
        this.totalPresentation = totalPresentation;
        this.totalSale = totalSale;
        this.dmes = dmes;
    }

    public Batch getBatch() {
        return batch;
    }

    public double getTotalPresentation() {
        return totalPresentation;
    }

    public double getTotalSale() {
        return totalSale;
    }

    public Date getDmes() {
        // si la dmes du lot est renseignée, c'est qu'il s'agit d'une reprise
        // depuis le fichier excel, sinon il faut utiliser la dmes du present
        // model qui correspond à la date de la premiere expedition
        Date result = batch.getDmes();
        if (result == null) {
            result = dmes;
        }
        return result;
    }

    /**
     * Get batch analyze (can be null if {@link SearchColumn#ANALYZE_CONFORMITY}
     * is not selected for query.
     * 
     * @return batch analyzes
     */
    public List<BatchAnalyze> getBatchAnalyzes() {
        return batchAnalyzes;
    }

    public void setBatchAnalyzes(List<BatchAnalyze> batchAnalyzes) {
        this.batchAnalyzes = batchAnalyzes;
    }
}
