/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.format;

import com.helger.annotation.concurrent.Immutable;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.jspecify.annotations.NonNull;

@Immutable
public final class PDTFormatPatterns {
    private static final PDTFormatPatterns INSTANCE = new PDTFormatPatterns();

    private PDTFormatPatterns() {
    }

    public static @NonNull String getPatternDate(@NonNull FormatStyle formatStyle, @NonNull Locale locale) {
        return DateTimeFormatterBuilder.getLocalizedDateTimePattern(formatStyle, null, IsoChronology.INSTANCE, locale);
    }

    public static @NonNull String getDefaultPatternDate(@NonNull Locale locale) {
        return PDTFormatPatterns.getMediumPatternDate(locale);
    }

    public static @NonNull String getShortPatternDate(@NonNull Locale locale) {
        return PDTFormatPatterns.getPatternDate(FormatStyle.SHORT, locale);
    }

    public static @NonNull String getMediumPatternDate(@NonNull Locale locale) {
        return PDTFormatPatterns.getPatternDate(FormatStyle.MEDIUM, locale);
    }

    public static @NonNull String getLongPatternDate(@NonNull Locale locale) {
        return PDTFormatPatterns.getPatternDate(FormatStyle.LONG, locale);
    }

    public static @NonNull String getFullPatternDate(@NonNull Locale locale) {
        return PDTFormatPatterns.getPatternDate(FormatStyle.FULL, locale);
    }

    public static @NonNull String getPatternTime(@NonNull FormatStyle formatStyle, @NonNull Locale locale) {
        return DateTimeFormatterBuilder.getLocalizedDateTimePattern(null, formatStyle, IsoChronology.INSTANCE, locale);
    }

    public static @NonNull String getDefaultPatternTime(@NonNull Locale locale) {
        return PDTFormatPatterns.getMediumPatternTime(locale);
    }

    public static @NonNull String getShortPatternTime(@NonNull Locale locale) {
        return PDTFormatPatterns.getPatternTime(FormatStyle.SHORT, locale);
    }

    public static @NonNull String getMediumPatternTime(@NonNull Locale locale) {
        return PDTFormatPatterns.getPatternTime(FormatStyle.MEDIUM, locale);
    }

    public static @NonNull String getLongPatternTime(@NonNull Locale locale) {
        return PDTFormatPatterns.getPatternTime(FormatStyle.LONG, locale);
    }

    public static @NonNull String getFullPatternTime(@NonNull Locale locale) {
        return PDTFormatPatterns.getPatternTime(FormatStyle.FULL, locale);
    }

    public static @NonNull String getPatternDateTime(@NonNull FormatStyle formatStyle, @NonNull Locale locale) {
        return DateTimeFormatterBuilder.getLocalizedDateTimePattern(formatStyle, formatStyle, IsoChronology.INSTANCE, locale);
    }

    public static @NonNull String getDefaultPatternDateTime(@NonNull Locale locale) {
        return PDTFormatPatterns.getMediumPatternDateTime(locale);
    }

    public static @NonNull String getShortPatternDateTime(@NonNull Locale locale) {
        return PDTFormatPatterns.getPatternDateTime(FormatStyle.SHORT, locale);
    }

    public static @NonNull String getMediumPatternDateTime(@NonNull Locale locale) {
        return PDTFormatPatterns.getPatternDateTime(FormatStyle.MEDIUM, locale);
    }

    public static @NonNull String getLongPatternDateTime(@NonNull Locale locale) {
        return PDTFormatPatterns.getPatternDateTime(FormatStyle.LONG, locale);
    }

    public static @NonNull String getFullPatternDateTime(@NonNull Locale locale) {
        return PDTFormatPatterns.getPatternDateTime(FormatStyle.FULL, locale);
    }
}

