/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.format;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.cache.impl.Cache;
import com.helger.datetime.format.DateTimeFormatterPattern;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import org.jspecify.annotations.NonNull;

@ThreadSafe
public final class DateTimeFormatterCache
extends Cache<DateTimeFormatterPattern, DateTimeFormatter> {
    public static final int MAX_CACHE_SIZE = 1000;
    private static boolean s_bDefaultInstantiated = false;

    private DateTimeFormatterCache() {
        super(DateTimeFormatterPattern::getAsFormatter, 1000, DateTimeFormatterCache.class.getName());
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    public static @NonNull DateTimeFormatterCache getInstance() {
        DateTimeFormatterCache dateTimeFormatterCache = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return dateTimeFormatterCache;
    }

    public static @NonNull DateTimeFormatter getDateTimeFormatterStrict(@NonNull @Nonempty String string) {
        return DateTimeFormatterCache.getDateTimeFormatter(string, ResolverStyle.STRICT);
    }

    public static @NonNull DateTimeFormatter getDateTimeFormatterSmart(@NonNull @Nonempty String string) {
        return DateTimeFormatterCache.getDateTimeFormatter(string, ResolverStyle.SMART);
    }

    public static @NonNull DateTimeFormatter getDateTimeFormatterLenient(@NonNull @Nonempty String string) {
        return DateTimeFormatterCache.getDateTimeFormatter(string, ResolverStyle.LENIENT);
    }

    public static @NonNull DateTimeFormatter getDateTimeFormatter(@NonNull @Nonempty String string, @NonNull ResolverStyle resolverStyle) {
        return (DateTimeFormatter)DateTimeFormatterCache.getInstance().getFromCache(new DateTimeFormatterPattern(string, resolverStyle));
    }

    private static final class SingletonHolder {
        private static final DateTimeFormatterCache INSTANCE = new DateTimeFormatterCache();

        private SingletonHolder() {
        }
    }
}

