/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.apt;

import com.google.gwt.dev.util.Name;
import com.google.web.bindery.requestfactory.apt.Messages;
import com.google.web.bindery.requestfactory.apt.ScannerBase;
import com.google.web.bindery.requestfactory.apt.State;
import com.google.web.bindery.requestfactory.shared.JsonRpcService;
import com.google.web.bindery.requestfactory.shared.Service;
import com.google.web.bindery.requestfactory.shared.ServiceName;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

class RequestContextScanner
extends ScannerBase<Void> {
    RequestContextScanner() {
    }

    @Override
    public Void visitExecutable(ExecutableElement x, State state) {
        if (this.shouldIgnore(x, state)) {
            return null;
        }
        TypeMirror returnType = x.getReturnType();
        if (state.types.isAssignable(returnType, state.requestType)) {
            DeclaredType asRequest = (DeclaredType)State.viewAs(state.requestType, returnType, state);
            if (asRequest.getTypeArguments().isEmpty()) {
                state.poison(x, Messages.rawType());
            } else {
                TypeMirror requestReturn = asRequest.getTypeArguments().get(0);
                if (!state.isTransportableType(requestReturn)) {
                    state.poison(x, Messages.untransportableType(requestReturn));
                }
            }
        } else if (state.types.isAssignable(returnType, state.instanceRequestType)) {
            DeclaredType asInstanceRequest = (DeclaredType)State.viewAs(state.instanceRequestType, returnType, state);
            if (asInstanceRequest.getTypeArguments().isEmpty()) {
                state.poison(x, Messages.rawType());
            } else {
                TypeMirror instanceType = asInstanceRequest.getTypeArguments().get(0);
                state.maybeScanProxy((TypeElement)state.types.asElement(instanceType));
                TypeMirror requestReturn = asInstanceRequest.getTypeArguments().get(1);
                if (!state.isTransportableType(requestReturn)) {
                    state.poison(x, Messages.untransportableType(requestReturn));
                }
            }
        } else if (!this.isSetter(x, state)) {
            state.poison(x, Messages.contextRequiredReturnTypes(state.requestType.asElement().getSimpleName(), state.instanceRequestType.asElement().getSimpleName()));
        }
        return (Void)super.visitExecutable(x, state);
    }

    @Override
    public Void visitType(TypeElement x, State state) {
        Service service = x.getAnnotation(Service.class);
        ServiceName serviceName = x.getAnnotation(ServiceName.class);
        JsonRpcService jsonRpcService = x.getAnnotation(JsonRpcService.class);
        if (service != null) {
            RequestContextScanner.poisonIfAnnotationPresent(state, x, serviceName, jsonRpcService);
            try {
                service.value();
                throw new RuntimeException("Should not reach here");
            }
            catch (MirroredTypeException expected) {
                TypeMirror type = expected.getTypeMirror();
                state.addMapping(x, (TypeElement)state.types.asElement(type));
            }
        }
        if (serviceName != null) {
            RequestContextScanner.poisonIfAnnotationPresent(state, x, jsonRpcService);
            TypeElement domain = state.elements.getTypeElement(Name.BinaryName.toSourceName(serviceName.value()));
            if (domain == null) {
                state.warn(x, Messages.contextMissingDomainType(serviceName.value()));
            }
            state.addMapping(x, domain);
        }
        this.scanAllInheritedMethods(x, state);
        state.checkExtraTypes(x);
        return null;
    }

    @Override
    public Void visitTypeParameter(TypeParameterElement x, State state) {
        for (TypeMirror typeMirror : x.getBounds()) {
            if (state.isTransportableType(typeMirror)) continue;
            state.poison(x, Messages.untransportableType(typeMirror));
        }
        return (Void)super.visitTypeParameter(x, state);
    }

    @Override
    public Void visitVariable(VariableElement x, State state) {
        if (!state.isTransportableType(x.asType())) {
            state.poison(x, Messages.untransportableType(x.asType()));
        }
        return (Void)super.visitVariable(x, state);
    }
}

