/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.regex;

import java.util.Arrays;

final class CharRanges {
    private final int[] ranges;
    public static final CharRanges EMPTY = new CharRanges(new int[0]);
    public static final CharRanges ALL_CODE_UNITS = new CharRanges(new int[]{0, 65536});

    public static CharRanges inclusive(int start, int end) {
        if (start > end) {
            throw new IndexOutOfBoundsException(start + " > " + end);
        }
        return new CharRanges(new int[]{start, end + 1});
    }

    public static CharRanges withMembers(int ... members) {
        return new CharRanges(CharRanges.intArrayToRanges((int[])members.clone()));
    }

    public static CharRanges withRanges(int ... ranges) {
        if (((ranges = (int[])ranges.clone()).length & 1) != 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 1; i < ranges.length; ++i) {
            if (ranges[i] > ranges[i - 1]) continue;
            throw new IllegalArgumentException(ranges[i] + " > " + ranges[i - 1]);
        }
        return new CharRanges(ranges);
    }

    private CharRanges(int[] ranges) {
        this.ranges = ranges;
    }

    private static int[] intArrayToRanges(int[] members) {
        int nMembers = members.length;
        if (nMembers == 0) {
            return new int[0];
        }
        Arrays.sort(members);
        int nRuns = 1;
        for (int i = 1; i < nMembers; ++i) {
            int current = members[i];
            int last = members[i - 1];
            if (current == last || current == last + 1) continue;
            ++nRuns;
        }
        int[] ranges = new int[nRuns * 2];
        ranges[0] = members[0];
        int k = 0;
        int i = 1;
        while (k + 2 < ranges.length) {
            int current = members[i];
            int last = members[i - 1];
            if (current != last && current != last + 1) {
                ranges[++k] = last + 1;
                ranges[++k] = current;
            }
            ++i;
        }
        ranges[++k] = members[nMembers - 1] + 1;
        return ranges;
    }

    public boolean contains(int bit) {
        return (Arrays.binarySearch(this.ranges, bit) & 1) == 0;
    }

    public int minSetBit() {
        return this.ranges.length >= 0 ? this.ranges[0] : Integer.MIN_VALUE;
    }

    public boolean isEmpty() {
        return this.ranges.length == 0;
    }

    public int getNumRanges() {
        return this.ranges.length >> 1;
    }

    public int start(int i) {
        return this.ranges[i << 1];
    }

    public int end(int i) {
        return this.ranges[i << 1 | 1];
    }

    public CharRanges union(CharRanges other) {
        int[] q = this.ranges;
        int[] r = other.ranges;
        int m = q.length;
        int n = r.length;
        if (m == 0) {
            return other;
        }
        if (n == 0) {
            return this;
        }
        int[] out = new int[m + n];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < m && j < n) {
            int a0 = q[i];
            int a1 = q[i + 1];
            int b0 = r[j];
            int b1 = r[j + 1];
            if (a1 < b0) {
                out[k++] = a0;
                out[k++] = a1;
                i += 2;
                continue;
            }
            if (b1 < a0) {
                out[k++] = b0;
                out[k++] = b1;
                j += 2;
                continue;
            }
            int start = Math.min(a0, b0);
            int end = Math.max(a1, b1);
            i += 2;
            j += 2;
            while (i < m || j < n) {
                if (i < m && q[i] <= end) {
                    end = Math.max(end, q[i + 1]);
                    i += 2;
                    continue;
                }
                if (j >= n || r[j] > end) break;
                end = Math.max(end, r[j + 1]);
                j += 2;
            }
            out[k++] = start;
            out[k++] = end;
        }
        if (i < m) {
            System.arraycopy(q, i, out, k, m - i);
            k += m - i;
        } else if (j < n) {
            System.arraycopy(r, j, out, k, n - j);
            k += n - j;
        }
        if (k != out.length) {
            int[] clipped = Arrays.copyOf(out, k);
            out = clipped;
        }
        return new CharRanges(out);
    }

    public CharRanges intersection(CharRanges other) {
        int[] aRanges = this.ranges;
        int[] bRanges = other.ranges;
        int aLen = aRanges.length;
        int bLen = bRanges.length;
        if (aLen == 0) {
            return this;
        }
        if (bLen == 0) {
            return other;
        }
        int aIdx = 0;
        int bIdx = 0;
        int[] intersection = new int[Math.min(aLen, bLen)];
        int intersectionIdx = 0;
        int pos = Math.min(aRanges[0], bRanges[0]);
        while (aIdx < aLen && bIdx < bLen) {
            if (aRanges[aIdx + 1] <= pos) {
                aIdx += 2;
                continue;
            }
            if (bRanges[bIdx + 1] <= pos) {
                bIdx += 2;
                continue;
            }
            int start = Math.max(aRanges[aIdx], bRanges[bIdx]);
            if (pos < start) {
                pos = start;
                continue;
            }
            int end = Math.min(aRanges[aIdx + 1], bRanges[bIdx + 1]);
            if (intersectionIdx != 0 && pos == intersection[intersectionIdx - 1]) {
                intersection[intersectionIdx - 1] = end;
            } else {
                if (intersectionIdx == intersection.length) {
                    int[] newArr = new int[intersectionIdx * 2];
                    System.arraycopy(intersection, 0, newArr, 0, intersectionIdx);
                    intersection = newArr;
                }
                intersection[intersectionIdx++] = pos;
                intersection[intersectionIdx++] = end;
            }
            pos = end;
        }
        if (intersectionIdx != intersection.length) {
            int[] newArr = Arrays.copyOf(intersection, intersectionIdx);
            intersection = newArr;
        }
        return new CharRanges(intersection);
    }

    public CharRanges difference(CharRanges subtrahendRanges) {
        int[] minuend = this.ranges;
        int[] subtrahend = subtrahendRanges.ranges;
        int mn = minuend.length;
        int sn = subtrahend.length;
        if (mn == 0 || sn == 0) {
            return this;
        }
        int[] difference = new int[minuend.length];
        int mIdx = 0;
        int sIdx = 0;
        int dIdx = 0;
        int pos = minuend[0];
        while (mIdx < mn) {
            int end;
            if (pos >= minuend[mIdx + 1]) {
                mIdx += 2;
                continue;
            }
            if (pos < minuend[mIdx]) {
                pos = minuend[mIdx];
                continue;
            }
            if (sIdx < sn && pos >= subtrahend[sIdx]) {
                pos = subtrahend[sIdx + 1];
                sIdx += 2;
                continue;
            }
            int n = end = sIdx < sn ? Math.min(minuend[mIdx + 1], subtrahend[sIdx]) : minuend[mIdx + 1];
            if (dIdx != 0 && difference[dIdx - 1] == pos) {
                difference[dIdx - 1] = pos;
            } else {
                if (dIdx == difference.length) {
                    int[] newArr = new int[dIdx * 2];
                    System.arraycopy(difference, 0, newArr, 0, dIdx);
                    difference = newArr;
                }
                difference[dIdx++] = pos;
                difference[dIdx++] = end;
            }
            pos = end;
        }
        if (dIdx != difference.length) {
            int[] newArr = Arrays.copyOf(difference, dIdx);
            difference = newArr;
        }
        return new CharRanges(difference);
    }

    public boolean containsAll(CharRanges sub) {
        int[] superRanges = this.ranges;
        int[] subRanges = sub.ranges;
        int superIdx = 0;
        int subIdx = 0;
        int superLen = superRanges.length;
        int subLen = subRanges.length;
        while (subIdx < subLen) {
            if (superIdx == superLen) {
                return false;
            }
            if (superRanges[superIdx + 1] <= subRanges[subIdx]) {
                superIdx += 2;
                continue;
            }
            if (superRanges[superIdx] > subRanges[subIdx]) {
                return false;
            }
            if (superRanges[superIdx + 1] >= subRanges[subIdx + 1]) {
                subIdx += 2;
                continue;
            }
            return false;
        }
        return subIdx == subLen;
    }

    public CharRanges shift(int delta) {
        long lmax;
        long lmin;
        int n = this.ranges.length;
        if (delta == 0 || n == 0) {
            return this;
        }
        if (delta < 0 ? (lmin = (long)(this.ranges[0] + delta)) < Integer.MIN_VALUE : (lmax = (long)(this.ranges[n - 1] + delta)) > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        int[] shiftedRanges = new int[n];
        int i = n;
        while (--i >= 0) {
            shiftedRanges[i] = this.ranges[i] + delta;
        }
        return new CharRanges(shiftedRanges);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.ranges.length; ++i) {
            if ((i & 1) != 0 && this.ranges[i] == this.ranges[i - 1] + 1) continue;
            if (i != 0) {
                sb.append((i & 1) == 0 ? (char)' ' : '-');
            }
            sb.append("0x").append(Integer.toString(this.ranges[i] - (i & 1), 16));
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CharRanges)) {
            return false;
        }
        return Arrays.equals(this.ranges, ((CharRanges)o).ranges);
    }

    public int hashCode() {
        int hc = 0;
        int n = Math.min(16, this.ranges.length);
        for (int i = 0; i < n; ++i) {
            hc = (hc << 2) + this.ranges[i];
        }
        return hc;
    }
}

