/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import java.util.List;
import java.util.Set;

public final class JSDocInfoBuilder {
    private JSDocInfo currentInfo;
    private boolean populated = false;
    private boolean parseDocumentation = false;
    private JSDocInfo.Marker currentMarker = null;

    public JSDocInfoBuilder(boolean parseDocumentation) {
        this(new JSDocInfo(parseDocumentation), parseDocumentation, false);
    }

    private JSDocInfoBuilder(JSDocInfo info, boolean parseDocumentation, boolean populated) {
        this.currentInfo = info;
        this.parseDocumentation = parseDocumentation;
        this.populated = populated;
    }

    public static JSDocInfoBuilder copyFrom(JSDocInfo info) {
        JSDocInfoBuilder.populateDefaults(info);
        return new JSDocInfoBuilder(info.clone(), info.isDocumentationIncluded(), true);
    }

    public void recordOriginalCommentString(String sourceComment) {
        if (this.parseDocumentation) {
            this.currentInfo.setOriginalCommentString(sourceComment);
        }
    }

    public void recordOriginalCommentPosition(int position) {
        if (this.parseDocumentation) {
            this.currentInfo.setOriginalCommentPosition(position);
        }
    }

    public boolean shouldParseDocumentation() {
        return this.parseDocumentation;
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public boolean isPopulatedWithFileOverview() {
        return this.isPopulated() && (this.currentInfo.hasFileOverview() || this.currentInfo.isExterns() || this.currentInfo.isNoCompile());
    }

    public boolean isDescriptionRecorded() {
        return this.currentInfo.getDescription() != null;
    }

    public JSDocInfo build(Node associatedNode) {
        if (this.populated) {
            JSDocInfo built = this.currentInfo;
            built.setAssociatedNode(associatedNode);
            JSDocInfoBuilder.populateDefaults(built);
            this.populated = false;
            this.currentInfo = new JSDocInfo(this.parseDocumentation);
            return built;
        }
        return null;
    }

    private static void populateDefaults(JSDocInfo info) {
        if (info.getVisibility() == null) {
            info.setVisibility(JSDocInfo.Visibility.INHERITED);
        }
    }

    public void markAnnotation(String annotation, int lineno, int charno) {
        JSDocInfo.Marker marker = this.currentInfo.addMarker();
        if (marker != null) {
            JSDocInfo.TrimmedStringPosition position = new JSDocInfo.TrimmedStringPosition();
            position.setItem(annotation);
            position.setPositionInformation(lineno, charno, lineno, charno + annotation.length());
            marker.setAnnotation(position);
            this.populated = true;
        }
        this.currentMarker = marker;
    }

    public void markText(String text, int startLineno, int startCharno, int endLineno, int endCharno) {
        if (this.currentMarker != null) {
            JSDocInfo.StringPosition position = new JSDocInfo.StringPosition();
            position.setItem(text);
            position.setPositionInformation(startLineno, startCharno, endLineno, endCharno);
            this.currentMarker.setDescription(position);
        }
    }

    public void markTypeNode(Node typeNode, int lineno, int startCharno, int endLineno, int endCharno, boolean hasLC) {
        if (this.currentMarker != null) {
            JSDocInfo.TypePosition position = new JSDocInfo.TypePosition();
            position.setItem(typeNode);
            position.setHasBrackets(hasLC);
            position.setPositionInformation(lineno, startCharno, endLineno, endCharno);
            this.currentMarker.setType(position);
        }
    }

    @Deprecated
    public void markName(String name, int lineno, int charno) {
        this.markName(name, null, lineno, charno);
    }

    public void markName(String name, StaticSourceFile file, int lineno, int charno) {
        if (this.currentMarker != null) {
            JSDocInfo.TrimmedStringPosition position = new JSDocInfo.TrimmedStringPosition();
            position.setItem(name);
            position.setPositionInformation(lineno, charno, lineno, charno + name.length());
            this.currentMarker.setName(position);
            JSDocInfo.NamePosition nodePos = new JSDocInfo.NamePosition();
            Node node = Node.newString(38, name, lineno, charno);
            node.setLength(name.length());
            node.setStaticSourceFile(file);
            nodePos.setItem(node);
            nodePos.setPositionInformation(lineno, charno, lineno, charno + name.length());
            this.currentMarker.setNameNode(nodePos);
        }
    }

    public boolean recordBlockDescription(String description) {
        this.populated = true;
        return this.currentInfo.documentBlock(description);
    }

    public boolean recordVisibility(JSDocInfo.Visibility visibility) {
        if (this.currentInfo.getVisibility() == null) {
            this.populated = true;
            this.currentInfo.setVisibility(visibility);
            return true;
        }
        return false;
    }

    public boolean recordParameter(String parameterName, JSTypeExpression type) {
        if (!this.hasAnySingletonTypeTags() && this.currentInfo.declareParam(type, parameterName)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordParameterDescription(String parameterName, String description) {
        if (this.currentInfo.documentParam(parameterName, description)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordTemplateTypeNames(List<String> names) {
        if (this.currentInfo.declareTemplateTypeNames(names)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordThrowType(JSTypeExpression type) {
        if (!this.hasAnySingletonTypeTags()) {
            this.currentInfo.declareThrows(type);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordThrowDescription(JSTypeExpression type, String description) {
        if (this.currentInfo.documentThrows(type, description)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean addAuthor(String author) {
        if (this.currentInfo.documentAuthor(author)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean addReference(String reference) {
        if (this.currentInfo.documentReference(reference)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordConsistentIdGenerator() {
        if (!this.currentInfo.isConsistentIdGenerator()) {
            this.currentInfo.setConsistentIdGenerator(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordStableIdGenerator() {
        if (!this.currentInfo.isStableIdGenerator()) {
            this.currentInfo.setStableIdGenerator(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordMappedIdGenerator() {
        if (!this.currentInfo.isMappedIdGenerator()) {
            this.currentInfo.setMappedIdGenerator(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordVersion(String version) {
        if (this.currentInfo.documentVersion(version)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordDeprecationReason(String reason) {
        if (this.currentInfo.setDeprecationReason(reason)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordSuppressions(Set<String> suppressions) {
        if (this.currentInfo.setSuppressions(suppressions)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordModifies(Set<String> modifies) {
        if (!this.hasAnySingletonSideEffectTags() && this.currentInfo.setModifies(modifies)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordType(JSTypeExpression type) {
        if (type != null && !this.hasAnyTypeRelatedTags()) {
            this.currentInfo.setType(type);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordTypedef(JSTypeExpression type) {
        if (type != null && !this.hasAnyTypeRelatedTags()) {
            this.currentInfo.setTypedefType(type);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordIdGenerator() {
        if (!this.currentInfo.isIdGenerator()) {
            this.currentInfo.setIdGenerator(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordReturnType(JSTypeExpression jsType) {
        if (jsType != null && this.currentInfo.getReturnType() == null && !this.hasAnySingletonTypeTags()) {
            this.currentInfo.setReturnType(jsType);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordReturnDescription(String description) {
        if (this.currentInfo.documentReturn(description)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordDefineType(JSTypeExpression type) {
        if (type != null && !this.currentInfo.isConstant() && !this.currentInfo.isDefine() && this.recordType(type)) {
            this.currentInfo.setDefine(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordEnumParameterType(JSTypeExpression type) {
        if (type != null && !this.hasAnyTypeRelatedTags()) {
            this.currentInfo.setEnumParameterType(type);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordThisType(JSTypeExpression type) {
        if (type != null && !this.hasAnySingletonTypeTags() && !this.currentInfo.hasThisType()) {
            this.currentInfo.setThisType(type);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordBaseType(JSTypeExpression jsType) {
        if (jsType != null && !this.hasAnySingletonTypeTags() && !this.currentInfo.hasBaseType()) {
            this.currentInfo.setBaseType(jsType);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordConstancy() {
        if (!this.currentInfo.isConstant()) {
            this.currentInfo.setConstant(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordDescription(String description) {
        if (description != null && this.currentInfo.getDescription() == null) {
            this.currentInfo.setDescription(description);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordMeaning(String meaning) {
        if (meaning != null && this.currentInfo.getMeaning() == null) {
            this.currentInfo.setMeaning(meaning);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordFileOverview(String description) {
        if (this.currentInfo.documentFileOverview(description)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordHiddenness() {
        if (!this.currentInfo.isHidden()) {
            this.currentInfo.setHidden(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordNoCompile() {
        if (!this.currentInfo.isNoCompile()) {
            this.currentInfo.setNoCompile(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordNoTypeCheck() {
        if (!this.currentInfo.isNoTypeCheck()) {
            this.currentInfo.setNoCheck(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordConstructor() {
        if (!(this.hasAnySingletonTypeTags() || this.currentInfo.isConstructor() || this.currentInfo.isInterface())) {
            this.currentInfo.setConstructor(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isConstructorRecorded() {
        return this.currentInfo.isConstructor();
    }

    public boolean recordUnrestricted() {
        if (this.hasAnySingletonTypeTags() || this.currentInfo.isInterface() || this.currentInfo.makesDicts() || this.currentInfo.makesStructs() || this.currentInfo.makesUnrestricted()) {
            return false;
        }
        this.currentInfo.setUnrestricted();
        this.populated = true;
        return true;
    }

    public boolean recordStruct() {
        if (this.hasAnySingletonTypeTags() || this.currentInfo.isInterface() || this.currentInfo.makesDicts() || this.currentInfo.makesStructs() || this.currentInfo.makesUnrestricted()) {
            return false;
        }
        this.currentInfo.setStruct();
        this.populated = true;
        return true;
    }

    public boolean recordDict() {
        if (this.hasAnySingletonTypeTags() || this.currentInfo.isInterface() || this.currentInfo.makesDicts() || this.currentInfo.makesStructs() || this.currentInfo.makesUnrestricted()) {
            return false;
        }
        this.currentInfo.setDict();
        this.populated = true;
        return true;
    }

    public boolean recordJavaDispatch() {
        if (!this.currentInfo.isJavaDispatch()) {
            this.currentInfo.setJavaDispatch(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isJavaDispatch() {
        return this.currentInfo.isJavaDispatch();
    }

    public boolean recordPreserveTry() {
        if (!this.currentInfo.shouldPreserveTry()) {
            this.currentInfo.setShouldPreserveTry(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordOverride() {
        if (!this.currentInfo.isOverride()) {
            this.currentInfo.setOverride(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordNoAlias() {
        if (!this.currentInfo.isNoAlias()) {
            this.currentInfo.setNoAlias(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordDeprecated() {
        if (!this.currentInfo.isDeprecated()) {
            this.currentInfo.setDeprecated(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordInterface() {
        if (this.hasAnySingletonTypeTags() || this.currentInfo.makesStructs() || this.currentInfo.makesDicts() || this.currentInfo.isConstructor() || this.currentInfo.isInterface()) {
            return false;
        }
        this.currentInfo.setInterface(true);
        this.populated = true;
        return true;
    }

    public boolean recordExport() {
        if (!this.currentInfo.isExport()) {
            this.currentInfo.setExport(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordExpose() {
        if (!this.currentInfo.isExpose()) {
            this.currentInfo.setExpose(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordNoShadow() {
        if (!this.currentInfo.isNoShadow()) {
            this.currentInfo.setNoShadow(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordImplicitCast() {
        if (!this.currentInfo.isImplicitCast()) {
            this.currentInfo.setImplicitCast(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordNoSideEffects() {
        if (!this.hasAnySingletonSideEffectTags() && !this.currentInfo.isNoSideEffects()) {
            this.currentInfo.setNoSideEffects(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordExterns() {
        if (!this.currentInfo.isExterns()) {
            this.currentInfo.setExterns(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isInterfaceRecorded() {
        return this.currentInfo.isInterface();
    }

    public boolean hasParameter(String name) {
        return this.currentInfo.hasParameter(name);
    }

    public boolean recordImplementedInterface(JSTypeExpression interfaceName) {
        if (this.currentInfo.addImplementedInterface(interfaceName)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordExtendedInterface(JSTypeExpression interfaceType) {
        if (this.currentInfo.addExtendedInterface(interfaceType)) {
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean recordLends(String name) {
        if (!this.hasAnyTypeRelatedTags()) {
            this.currentInfo.setLendsName(name);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isNgInjectRecorded() {
        return this.currentInfo.isNgInject();
    }

    public boolean recordNgInject(boolean ngInject) {
        if (!this.isNgInjectRecorded()) {
            this.currentInfo.setNgInject(ngInject);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isJaggerInjectRecorded() {
        return this.currentInfo.isJaggerInject();
    }

    public boolean recordJaggerInject(boolean inject) {
        if (!this.isJaggerInjectRecorded()) {
            this.currentInfo.setJaggerInject(inject);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isJaggerModuleRecorded() {
        return this.currentInfo.isJaggerModule();
    }

    public boolean recordJaggerModule(boolean jaggerModule) {
        if (!this.isJaggerModuleRecorded()) {
            this.currentInfo.setJaggerModule(jaggerModule);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isJaggerProvideRecorded() {
        return this.currentInfo.isJaggerProvide();
    }

    public boolean recordJaggerProvide(boolean jaggerProvide) {
        if (!this.isJaggerProvideRecorded()) {
            this.currentInfo.setJaggerProvide(jaggerProvide);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isJaggerProvidePromiseRecorded() {
        return this.currentInfo.isJaggerProvidePromise();
    }

    public boolean recordJaggerProvidePromise(boolean jaggerPromise) {
        if (!this.isJaggerProvidePromiseRecorded()) {
            this.currentInfo.setJaggerProvidePromise(jaggerPromise);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isWizactionRecorded() {
        return this.currentInfo.isWizaction();
    }

    public boolean recordWizaction() {
        if (!this.isWizactionRecorded()) {
            this.currentInfo.setWizaction(true);
            this.populated = true;
            return true;
        }
        return false;
    }

    public boolean isDisposesRecorded() {
        return this.currentInfo.isDisposes();
    }

    public boolean recordDisposesParameter(List<String> parameterNames) {
        for (String parameterName : parameterNames) {
            if ((this.currentInfo.hasParameter(parameterName) || parameterName.equals("*")) && this.currentInfo.setDisposedParameter(parameterName)) {
                this.populated = true;
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean hasAnyTypeRelatedTags() {
        return this.currentInfo.isConstructor() || this.currentInfo.isInterface() || this.currentInfo.getParameterCount() > 0 || this.currentInfo.hasReturnType() || this.currentInfo.hasBaseType() || this.currentInfo.getExtendedInterfacesCount() > 0 || this.currentInfo.getLendsName() != null || this.currentInfo.hasThisType() || this.hasAnySingletonTypeTags();
    }

    private boolean hasAnySingletonTypeTags() {
        return this.currentInfo.hasType() || this.currentInfo.hasTypedefType() || this.currentInfo.hasEnumParameterType();
    }

    private boolean hasAnySingletonSideEffectTags() {
        return this.currentInfo.isNoSideEffects() || this.currentInfo.hasModifies();
    }
}

