/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.fuzzing.Scope;
import com.google.javascript.jscomp.fuzzing.Symbol;
import com.google.javascript.jscomp.fuzzing.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Random;

class ScopeManager {
    private ArrayDeque<Scope> scopeStack = new ArrayDeque();
    private Random random;
    private int numSym;
    static final int EXCLUDE_LOCALS = 1;
    static final int EXCLUDE_EXTERNS = 2;

    public ScopeManager(Random random) {
        this.random = random;
        Scope externs = new Scope();
        externs.symbols = Lists.newArrayList((Object[])new Symbol[]{new Symbol("Array", Type.FUNCTION), new Symbol("Boolean", Type.FUNCTION), new Symbol("Function", Type.FUNCTION), new Symbol("Object", Type.FUNCTION), new Symbol("String", Type.FUNCTION), new Symbol("Error", Type.FUNCTION), new Symbol("JSON", Type.OBJECT), new Symbol("Math", Type.OBJECT), new Symbol("Number", Type.FUNCTION), new Symbol("isFinite", Type.FUNCTION), new Symbol("parseFloat", Type.FUNCTION), new Symbol("parseInt", Type.FUNCTION), new Symbol("decodeURI", Type.FUNCTION), new Symbol("decodeURIComponent", Type.FUNCTION), new Symbol("encodeURI", Type.FUNCTION), new Symbol("encodeURIComponent", Type.FUNCTION), new Symbol("isNaN", Type.FUNCTION)});
        this.scopeStack.push(externs);
        this.scopeStack.push(new Scope());
        this.numSym = 0;
    }

    public void addScope() {
        Scope newScope = new Scope();
        newScope.symbols = Lists.newArrayList((Object[])new Symbol[]{new Symbol("arguments", Type.ARRAY)});
        ++this.numSym;
        this.scopeStack.push(newScope);
    }

    public void removeScope() {
        this.numSym -= this.localSymbols().size();
        this.scopeStack.pop();
    }

    public void addSymbol(Symbol symbol) {
        this.localSymbols().add(symbol);
        ++this.numSym;
    }

    public void removeSymbol(String symbolName) {
        Symbol symbol = this.searchLocalFor(symbolName);
        if (symbol != null && this.localSymbols().remove(symbol)) {
            --this.numSym;
        }
    }

    private Symbol searchLocalFor(String symbolName) {
        Symbol symbol = null;
        for (Symbol s : this.localSymbols()) {
            if (!s.name.equals(symbolName)) continue;
            symbol = s;
            break;
        }
        return symbol;
    }

    private ArrayList<Symbol> localSymbols() {
        return this.scopeStack.peek().symbols;
    }

    public Scope localScope() {
        return this.scopeStack.peek();
    }

    public int getSize() {
        return this.numSym;
    }

    public boolean isInFunction() {
        return this.scopeStack.size() > 2;
    }

    public boolean hasNonLocals() {
        return this.numSym - this.localSymbols().size() > 0;
    }

    public Symbol getRandomSymbol(int flags) {
        return this.getRandomSymbol(null, flags);
    }

    public Symbol getRandomSymbol(Type type, int flags) {
        boolean excludeExterns;
        boolean excludeLocals;
        int minScopes = 1;
        boolean bl = excludeLocals = (flags & 1) != 0;
        if (excludeLocals) {
            ++minScopes;
        }
        boolean bl2 = excludeExterns = (flags & 2) != 0;
        if (excludeExterns) {
            ++minScopes;
        }
        Preconditions.checkArgument((this.scopeStack.size() >= minScopes ? 1 : 0) != 0);
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        ArrayList<Scope> scopes = new ArrayList<Scope>(this.scopeStack);
        int start = excludeLocals ? 1 : 0;
        int end = excludeExterns ? scopes.size() - 1 : scopes.size();
        for (int i = start; i < end; ++i) {
            Scope scope = scopes.get(i);
            for (Symbol s : scope.symbols) {
                if (type != null && s.type != type) continue;
                symbols.add(s);
            }
        }
        int numCandidates = symbols.size();
        if (numCandidates == 0) {
            return null;
        }
        Symbol sym = (Symbol)symbols.get(this.random.nextInt(numCandidates));
        if (excludeLocals && this.searchLocalFor(sym.name) != null) {
            return null;
        }
        return sym;
    }
}

