/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.HashSet;

class StrictModeCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType USE_OF_WITH = DiagnosticType.warning("JSC_USE_OF_WITH", "The 'with' statement cannot be used in ES5 strict mode.");
    static final DiagnosticType UNKNOWN_VARIABLE = DiagnosticType.warning("JSC_UNKNOWN_VARIABLE", "unknown variable {0}");
    static final DiagnosticType EVAL_DECLARATION = DiagnosticType.warning("JSC_EVAL_DECLARATION", "\"eval\" cannot be redeclared in ES5 strict mode");
    static final DiagnosticType EVAL_ASSIGNMENT = DiagnosticType.warning("JSC_EVAL_ASSIGNMENT", "the \"eval\" object cannot be reassigned in ES5 strict mode");
    static final DiagnosticType ARGUMENTS_DECLARATION = DiagnosticType.warning("JSC_ARGUMENTS_DECLARATION", "\"arguments\" cannot be redeclared in ES5 strict mode");
    static final DiagnosticType ARGUMENTS_ASSIGNMENT = DiagnosticType.warning("JSC_ARGUMENTS_ASSIGNMENT", "the \"arguments\" object cannot be reassigned in ES5 strict mode");
    static final DiagnosticType ARGUMENTS_CALLEE_FORBIDDEN = DiagnosticType.warning("JSC_ARGUMENTS_CALLEE_FORBIDDEN", "\"arguments.callee\" cannot be used in ES5 strict mode");
    static final DiagnosticType ARGUMENTS_CALLER_FORBIDDEN = DiagnosticType.warning("JSC_ARGUMENTS_CALLER_FORBIDDEN", "\"arguments.caller\" cannot be used in ES5 strict mode");
    static final DiagnosticType FUNCTION_CALLER_FORBIDDEN = DiagnosticType.warning("JSC_FUNCTION_CALLER_FORBIDDEN", "A function''s \"caller\" property cannot be used in ES5 strict mode");
    static final DiagnosticType FUNCTION_ARGUMENTS_PROP_FORBIDDEN = DiagnosticType.warning("JSC_FUNCTION_ARGUMENTS_PROP_FORBIDDEN", "A function''s \"arguments\" property cannot be used in ES5 strict mode");
    static final DiagnosticType DELETE_VARIABLE = DiagnosticType.warning("JSC_DELETE_VARIABLE", "variables, functions, and arguments cannot be deleted in ES5 strict mode");
    static final DiagnosticType DUPLICATE_OBJECT_KEY = DiagnosticType.warning("JSC_DUPLICATE_OBJECT_KEY", "object literals cannot contain duplicate keys in ES5 strict mode");
    static final DiagnosticType BAD_FUNCTION_DECLARATION = DiagnosticType.error("JSC_BAD_FUNCTION_DECLARATION", "functions can only be declared at top level or immediately within another function in ES5 strict mode");
    private final AbstractCompiler compiler;
    private final boolean noVarCheck;

    StrictModeCheck(AbstractCompiler compiler) {
        this(compiler, false);
    }

    StrictModeCheck(AbstractCompiler compiler, boolean noVarCheck) {
        this.compiler = compiler;
        this.noVarCheck = noVarCheck;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, Lists.newArrayList((Object[])new Node[]{externs, root}), this);
        NodeTraversal.traverse(this.compiler, root, new NonExternChecks());
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isFunction()) {
            StrictModeCheck.checkFunctionUse(t, n);
        } else if (n.isName()) {
            if (!StrictModeCheck.isDeclaration(n)) {
                this.checkNameUse(t, n);
            }
        } else if (n.isAssign()) {
            StrictModeCheck.checkAssignment(t, n);
        } else if (n.isDelProp()) {
            StrictModeCheck.checkDelete(t, n);
        } else if (n.isObjectLit()) {
            StrictModeCheck.checkObjectLiteral(t, n);
        } else if (n.isWith()) {
            StrictModeCheck.checkWith(t, n);
        }
    }

    private static void checkWith(NodeTraversal t, Node n) {
        boolean allowWith;
        JSDocInfo info = n.getJSDocInfo();
        boolean bl = allowWith = info != null && info.getSuppressions().contains("with");
        if (!allowWith) {
            t.report(n, USE_OF_WITH, new String[0]);
        }
    }

    private static void checkFunctionUse(NodeTraversal t, Node n) {
        if (NodeUtil.isFunctionDeclaration(n) && !NodeUtil.isHoistedFunctionDeclaration(n)) {
            t.report(n, BAD_FUNCTION_DECLARATION, new String[0]);
        }
    }

    private static boolean isDeclaration(Node n) {
        switch (n.getParent().getType()) {
            case 105: 
            case 118: 
            case 120: {
                return true;
            }
            case 83: {
                return n.getParent().getParent().isFunction();
            }
        }
        return false;
    }

    private void checkNameUse(NodeTraversal t, Node n) {
        Scope.Var v = t.getScope().getVar(n.getString());
        if (v == null && !this.noVarCheck) {
            t.report(n, UNKNOWN_VARIABLE, n.getString());
        }
    }

    private static void checkAssignment(NodeTraversal t, Node n) {
        if (n.getFirstChild().isName()) {
            if ("arguments".equals(n.getFirstChild().getString())) {
                t.report(n, ARGUMENTS_ASSIGNMENT, new String[0]);
            } else if ("eval".equals(n.getFirstChild().getString())) {
                t.report(n, EVAL_ASSIGNMENT, new String[0]);
            }
        }
    }

    private static void checkDelete(NodeTraversal t, Node n) {
        Scope.Var v;
        if (n.getFirstChild().isName() && (v = t.getScope().getVar(n.getFirstChild().getString())) != null) {
            t.report(n, DELETE_VARIABLE, new String[0]);
        }
    }

    private static void checkObjectLiteral(NodeTraversal t, Node n) {
        HashSet getters = Sets.newHashSet();
        HashSet setters = Sets.newHashSet();
        for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
            if (!key.isSetterDef()) {
                if (getters.contains(key.getString())) {
                    t.report(key, DUPLICATE_OBJECT_KEY, new String[0]);
                } else {
                    getters.add(key.getString());
                }
            }
            if (key.isGetterDef()) continue;
            if (setters.contains(key.getString())) {
                t.report(key, DUPLICATE_OBJECT_KEY, new String[0]);
                continue;
            }
            setters.add(key.getString());
        }
    }

    private static boolean isFunctionType(Node n) {
        JSType type = n.getJSType();
        return type != null && type.isFunctionType();
    }

    private static class NonExternChecks
    extends NodeTraversal.AbstractPostOrderCallback {
        private NonExternChecks() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName() && StrictModeCheck.isDeclaration(n)) {
                this.checkDeclaration(t, n);
            } else if (n.isGetProp()) {
                this.checkGetProp(t, n);
            }
        }

        private void checkDeclaration(NodeTraversal t, Node n) {
            if ("eval".equals(n.getString())) {
                t.report(n, EVAL_DECLARATION, new String[0]);
            } else if ("arguments".equals(n.getString())) {
                t.report(n, ARGUMENTS_DECLARATION, new String[0]);
            }
        }

        private void checkGetProp(NodeTraversal t, Node n) {
            Node target = n.getFirstChild();
            Node prop = n.getLastChild();
            if (prop.getString().equals("callee")) {
                if (target.isName() && target.getString().equals("arguments")) {
                    t.report(n, ARGUMENTS_CALLEE_FORBIDDEN, new String[0]);
                }
            } else if (prop.getString().equals("caller")) {
                if (target.isName() && target.getString().equals("arguments")) {
                    t.report(n, ARGUMENTS_CALLER_FORBIDDEN, new String[0]);
                } else if (StrictModeCheck.isFunctionType(target)) {
                    t.report(n, FUNCTION_CALLER_FORBIDDEN, new String[0]);
                }
            } else if (prop.getString().equals("arguments") && StrictModeCheck.isFunctionType(target)) {
                t.report(n, FUNCTION_ARGUMENTS_PROP_FORBIDDEN, new String[0]);
            }
        }
    }
}

