/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CrossModuleMethodMotion;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.InferJSDocInfo;
import com.google.javascript.jscomp.MemoizedScopeCreator;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeInferencePass;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.graph.GraphvizGraph;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class PassConfig {
    final CompilerOptions options;
    private MemoizedScopeCreator typedScopeCreator;
    private TypedScopeCreator internalScopeCreator;
    Scope topScope = null;

    public PassConfig(CompilerOptions options) {
        this.options = options;
    }

    void regenerateGlobalTypedScope(AbstractCompiler compiler, Node root) {
        this.internalScopeCreator = new TypedScopeCreator(compiler);
        this.typedScopeCreator = new MemoizedScopeCreator(this.internalScopeCreator);
        this.topScope = this.typedScopeCreator.createScope(root, null);
    }

    void clearTypedScope() {
        this.internalScopeCreator = null;
        this.typedScopeCreator = null;
        this.topScope = null;
    }

    void patchGlobalTypedScope(AbstractCompiler compiler, Node scriptRoot) {
        Preconditions.checkNotNull((Object)this.internalScopeCreator);
        this.internalScopeCreator.patchGlobalScope(this.topScope, scriptRoot);
    }

    MemoizedScopeCreator getTypedScopeCreator() {
        return this.typedScopeCreator;
    }

    Scope getTopScope() {
        return this.topScope;
    }

    protected abstract List<PassFactory> getChecks();

    protected abstract List<PassFactory> getOptimizations();

    GraphvizGraph getPassGraph() {
        LinkedDirectedGraph<String, String> graph = LinkedDirectedGraph.createWithoutAnnotations();
        Iterable allPasses = Iterables.concat(this.getChecks(), this.getOptimizations());
        String lastPass = null;
        String loopStart = null;
        for (PassFactory pass : allPasses) {
            String passName = pass.getName();
            int i = 1;
            while (graph.hasNode(passName)) {
                passName = pass.getName() + i++;
            }
            graph.createNode(passName);
            if (loopStart == null && !pass.isOneTimePass()) {
                loopStart = passName;
            } else if (loopStart != null && pass.isOneTimePass()) {
                graph.connect(lastPass, "loop", loopStart);
                loopStart = null;
            }
            if (lastPass != null) {
                graph.connect(lastPass, "", passName);
            }
            lastPass = passName;
        }
        return graph;
    }

    final TypeInferencePass makeTypeInference(AbstractCompiler compiler) {
        return new TypeInferencePass(compiler, compiler.getReverseAbstractInterpreter(), this.topScope, this.typedScopeCreator);
    }

    static final InferJSDocInfo makeInferJsDocInfo(AbstractCompiler compiler) {
        return new InferJSDocInfo(compiler);
    }

    final TypeCheck makeTypeCheck(AbstractCompiler compiler) {
        return new TypeCheck(compiler, compiler.getReverseAbstractInterpreter(), compiler.getTypeRegistry(), this.topScope, this.typedScopeCreator, this.options.reportMissingOverride).reportMissingProperties(this.options.enables(DiagnosticGroup.forType(TypeCheck.INEXISTENT_PROPERTY)));
    }

    static final void addPassFactoryBefore(List<PassFactory> factoryList, PassFactory factory, String passName) {
        factoryList.add(PassConfig.findPassIndexByName(factoryList, passName), factory);
    }

    static final void replacePassFactory(List<PassFactory> factoryList, PassFactory factory) {
        factoryList.set(PassConfig.findPassIndexByName(factoryList, factory.getName()), factory);
    }

    private static int findPassIndexByName(List<PassFactory> factoryList, String name) {
        for (int i = 0; i < factoryList.size(); ++i) {
            if (!factoryList.get(i).getName().equals(name)) continue;
            return i;
        }
        throw new IllegalArgumentException("No factory named '" + name + "' in the factory list");
    }

    final PassConfig getBasePassConfig() {
        PassConfig current = this;
        while (current instanceof PassConfigDelegate) {
            current = ((PassConfigDelegate)current).delegate;
        }
        return current;
    }

    protected abstract State getIntermediateState();

    protected abstract void setIntermediateState(State var1);

    public static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Map<String, Integer> cssNames;
        final Set<String> exportedNames;
        final CrossModuleMethodMotion.IdGenerator crossModuleIdGenerator;
        final VariableMap variableMap;
        final VariableMap propertyMap;
        final VariableMap anonymousFunctionNameMap;
        final VariableMap stringMap;
        final FunctionNames functionNames;
        final String idGeneratorMap;

        public State(Map<String, Integer> cssNames, Set<String> exportedNames, CrossModuleMethodMotion.IdGenerator crossModuleIdGenerator, VariableMap variableMap, VariableMap propertyMap, VariableMap anonymousFunctionNameMap, VariableMap stringMap, FunctionNames functionNames, String idGeneratorMap) {
            this.cssNames = cssNames;
            this.exportedNames = exportedNames;
            this.crossModuleIdGenerator = crossModuleIdGenerator;
            this.variableMap = variableMap;
            this.propertyMap = propertyMap;
            this.anonymousFunctionNameMap = anonymousFunctionNameMap;
            this.stringMap = stringMap;
            this.idGeneratorMap = idGeneratorMap;
            this.functionNames = functionNames;
        }
    }

    static class PassConfigDelegate
    extends PassConfig {
        private final PassConfig delegate;

        PassConfigDelegate(PassConfig delegate) {
            super(delegate.options);
            this.delegate = delegate;
        }

        @Override
        protected List<PassFactory> getChecks() {
            return this.delegate.getChecks();
        }

        @Override
        protected List<PassFactory> getOptimizations() {
            return this.delegate.getOptimizations();
        }

        @Override
        MemoizedScopeCreator getTypedScopeCreator() {
            return this.delegate.getTypedScopeCreator();
        }

        @Override
        Scope getTopScope() {
            return this.delegate.getTopScope();
        }

        @Override
        protected State getIntermediateState() {
            return this.delegate.getIntermediateState();
        }

        @Override
        protected void setIntermediateState(State state) {
            this.delegate.setIntermediateState(state);
        }
    }
}

