/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.GraphNode;

public class GraphReachability<N, E>
implements FixedPointGraphTraversal.EdgeCallback<N, E> {
    private final DiGraph<N, E> graph;
    private final Predicate<EdgeTuple<N, E>> edgePredicate;
    public static final Annotation REACHABLE = new Annotation(){};

    public GraphReachability(DiGraph<N, E> diGraph) {
        this(diGraph, null);
    }

    public GraphReachability(DiGraph<N, E> diGraph, Predicate<EdgeTuple<N, E>> predicate) {
        this.graph = diGraph;
        this.edgePredicate = predicate;
    }

    public void compute(N n) {
        this.graph.clearNodeAnnotations();
        this.graph.getNode(n).setAnnotation(REACHABLE);
        FixedPointGraphTraversal.newTraversal(this).computeFixedPoint(this.graph, n);
    }

    public void recompute(N n) {
        GraphNode graphNode = this.graph.getNode(n);
        Preconditions.checkState((graphNode.getAnnotation() != REACHABLE ? 1 : 0) != 0);
        graphNode.setAnnotation(REACHABLE);
        FixedPointGraphTraversal.newTraversal(this).computeFixedPoint(this.graph, n);
    }

    @Override
    public boolean traverseEdge(N n, E e, N n2) {
        GraphNode graphNode;
        if (this.graph.getNode(n).getAnnotation() == REACHABLE && (this.edgePredicate == null || this.edgePredicate.apply(new EdgeTuple<N, E>(n, e, n2))) && (graphNode = this.graph.getNode(n2)).getAnnotation() != REACHABLE) {
            graphNode.setAnnotation(REACHABLE);
            return true;
        }
        return false;
    }

    public static final class EdgeTuple<N, E> {
        public final N sourceNode;
        public final E edge;
        public final N destNode;

        public EdgeTuple(N n, E e, N n2) {
            this.sourceNode = n;
            this.edge = e;
            this.destNode = n2;
        }
    }
}

