/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;

public class FindExportableNodes
extends NodeTraversal.AbstractPostOrderCallback {
    static final DiagnosticType NON_GLOBAL_ERROR = DiagnosticType.error("JSC_NON_GLOBAL_ERROR", "@export only applies to symbols/properties defined in the global scope.");
    private final LinkedHashMap<String, GenerateNodeContext> exports;
    private final AbstractCompiler compiler;

    public FindExportableNodes(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.exports = Maps.newLinkedHashMap();
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        JSDocInfo jSDocInfo = node.getJSDocInfo();
        if (jSDocInfo != null && jSDocInfo.isExport()) {
            String string = null;
            GenerateNodeContext generateNodeContext = null;
            switch (node.getType()) {
                case 105: {
                    if (node2.getType() != 132) break;
                    string = NodeUtil.getFunctionName(node);
                    generateNodeContext = new GenerateNodeContext(node, node2, node);
                    break;
                }
                case 86: {
                    Node node3 = node2.getParent();
                    if (node3 == null || node3.getType() != 132 || node2.getType() != 130 || node.getLastChild().getType() == 86) break;
                    string = node.getFirstChild().getQualifiedName();
                    generateNodeContext = new GenerateNodeContext(node, node3, node2);
                    break;
                }
                case 118: {
                    if (node2.getType() != 132 || !node.getFirstChild().hasChildren() || node.getFirstChild().getFirstChild().getType() == 86) break;
                    string = node.getFirstChild().getString();
                    generateNodeContext = new GenerateNodeContext(node, node2, node);
                }
            }
            if (string != null) {
                this.exports.put(string, generateNodeContext);
            } else {
                this.compiler.report(nodeTraversal.makeError(node, NON_GLOBAL_ERROR, new String[0]));
            }
        }
    }

    public LinkedHashMap<String, GenerateNodeContext> getExports() {
        return this.exports;
    }

    public static class GenerateNodeContext {
        private final Node scriptNode;
        private final Node contextNode;
        private final Node node;

        public GenerateNodeContext(Node node, Node node2, Node node3) {
            this.node = node;
            this.scriptNode = node2;
            this.contextNode = node3;
        }

        public Node getNode() {
            return this.node;
        }

        public Node getScriptNode() {
            return this.scriptNode;
        }

        public Node getContextNode() {
            return this.contextNode;
        }
    }
}

