/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariableMap {
    private final Map<String, String> map;
    private Map<String, String> reverseMap = null;
    private static final char SEPARATOR = ':';

    VariableMap(Map<String, String> map) {
        this.map = Collections.unmodifiableMap(map);
    }

    public String lookupNewName(String string) {
        return this.map.get(string);
    }

    public String lookupSourceName(String string) {
        if (this.reverseMap == null) {
            this.initReverseMap();
        }
        return this.reverseMap.get(string);
    }

    private synchronized void initReverseMap() {
        if (this.reverseMap == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                hashMap.put(entry.getValue(), entry.getKey());
            }
            this.reverseMap = Collections.unmodifiableMap(hashMap);
        }
    }

    public Map<String, String> getOriginalNameToNewNameMap() {
        return this.map;
    }

    public Map<String, String> getNewNameToOriginalNameMap() {
        if (this.reverseMap == null) {
            this.initReverseMap();
        }
        return this.reverseMap;
    }

    public void save(String string) throws IOException {
        Files.write((byte[])this.toBytes(), (File)new File(string));
    }

    public static VariableMap load(String string) throws IOException {
        try {
            return VariableMap.fromBytes(Files.toByteArray((File)new File(string)));
        }
        catch (ParseException parseException) {
            throw new IOException(parseException);
        }
    }

    public byte[] toBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, Charsets.UTF_8);
        try {
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                outputStreamWriter.write(entry.getKey());
                ((Writer)outputStreamWriter).write(58);
                outputStreamWriter.write(entry.getValue());
                ((Writer)outputStreamWriter).write(10);
            }
            ((Writer)outputStreamWriter).close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static VariableMap fromBytes(byte[] byArray) throws ParseException {
        List list;
        try {
            list = CharStreams.readLines((InputSupplier)CharStreams.newReaderSupplier((InputSupplier)ByteStreams.newInputStreamSupplier((byte[])byArray), (Charset)Charsets.UTF_8));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : list) {
            int n = string.lastIndexOf(58);
            if (n <= 0 || n == string.length() - 1) {
                throw new ParseException("Bad line: " + string, 0);
            }
            hashMap.put(string.substring(0, n), string.substring(n + 1));
        }
        return new VariableMap(hashMap);
    }

    public static VariableMap fromMap(Map<String, String> map) {
        return new VariableMap(Maps.newHashMap(map));
    }
}

