/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.Visitor;

public final class ParameterizedType
extends ProxyObjectType {
    private static final long serialVersionUID = 1L;
    final JSType parameterType;

    ParameterizedType(JSTypeRegistry registry, ObjectType objectType, JSType parameterType) {
        super(registry, objectType);
        this.parameterType = parameterType;
    }

    @Override
    public JSType getParameterType() {
        return this.parameterType;
    }

    @Override
    String toStringHelper(boolean forAnnotations) {
        String result = super.toStringHelper(forAnnotations);
        return result + ".<" + this.parameterType.toStringHelper(forAnnotations) + ">";
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseParameterizedType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseParameterizedType(this, that);
    }

    @Override
    public ParameterizedType toMaybeParameterizedType() {
        return this;
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        return super.hasAnyTemplateTypes() || this.parameterType.hasAnyTemplateTypes();
    }
}

