/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.GraphvizGraph;
import com.google.javascript.jscomp.graph.SubGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LinkedDirectedGraph<N, E>
extends DiGraph<N, E>
implements GraphvizGraph {
    protected final Map<N, LinkedDirectedGraphNode<N, E>> nodes = Maps.newHashMap();
    private final boolean useNodeAnnotations;
    private final boolean useEdgeAnnotations;

    @Override
    public SubGraph<N, E> newSubGraph() {
        return new Graph.SimpleSubGraph(this);
    }

    public static <N, E> LinkedDirectedGraph<N, E> createWithoutAnnotations() {
        return new LinkedDirectedGraph<N, E>(false, false);
    }

    public static <N, E> LinkedDirectedGraph<N, E> createWithNodeAnnotations() {
        return new LinkedDirectedGraph<N, E>(true, false);
    }

    public static <N, E> LinkedDirectedGraph<N, E> createWithEdgeAnnotations() {
        return new LinkedDirectedGraph<N, E>(false, true);
    }

    public static <N, E> LinkedDirectedGraph<N, E> create() {
        return new LinkedDirectedGraph<N, E>(true, true);
    }

    protected LinkedDirectedGraph(boolean useNodeAnnotations, boolean useEdgeAnnotations) {
        this.useNodeAnnotations = useNodeAnnotations;
        this.useEdgeAnnotations = useEdgeAnnotations;
    }

    @Override
    public void connect(N srcValue, E edgeValue, N destValue) {
        LinkedDirectedGraphNode src = (LinkedDirectedGraphNode)this.getNodeOrFail(srcValue);
        LinkedDirectedGraphNode dest = (LinkedDirectedGraphNode)this.getNodeOrFail(destValue);
        LinkedDirectedGraphEdge edge = this.useEdgeAnnotations ? new AnnotatedLinkedDirectedGraphEdge(src, edgeValue, dest) : new LinkedDirectedGraphEdge(src, edgeValue, dest);
        src.getOutEdges().add(edge);
        dest.getInEdges().add(edge);
    }

    @Override
    public void disconnect(N n1, N n2) {
        this.disconnectInDirection(n1, n2);
        this.disconnectInDirection(n2, n1);
    }

    @Override
    public void disconnectInDirection(N srcValue, N destValue) {
        LinkedDirectedGraphNode src = (LinkedDirectedGraphNode)this.getNodeOrFail(srcValue);
        LinkedDirectedGraphNode dest = (LinkedDirectedGraphNode)this.getNodeOrFail(destValue);
        for (DiGraph.DiGraphEdge<N, E> edge : this.getDirectedGraphEdges(srcValue, destValue)) {
            src.getOutEdges().remove(edge);
            dest.getInEdges().remove(edge);
        }
    }

    @Override
    public Iterable<DiGraph.DiGraphNode<N, E>> getDirectedGraphNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public DiGraph.DiGraphNode<N, E> getDirectedGraphNode(N nodeValue) {
        return this.nodes.get(nodeValue);
    }

    @Override
    public GraphNode<N, E> getNode(N nodeValue) {
        return this.getDirectedGraphNode(nodeValue);
    }

    @Override
    public List<DiGraph.DiGraphEdge<N, E>> getInEdges(N nodeValue) {
        LinkedDirectedGraphNode node = (LinkedDirectedGraphNode)this.getNodeOrFail(nodeValue);
        return Collections.unmodifiableList(node.getInEdges());
    }

    @Override
    public List<DiGraph.DiGraphEdge<N, E>> getOutEdges(N nodeValue) {
        LinkedDirectedGraphNode node = (LinkedDirectedGraphNode)this.getNodeOrFail(nodeValue);
        return Collections.unmodifiableList(node.getOutEdges());
    }

    @Override
    public DiGraph.DiGraphNode<N, E> createDirectedGraphNode(N nodeValue) {
        LinkedDirectedGraphNode<N, E> node = this.nodes.get(nodeValue);
        if (node == null) {
            node = this.useNodeAnnotations ? new AnnotatedLinkedDirectedGraphNode(nodeValue) : new LinkedDirectedGraphNode(nodeValue);
            this.nodes.put(nodeValue, node);
        }
        return node;
    }

    @Override
    public List<Graph.GraphEdge<N, E>> getEdges(N n1, N n2) {
        List<DiGraph.DiGraphEdge<N, E>> forwardEdges = this.getDirectedGraphEdges(n1, n2);
        List<DiGraph.DiGraphEdge<N, E>> backwardEdges = this.getDirectedGraphEdges(n2, n1);
        int totalSize = forwardEdges.size() + backwardEdges.size();
        ArrayList edges = Lists.newArrayListWithCapacity((int)totalSize);
        edges.addAll(forwardEdges);
        edges.addAll(backwardEdges);
        return edges;
    }

    @Override
    public Graph.GraphEdge<N, E> getFirstEdge(N n1, N n2) {
        DiGraph.DiGraphNode dNode1 = (DiGraph.DiGraphNode)this.getNodeOrFail(n1);
        DiGraph.DiGraphNode dNode2 = (DiGraph.DiGraphNode)this.getNodeOrFail(n2);
        for (DiGraph.DiGraphEdge outEdge : dNode1.getOutEdges()) {
            if (outEdge.getDestination() != dNode2) continue;
            return outEdge;
        }
        for (DiGraph.DiGraphEdge outEdge : dNode2.getOutEdges()) {
            if (outEdge.getDestination() != dNode1) continue;
            return outEdge;
        }
        return null;
    }

    @Override
    public GraphNode<N, E> createNode(N value) {
        return this.createDirectedGraphNode(value);
    }

    @Override
    public List<DiGraph.DiGraphEdge<N, E>> getDirectedGraphEdges(N n1, N n2) {
        DiGraph.DiGraphNode dNode1 = (DiGraph.DiGraphNode)this.getNodeOrFail(n1);
        DiGraph.DiGraphNode dNode2 = (DiGraph.DiGraphNode)this.getNodeOrFail(n2);
        ArrayList edges = Lists.newArrayList();
        for (DiGraph.DiGraphEdge outEdge : dNode1.getOutEdges()) {
            if (outEdge.getDestination() != dNode2) continue;
            edges.add(outEdge);
        }
        return edges;
    }

    @Override
    public boolean isConnectedInDirection(N n1, N n2) {
        return this.isConnectedInDirection(n1, Predicates.alwaysTrue(), n2);
    }

    @Override
    public boolean isConnectedInDirection(N n1, E edgeValue, N n2) {
        return this.isConnectedInDirection(n1, Predicates.equalTo(edgeValue), n2);
    }

    @Override
    private boolean isConnectedInDirection(N n1, Predicate<E> edgeMatcher, N n2) {
        DiGraph.DiGraphNode dNode1 = (DiGraph.DiGraphNode)this.getNodeOrFail(n1);
        DiGraph.DiGraphNode dNode2 = (DiGraph.DiGraphNode)this.getNodeOrFail(n2);
        for (DiGraph.DiGraphEdge outEdge : dNode1.getOutEdges()) {
            if (outEdge.getDestination() != dNode2 || !edgeMatcher.apply(outEdge.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<DiGraph.DiGraphNode<N, E>> getDirectedPredNodes(N nodeValue) {
        return this.getDirectedPredNodes(this.nodes.get(nodeValue));
    }

    @Override
    public List<DiGraph.DiGraphNode<N, E>> getDirectedSuccNodes(N nodeValue) {
        return this.getDirectedSuccNodes(this.nodes.get(nodeValue));
    }

    @Override
    public List<DiGraph.DiGraphNode<N, E>> getDirectedPredNodes(DiGraph.DiGraphNode<N, E> dNode) {
        if (dNode == null) {
            throw new IllegalArgumentException(dNode + " is null");
        }
        ArrayList nodeList = Lists.newArrayList();
        for (DiGraph.DiGraphEdge<N, E> edge : dNode.getInEdges()) {
            nodeList.add(edge.getSource());
        }
        return nodeList;
    }

    @Override
    public List<DiGraph.DiGraphNode<N, E>> getDirectedSuccNodes(DiGraph.DiGraphNode<N, E> dNode) {
        if (dNode == null) {
            throw new IllegalArgumentException(dNode + " is null");
        }
        ArrayList nodeList = Lists.newArrayList();
        for (DiGraph.DiGraphEdge<N, E> edge : dNode.getOutEdges()) {
            nodeList.add(edge.getDestination());
        }
        return nodeList;
    }

    @Override
    public List<GraphvizGraph.GraphvizEdge> getGraphvizEdges() {
        ArrayList edgeList = Lists.newArrayList();
        for (LinkedDirectedGraphNode<N, E> node : this.nodes.values()) {
            for (DiGraph.DiGraphEdge<N, E> edge : node.getOutEdges()) {
                edgeList.add((LinkedDirectedGraphEdge)edge);
            }
        }
        return edgeList;
    }

    @Override
    public List<GraphvizGraph.GraphvizNode> getGraphvizNodes() {
        ArrayList nodeList = Lists.newArrayListWithCapacity((int)this.nodes.size());
        for (LinkedDirectedGraphNode<N, E> node : this.nodes.values()) {
            nodeList.add(node);
        }
        return nodeList;
    }

    @Override
    public String getName() {
        return "LinkedGraph";
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public Collection<GraphNode<N, E>> getNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public List<GraphNode<N, E>> getNeighborNodes(N value) {
        DiGraph.DiGraphNode<N, E> node = this.getDirectedGraphNode(value);
        return this.getNeighborNodes(node);
    }

    @Override
    public List<GraphNode<N, E>> getNeighborNodes(DiGraph.DiGraphNode<N, E> node) {
        ArrayList result = Lists.newArrayList();
        Iterator i = ((LinkedDirectedGraphNode)node).neighborIterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    @Override
    public Iterator<GraphNode<N, E>> getNeighborNodesIterator(N value) {
        LinkedDirectedGraphNode<N, E> node = this.nodes.get(value);
        Preconditions.checkNotNull(node);
        return ((LinkedDirectedGraphNode)node).neighborIterator();
    }

    @Override
    public List<Graph.GraphEdge<N, E>> getEdges() {
        ArrayList result = Lists.newArrayList();
        for (DiGraph.DiGraphNode diGraphNode : this.nodes.values()) {
            for (DiGraph.DiGraphEdge edge : diGraphNode.getOutEdges()) {
                result.add(edge);
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public int getNodeDegree(N value) {
        DiGraph.DiGraphNode node = (DiGraph.DiGraphNode)this.getNodeOrFail(value);
        return node.getInEdges().size() + node.getOutEdges().size();
    }

    static class AnnotatedLinkedDirectedGraphEdge<N, E>
    extends LinkedDirectedGraphEdge<N, E> {
        protected Annotation annotation;

        AnnotatedLinkedDirectedGraphEdge(DiGraph.DiGraphNode<N, E> sourceNode, E edgeValue, DiGraph.DiGraphNode<N, E> destNode) {
            super(sourceNode, edgeValue, destNode);
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation data) {
            this.annotation = data;
        }
    }

    static class LinkedDirectedGraphEdge<N, E>
    implements DiGraph.DiGraphEdge<N, E>,
    GraphvizGraph.GraphvizEdge {
        private DiGraph.DiGraphNode<N, E> sourceNode;
        private DiGraph.DiGraphNode<N, E> destNode;
        protected final E value;

        LinkedDirectedGraphEdge(DiGraph.DiGraphNode<N, E> sourceNode, E edgeValue, DiGraph.DiGraphNode<N, E> destNode) {
            this.value = edgeValue;
            this.sourceNode = sourceNode;
            this.destNode = destNode;
        }

        @Override
        public DiGraph.DiGraphNode<N, E> getSource() {
            return this.sourceNode;
        }

        @Override
        public DiGraph.DiGraphNode<N, E> getDestination() {
            return this.destNode;
        }

        @Override
        public void setDestination(DiGraph.DiGraphNode<N, E> node) {
            this.destNode = node;
        }

        @Override
        public void setSource(DiGraph.DiGraphNode<N, E> node) {
            this.sourceNode = node;
        }

        @Override
        public E getValue() {
            return this.value;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            throw new UnsupportedOperationException("Graph initialized with edge annotations turned off");
        }

        @Override
        public void setAnnotation(Annotation data) {
            throw new UnsupportedOperationException("Graph initialized with edge annotations turned off");
        }

        @Override
        public String getColor() {
            return "black";
        }

        @Override
        public String getLabel() {
            return this.value != null ? this.value.toString() : "null";
        }

        @Override
        public String getNode1Id() {
            return ((LinkedDirectedGraphNode)this.sourceNode).getId();
        }

        @Override
        public String getNode2Id() {
            return ((LinkedDirectedGraphNode)this.destNode).getId();
        }

        public String toString() {
            return this.sourceNode.toString() + " -> " + this.destNode.toString();
        }

        @Override
        public GraphNode<N, E> getNodeA() {
            return this.sourceNode;
        }

        @Override
        public GraphNode<N, E> getNodeB() {
            return this.destNode;
        }
    }

    static class AnnotatedLinkedDirectedGraphNode<N, E>
    extends LinkedDirectedGraphNode<N, E> {
        protected Annotation annotation;

        AnnotatedLinkedDirectedGraphNode(N nodeValue) {
            super(nodeValue);
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation data) {
            this.annotation = data;
        }
    }

    static class LinkedDirectedGraphNode<N, E>
    implements DiGraph.DiGraphNode<N, E>,
    GraphvizGraph.GraphvizNode {
        List<DiGraph.DiGraphEdge<N, E>> inEdgeList = Lists.newArrayList();
        List<DiGraph.DiGraphEdge<N, E>> outEdgeList = Lists.newArrayList();
        protected final N value;

        LinkedDirectedGraphNode(N nodeValue) {
            this.value = nodeValue;
        }

        @Override
        public N getValue() {
            return this.value;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            throw new UnsupportedOperationException("Graph initialized with node annotations turned off");
        }

        @Override
        public void setAnnotation(Annotation data) {
            throw new UnsupportedOperationException("Graph initialized with node annotations turned off");
        }

        @Override
        public String getColor() {
            return "white";
        }

        @Override
        public String getId() {
            return "LDN" + this.hashCode();
        }

        @Override
        public String getLabel() {
            return this.value != null ? this.value.toString() : "null";
        }

        public String toString() {
            return this.getLabel();
        }

        @Override
        public List<DiGraph.DiGraphEdge<N, E>> getInEdges() {
            return this.inEdgeList;
        }

        @Override
        public List<DiGraph.DiGraphEdge<N, E>> getOutEdges() {
            return this.outEdgeList;
        }

        private Iterator<GraphNode<N, E>> neighborIterator() {
            return new NeighborIterator();
        }

        private class NeighborIterator
        implements Iterator<GraphNode<N, E>> {
            private final Iterator<DiGraph.DiGraphEdge<N, E>> in;
            private final Iterator<DiGraph.DiGraphEdge<N, E>> out;

            private NeighborIterator() {
                this.in = LinkedDirectedGraphNode.this.inEdgeList.iterator();
                this.out = LinkedDirectedGraphNode.this.outEdgeList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.in.hasNext() || this.out.hasNext();
            }

            @Override
            public GraphNode<N, E> next() {
                boolean isOut = !this.in.hasNext();
                Iterator curIterator = isOut ? this.out : this.in;
                DiGraph.DiGraphEdge s = curIterator.next();
                return isOut ? s.getDestination() : s.getSource();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported.");
            }
        }
    }
}

