/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.Visitor;

public final class ParameterizedType
extends ProxyObjectType {
    private static final long serialVersionUID = 1L;
    final JSType parameterType;

    ParameterizedType(JSTypeRegistry registry, ObjectType objectType, JSType parameterType) {
        super(registry, objectType);
        this.parameterType = parameterType;
    }

    @Override
    public JSType getParameterType() {
        return this.parameterType;
    }

    @Override
    public boolean isEquivalentTo(JSType that) {
        return super.isEquivalentTo(that) && JSType.isEquivalent(this.parameterType, that.toObjectType().getParameterType());
    }

    @Override
    String toStringHelper(boolean forAnnotations) {
        String result = super.toStringHelper(forAnnotations);
        return result + ".<" + this.parameterType.toStringHelper(forAnnotations) + ">";
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseParameterizedType(this);
    }

    @Override
    public ParameterizedType toMaybeParameterizedType() {
        return this;
    }

    @Override
    public boolean hasAnyTemplateInternal() {
        return super.hasAnyTemplate() || this.parameterType.hasAnyTemplate();
    }
}

