/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.head.ast;

import com.google.javascript.rhino.head.ast.AstNode;
import com.google.javascript.rhino.head.ast.Block;
import com.google.javascript.rhino.head.ast.Loop;
import com.google.javascript.rhino.head.ast.NodeVisitor;

public class WhileLoop
extends Loop {
    private AstNode condition;

    public WhileLoop() {
        this.type = 117;
    }

    public WhileLoop(int pos) {
        super(pos);
        this.type = 117;
    }

    public WhileLoop(int pos, int len) {
        super(pos, len);
        this.type = 117;
    }

    public AstNode getCondition() {
        return this.condition;
    }

    public void setCondition(AstNode condition) {
        this.assertNotNull(condition);
        this.condition = condition;
        condition.setParent(this);
    }

    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth));
        sb.append("while (");
        sb.append(this.condition.toSource(0));
        sb.append(") ");
        if (this.body instanceof Block) {
            sb.append(this.body.toSource(depth).trim());
            sb.append("\n");
        } else {
            sb.append("\n").append(this.body.toSource(depth + 1));
        }
        return sb.toString();
    }

    public void visit(NodeVisitor v) {
        if (v.visit(this)) {
            this.condition.visit(v);
            this.body.visit(v);
        }
    }
}

