/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared.impl;

import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.ValueProxy;
import com.google.web.bindery.requestfactory.shared.impl.IdUtil;
import com.google.web.bindery.requestfactory.shared.impl.SimpleEntityProxyId;
import com.google.web.bindery.requestfactory.shared.impl.SimpleProxyId;
import java.util.HashMap;
import java.util.Map;

public abstract class IdFactory {
    private final Map<String, SimpleProxyId<?>> ephemeralIds = new HashMap();

    public <P extends BaseProxy> SimpleProxyId<P> allocateId(Class<P> clazz) {
        SimpleProxyId<P> toReturn = this.createId(clazz, this.ephemeralIds.size() + 1);
        this.ephemeralIds.put(this.getHistoryToken(toReturn), toReturn);
        return toReturn;
    }

    public <P extends BaseProxy> SimpleProxyId<P> allocateSyntheticId(Class<P> clazz, int syntheticId) {
        assert (syntheticId > 0);
        SimpleProxyId<P> toReturn = this.createId(clazz, new StringBuilder(12).append("%").append(syntheticId).toString());
        toReturn.setSyntheticId(syntheticId);
        return toReturn;
    }

    public <P extends EntityProxy> Class<P> asEntityProxy(Class<? extends BaseProxy> clazz) {
        assert (this.isEntityType(clazz)) : String.valueOf(clazz.getName()).concat(" is not an EntityProxy type");
        return clazz;
    }

    public <P extends ValueProxy> Class<P> asValueProxy(Class<? extends BaseProxy> clazz) {
        assert (this.isValueType(clazz)) : String.valueOf(clazz.getName()).concat(" is not a ValueProxy type");
        return clazz;
    }

    public <P extends BaseProxy> SimpleProxyId<P> getBaseProxyId(String historyToken) {
        assert (!IdUtil.isSynthetic(historyToken)) : "Synthetic id resolution should be handled by AbstractRequestContext";
        if (IdUtil.isPersisted(historyToken)) {
            return this.getId(IdUtil.getTypeToken(historyToken), IdUtil.getServerId(historyToken));
        }
        if (IdUtil.isEphemeral(historyToken)) {
            SimpleProxyId<Object> toReturn = this.ephemeralIds.get(historyToken);
            if (toReturn == null) {
                Class<P> clazz = this.checkTypeToken(IdUtil.getTypeToken(historyToken));
                toReturn = this.createId(clazz, -1 * this.ephemeralIds.size());
                this.ephemeralIds.put(historyToken, toReturn);
            }
            return toReturn;
        }
        throw new IllegalArgumentException(historyToken);
    }

    public String getHistoryToken(SimpleProxyId<?> proxy) {
        SimpleProxyId<?> id = proxy;
        String token = this.getTypeToken(proxy.getProxyClass());
        if (id.isEphemeral()) {
            return IdUtil.ephemeralId(id.getClientId(), token);
        }
        if (id.isSynthetic()) {
            return IdUtil.syntheticId(id.getSyntheticId(), token);
        }
        return IdUtil.persistedId(id.getServerId(), token);
    }

    public <P extends BaseProxy> SimpleProxyId<P> getId(Class<P> clazz, String serverId, int clientId) {
        return this.getId(this.getTypeToken(clazz), serverId, clientId);
    }

    public <P extends BaseProxy> SimpleProxyId<P> getId(String typeToken, String serverId) {
        return this.getId(typeToken, serverId, 0);
    }

    public <P extends BaseProxy> SimpleProxyId<P> getId(String typeToken, String serverId, int clientId) {
        if (clientId > 0) {
            String ephemeralKey = IdUtil.ephemeralId(clientId, typeToken);
            SimpleProxyId<Object> toReturn = this.ephemeralIds.get(ephemeralKey);
            if (toReturn == null) {
                Class<P> clazz = this.getTypeFromToken(typeToken);
                toReturn = this.createId(clazz, clientId);
                this.ephemeralIds.put(ephemeralKey, toReturn);
            }
            if (toReturn.isEphemeral()) {
                assert (toReturn.getProxyClass().equals(this.getTypeFromToken(typeToken)));
                if (serverId != null) {
                    toReturn.setServerId(serverId);
                    String serverKey = IdUtil.persistedId(serverId, typeToken);
                    this.ephemeralIds.put(serverKey, toReturn);
                }
            }
            return toReturn;
        }
        assert (serverId != null) : "serverId";
        String serverKey = IdUtil.persistedId(serverId, typeToken);
        SimpleProxyId<?> toReturn = this.ephemeralIds.get(serverKey);
        if (toReturn != null) {
            return toReturn;
        }
        Class<P> clazz = this.getTypeFromToken(typeToken);
        if (!$assertionsDisabled && clazz == null) {
            String string = String.valueOf(typeToken);
            throw new AssertionError((Object)(string.length() != 0 ? "No class literal for ".concat(string) : new String("No class literal for ")));
        }
        return this.createId(clazz, serverId);
    }

    public abstract boolean isEntityType(Class<?> var1);

    public abstract boolean isValueType(Class<?> var1);

    protected abstract <P extends BaseProxy> Class<P> getTypeFromToken(String var1);

    protected abstract String getTypeToken(Class<? extends BaseProxy> var1);

    private <P> Class<P> checkTypeToken(String token) {
        Class<P> clazz = this.getTypeFromToken(token);
        if (clazz == null) {
            throw new IllegalArgumentException("Unknnown type");
        }
        return clazz;
    }

    private <P extends BaseProxy> SimpleProxyId<P> createId(Class<P> clazz, int clientId) {
        SimpleProxyId<P> toReturn;
        if (this.isValueType(clazz)) {
            toReturn = new SimpleProxyId<P>(clazz, clientId);
        } else {
            SimpleEntityProxyId<P> temp = new SimpleEntityProxyId<P>(this.asEntityProxy(clazz), clientId);
            toReturn = temp;
        }
        return toReturn;
    }

    private <P extends BaseProxy> SimpleProxyId<P> createId(Class<P> clazz, String serverId) {
        SimpleProxyId<P> toReturn;
        if (this.isValueType(clazz)) {
            toReturn = new SimpleProxyId<P>(clazz, serverId);
        } else {
            SimpleEntityProxyId<P> temp = new SimpleEntityProxyId<P>(this.asEntityProxy(clazz), serverId);
            toReturn = temp;
        }
        return toReturn;
    }
}

