/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.apt;

import com.google.web.bindery.requestfactory.apt.DeobfuscatorBuilder;
import com.google.web.bindery.requestfactory.apt.DomainChecker;
import com.google.web.bindery.requestfactory.apt.ExtraTypesScanner;
import com.google.web.bindery.requestfactory.apt.HaltException;
import com.google.web.bindery.requestfactory.apt.Messages;
import com.google.web.bindery.requestfactory.apt.ProxyScanner;
import com.google.web.bindery.requestfactory.apt.RequestContextScanner;
import com.google.web.bindery.requestfactory.apt.RequestFactoryScanner;
import com.google.web.bindery.requestfactory.apt.ScannerBase;
import com.google.web.bindery.requestfactory.apt.TransportableTypeVisitor;
import com.google.web.bindery.requestfactory.shared.SkipInterfaceValidation;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

class State {
    final TypeMirror baseProxyType;
    final Elements elements;
    final DeclaredType entityProxyIdType;
    final DeclaredType entityProxyType;
    final DeclaredType extraTypesAnnotation;
    final Filer filer;
    final DeclaredType instanceRequestType;
    final DeclaredType locatorType;
    final DeclaredType objectType;
    final DeclaredType requestContextType;
    final DeclaredType requestFactoryType;
    final DeclaredType requestType;
    final DeclaredType serviceLocatorType;
    final Set<TypeElement> seen;
    final Types types;
    final DeclaredType valueProxyType;
    private final Map<Element, Element> clientToDomainMain;
    private final SortedSet<Job> jobs = new TreeSet<Job>();
    private final Messager messager;
    private boolean poisoned;
    private boolean requireAllMappings;
    private final boolean suppressErrors;
    private final boolean suppressWarnings;
    private final boolean verbose;
    private final Map<Element, Set<String>> previousMessages = new HashMap<Element, Set<String>>();
    private final Set<TypeElement> typesRequiringMapping = new LinkedHashSet<TypeElement>();
    private boolean clientOnly;

    static TypeMirror viewAs(DeclaredType desiredType, TypeMirror searchFrom, State state) {
        if (!desiredType.getTypeArguments().isEmpty()) {
            String string = String.valueOf(desiredType.toString());
            throw new IllegalArgumentException(string.length() != 0 ? "Expecting raw type, received ".concat(string) : new String("Expecting raw type, received "));
        }
        Element searchElement = state.types.asElement(searchFrom);
        switch (searchElement.getKind()) {
            case CLASS: 
            case INTERFACE: 
            case ENUM: {
                DeclaredType rawSearchFrom = state.types.getDeclaredType((TypeElement)searchElement, new TypeMirror[0]);
                if (state.types.isSameType(desiredType, rawSearchFrom)) {
                    return searchFrom;
                }
                for (TypeMirror typeMirror : state.types.directSupertypes(searchFrom)) {
                    TypeMirror maybe = State.viewAs(desiredType, typeMirror, state);
                    if (maybe == null) continue;
                    return maybe;
                }
                break;
            }
            case TYPE_PARAMETER: {
                return State.viewAs(desiredType, ((TypeVariable)((Object)searchElement)).getUpperBound(), state);
            }
        }
        return null;
    }

    public State(ProcessingEnvironment processingEnv) {
        this.clientToDomainMain = new HashMap<Element, Element>();
        this.elements = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.types = processingEnv.getTypeUtils();
        this.suppressErrors = Boolean.parseBoolean(processingEnv.getOptions().get("suppressErrors"));
        this.suppressWarnings = Boolean.parseBoolean(processingEnv.getOptions().get("suppressWarnings"));
        this.verbose = Boolean.parseBoolean(processingEnv.getOptions().get("verbose"));
        this.baseProxyType = this.findType("BaseProxy");
        this.entityProxyType = this.findType("EntityProxy");
        this.entityProxyIdType = this.findType("EntityProxyId");
        this.extraTypesAnnotation = this.findType("ExtraTypes");
        this.instanceRequestType = this.findType("InstanceRequest");
        this.locatorType = this.findType("Locator");
        this.objectType = this.findType(Object.class);
        this.requestType = this.findType("Request");
        this.requestContextType = this.findType("RequestContext");
        this.requestFactoryType = this.findType("RequestFactory");
        this.seen = new HashSet<TypeElement>();
        this.serviceLocatorType = this.findType("ServiceLocator");
        this.valueProxyType = this.findType("ValueProxy");
    }

    public void addMapping(ExecutableElement clientMethod, ExecutableElement domainMethod) {
        if (domainMethod == null) {
            this.debug(clientMethod, "No domain mapping", new Object[0]);
        } else {
            this.debug(clientMethod, "Found domain method %s", domainMethod.toString());
        }
        this.clientToDomainMain.put(clientMethod, domainMethod);
    }

    public void addMapping(TypeElement clientType, TypeElement domainType) {
        if (domainType == null) {
            this.debug(clientType, "No domain mapping", new Object[0]);
        } else {
            this.debug(clientType, "Found domain type %s", domainType.toString());
        }
        this.clientToDomainMain.put(clientType, domainType);
    }

    public void checkExtraTypes(Element x) {
        new ExtraTypesScanner<Void>(){

            @Override
            public Void visitExecutable(ExecutableElement x, State state) {
                this.checkForAnnotation(x, state);
                return null;
            }

            @Override
            public Void visitType(TypeElement x, State state) {
                this.checkForAnnotation(x, state);
                return null;
            }

            @Override
            protected void scanExtraType(TypeElement extraType) {
                State.this.maybeScanProxy(extraType);
            }
        }.scan(x, this);
    }

    public void debug(Element elt, String message, Object ... args) {
        if (this.verbose) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(message, args), elt);
        }
    }

    public void executeJobs() {
        while (!this.jobs.isEmpty()) {
            Job job = this.jobs.first();
            this.jobs.remove(job);
            this.debug(job.element, "Scanning", new Object[0]);
            try {
                job.scanner.scan((Element)job.element, this);
            }
            catch (HaltException ignored) {
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                this.poison(job.element, sw.toString());
            }
        }
        if (this.clientOnly) {
            return;
        }
        for (TypeElement element : this.typesRequiringMapping) {
            if (this.getClientToDomainMap().containsKey(element)) continue;
            if (this.types.isAssignable(element.asType(), this.requestContextType)) {
                this.poison(element, Messages.contextMustBeAnnotated(element.getSimpleName()));
                continue;
            }
            this.poison(element, Messages.proxyMustBeAnnotated(element.getSimpleName()));
        }
    }

    public DeclaredType findType(Class<?> clazz) {
        return this.types.getDeclaredType(this.elements.getTypeElement(clazz.getCanonicalName()), new TypeMirror[0]);
    }

    public Map<Element, Element> getClientToDomainMap() {
        return Collections.unmodifiableMap(this.clientToDomainMain);
    }

    public boolean isClientOnly() {
        return this.clientOnly;
    }

    public boolean isMappingRequired(TypeElement element) {
        return this.typesRequiringMapping.contains(element);
    }

    public boolean isPoisoned() {
        return this.poisoned;
    }

    public boolean isTransportableType(TypeMirror asType) {
        return asType.accept(new TransportableTypeVisitor(), this);
    }

    public void maybeScanContext(TypeElement requestContext) {
        if (this.fastFail(requestContext) || this.types.isSameType(this.requestContextType, requestContext.asType())) {
            return;
        }
        this.jobs.add(new Job(requestContext, new RequestContextScanner(), 0));
        if (!this.clientOnly) {
            this.jobs.add(new Job(requestContext, new DomainChecker(), 1));
        }
    }

    public void maybeScanFactory(TypeElement factoryType) {
        if (this.fastFail(factoryType) || this.types.isSameType(this.requestFactoryType, factoryType.asType())) {
            return;
        }
        this.jobs.add(new Job(factoryType, new RequestFactoryScanner(), 0));
        this.jobs.add(new Job(factoryType, new DeobfuscatorBuilder(), 2));
    }

    public void maybeScanProxy(TypeElement proxyType) {
        if (this.fastFail(proxyType)) {
            return;
        }
        this.jobs.add(new Job(proxyType, new ProxyScanner(), 0));
        if (!this.clientOnly) {
            this.jobs.add(new Job(proxyType, new DomainChecker(), 1));
        }
    }

    public boolean mustResolveAllAnnotations() {
        return this.requireAllMappings;
    }

    public void poison(Element elt, String message) {
        if (this.suppressErrors) {
            return;
        }
        if (this.squelchMessage(elt, message)) {
            return;
        }
        if (this.respectAnnotations()) {
            for (Element check = elt; check != null; check = check.getEnclosingElement()) {
                if (check.getAnnotation(SkipInterfaceValidation.class) == null) continue;
                return;
            }
        }
        this.poisoned = true;
        if (elt == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, message);
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, message, elt);
        }
    }

    public void requireMapping(TypeElement interfaceElement) {
        this.typesRequiringMapping.add(interfaceElement);
    }

    public void setClientOnly(boolean clientOnly) {
        this.clientOnly = clientOnly;
    }

    public void setMustResolveAllMappings(boolean requireAllMappings) {
        this.requireAllMappings = requireAllMappings;
    }

    public void warn(Element elt, String message) {
        if (this.suppressWarnings) {
            return;
        }
        if (this.squelchMessage(elt, message)) {
            return;
        }
        if (this.respectAnnotations()) {
            for (Element check = elt; check != null; check = check.getEnclosingElement()) {
                if (check.getAnnotation(SkipInterfaceValidation.class) != null) {
                    return;
                }
                SuppressWarnings suppress = check.getAnnotation(SuppressWarnings.class);
                if (suppress == null || !Arrays.asList(suppress.value()).contains("requestfactory")) continue;
                return;
            }
        }
        String string = String.valueOf(message);
        String string2 = String.valueOf(Messages.warnSuffix());
        this.messager.printMessage(Diagnostic.Kind.WARNING, string2.length() != 0 ? string.concat(string2) : new String(string), elt);
    }

    boolean respectAnnotations() {
        return true;
    }

    private boolean fastFail(TypeElement element) {
        return !this.seen.add(element);
    }

    private DeclaredType findType(String simpleName) {
        String string = String.valueOf(simpleName);
        TypeElement element = this.elements.getTypeElement(string.length() != 0 ? "com.google.web.bindery.requestfactory.shared.".concat(string) : new String("com.google.web.bindery.requestfactory.shared."));
        if (element == null) {
            this.poison(null, "Unable to find RequestFactory built-in type. Is requestfactory-[client|server].jar on the classpath?");
            return null;
        }
        return this.types.getDeclaredType(element, new TypeMirror[0]);
    }

    private boolean squelchMessage(Element elt, String message) {
        Set<String> set = this.previousMessages.get(elt);
        if (set == null) {
            set = new HashSet<String>();
            this.previousMessages.put(elt, set);
        }
        return !set.add(message);
    }

    private static class Job
    implements Comparable<Job> {
        private static long count;
        public final TypeElement element;
        public final ScannerBase<?> scanner;
        private final long order = count++;
        private final int priority;

        public Job(TypeElement element, ScannerBase<?> scanner, int priority) {
            this.element = element;
            this.priority = priority;
            this.scanner = scanner;
        }

        @Override
        public int compareTo(Job o) {
            int c = this.priority - o.priority;
            if (c != 0) {
                return c;
            }
            return Long.signum(this.order - o.order);
        }

        public String toString() {
            String string = String.valueOf(this.scanner.getClass().getSimpleName());
            String string2 = String.valueOf(this.element.getSimpleName());
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" ").append(string2).toString();
        }
    }

    static class ForTesting
    extends State {
        public ForTesting(ProcessingEnvironment processingEnv) {
            super(processingEnv);
        }

        @Override
        boolean respectAnnotations() {
            return false;
        }
    }
}

