/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rg;

import com.google.gwt.core.ext.typeinfo.JClassType;

public enum CssObfuscationStyle {
    VERBOSE(true, false, true, true),
    DEBUG(true, false, true, false),
    STABLE_FULL_CLASSNAME(true, true, true, true),
    STABLE_SHORT_CLASSNAME(true, true, true, false),
    STABLE_NO_CLASSNAME(true, true, false, false),
    OBFUSCATED(false, false, false, false);

    private boolean isPretty;
    private boolean isStable;
    private boolean showClassName;
    private boolean showPackageName;

    static CssObfuscationStyle getObfuscationStyle(String name) {
        if (name.equalsIgnoreCase("pretty")) {
            return VERBOSE;
        }
        if (name.equalsIgnoreCase("debug")) {
            return DEBUG;
        }
        if (name.equalsIgnoreCase("stable")) {
            return STABLE_FULL_CLASSNAME;
        }
        if (name.equalsIgnoreCase("stable-shorttype")) {
            return STABLE_SHORT_CLASSNAME;
        }
        if (name.equalsIgnoreCase("stable-notype")) {
            return STABLE_NO_CLASSNAME;
        }
        return OBFUSCATED;
    }

    private CssObfuscationStyle(boolean isPretty, boolean isStable, boolean showClassName, boolean showPackageName) {
        this.isPretty = isPretty;
        this.isStable = isStable;
        this.showClassName = showClassName;
        this.showPackageName = showPackageName;
    }

    public String getPrettyName(String method, JClassType type, String obfuscatedName) {
        if (!this.isPretty()) {
            return obfuscatedName;
        }
        String toReturn = method;
        if (this.showClassName) {
            toReturn = this.showPackageName ? CssObfuscationStyle.getPrettyCssClass(type.getQualifiedSourceName(), toReturn) : CssObfuscationStyle.getPrettyCssClass(type.getName(), toReturn);
        }
        if (!this.isStable) {
            String string = String.valueOf(obfuscatedName);
            String string2 = toReturn;
            toReturn = obfuscatedName = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("-").append(string2).toString();
        }
        return toReturn;
    }

    public boolean isPretty() {
        return this.isPretty;
    }

    private static String getPrettyCssClass(String typeName, String cssClass) {
        String string = String.valueOf(typeName.replaceAll("[.$]", "-"));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(cssClass).length()).append(string).append("-").append(cssClass).toString();
    }
}

