/*
 * Copyright 2017-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.cloud.spring.autoconfigure.firestore;

import com.google.cloud.spring.data.firestore.repository.config.EnableReactiveFirestoreRepositories;
import com.google.cloud.spring.data.firestore.repository.config.FirestoreRepositoryConfigurationExtension;
import java.lang.annotation.Annotation;
import org.springframework.boot.autoconfigure.data.AbstractRepositoryConfigurationSourceSupport;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;

/**
 * Support configuration class for Firestore repositories.
 *
 * @since 1.2
 */
public class FirestoreRepositoriesAutoConfigureRegistrar
    extends AbstractRepositoryConfigurationSourceSupport {

  @Override
  protected Class<? extends Annotation> getAnnotation() {
    return EnableReactiveFirestoreRepositories.class;
  }

  @Override
  protected Class<?> getConfiguration() {
    return EnableFirestoreRepositoriesConfiguration.class;
  }

  @Override
  protected RepositoryConfigurationExtension getRepositoryConfigurationExtension() {
    return new FirestoreRepositoryConfigurationExtension();
  }

  @EnableReactiveFirestoreRepositories
  private static class EnableFirestoreRepositoriesConfiguration {}
}
