/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamResponse;
import com.google.cloud.bigquery.storage.v1.stub.EnhancedBigQueryReadStub;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class BigQueryReadClient
implements BackgroundResource {
    private final BigQueryReadSettings settings;
    private final EnhancedBigQueryReadStub stub;

    public static final BigQueryReadClient create() throws IOException {
        return BigQueryReadClient.create(BigQueryReadSettings.newBuilder().build());
    }

    public static final BigQueryReadClient create(BigQueryReadSettings settings) throws IOException {
        return new BigQueryReadClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BigQueryReadClient create(EnhancedBigQueryReadStub stub) {
        return new BigQueryReadClient(stub);
    }

    protected BigQueryReadClient(BigQueryReadSettings settings) throws IOException {
        this.settings = settings;
        this.stub = EnhancedBigQueryReadStub.create(settings.getTypedStubSettings(), settings.getReadRowsRetryAttemptListener(), settings.isOpenTelemetryEnabled(), settings.getOpenTelemetryTracerProvider());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BigQueryReadClient(EnhancedBigQueryReadStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BigQueryReadSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public EnhancedBigQueryReadStub getStub() {
        return this.stub;
    }

    public final ReadSession createReadSession(String parent, ReadSession readSession, int maxStreamCount) {
        CreateReadSessionRequest request = CreateReadSessionRequest.newBuilder().setParent(parent).setReadSession(readSession).setMaxStreamCount(maxStreamCount).build();
        return this.createReadSession(request);
    }

    public final ReadSession createReadSession(CreateReadSessionRequest request) {
        Span createReadSession = null;
        if (this.settings.isOpenTelemetryEnabled()) {
            createReadSession = this.settings.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.storage.v1.read.createReadSession").setAttribute("bq.storage.read_session.request.parent", BigQueryReadClient.getFieldAsString(request.getParent())).setAttribute("bq.storage.read_session.request.max_stream_count", (long)request.getMaxStreamCount()).setAttribute("bq.storage.read_session.request.preferred_min_stream_count", (long)request.getPreferredMinStreamCount()).setAttribute("bq.storage.read_session.request.serialized_size", (long)request.getSerializedSize()).setAllAttributes(this.otelAttributesFrom(request.getReadSession())).startSpan();
        }
        try {
            ReadSession readSession;
            block11: {
                Scope createReadSessionScope = createReadSession != null ? createReadSession.makeCurrent() : null;
                try {
                    readSession = (ReadSession)this.createReadSessionCallable().call((Object)request);
                    if (createReadSessionScope == null) break block11;
                }
                catch (Throwable throwable) {
                    if (createReadSessionScope != null) {
                        try {
                            createReadSessionScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                createReadSessionScope.close();
            }
            return readSession;
        }
        finally {
            if (createReadSession != null) {
                createReadSession.end();
            }
        }
    }

    public final UnaryCallable<CreateReadSessionRequest, ReadSession> createReadSessionCallable() {
        Span createReadSessionCallable = null;
        if (this.settings.isOpenTelemetryEnabled()) {
            createReadSessionCallable = this.settings.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.storage.v1.read.createReadSessionCallable").startSpan();
        }
        try {
            UnaryCallable<CreateReadSessionRequest, ReadSession> unaryCallable;
            block11: {
                Scope createReadSessionCallableScope = createReadSessionCallable != null ? createReadSessionCallable.makeCurrent() : null;
                try {
                    unaryCallable = this.stub.createReadSessionCallable();
                    if (createReadSessionCallableScope == null) break block11;
                }
                catch (Throwable throwable) {
                    if (createReadSessionCallableScope != null) {
                        try {
                            createReadSessionCallableScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                createReadSessionCallableScope.close();
            }
            return unaryCallable;
        }
        finally {
            if (createReadSessionCallable != null) {
                createReadSessionCallable.end();
            }
        }
    }

    public final ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable() {
        Span readRowsCallable = null;
        if (this.settings.isOpenTelemetryEnabled()) {
            readRowsCallable = this.settings.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.storage.v1.read.readRowsCallable").startSpan();
        }
        try {
            ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> serverStreamingCallable;
            block11: {
                Scope readRowsCallableScope = readRowsCallable != null ? readRowsCallable.makeCurrent() : null;
                try {
                    serverStreamingCallable = this.stub.readRowsCallable();
                    if (readRowsCallableScope == null) break block11;
                }
                catch (Throwable throwable) {
                    if (readRowsCallableScope != null) {
                        try {
                            readRowsCallableScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                readRowsCallableScope.close();
            }
            return serverStreamingCallable;
        }
        finally {
            if (readRowsCallable != null) {
                readRowsCallable.end();
            }
        }
    }

    public final SplitReadStreamResponse splitReadStream(SplitReadStreamRequest request) {
        Span splitReadStream = null;
        if (this.settings.isOpenTelemetryEnabled()) {
            splitReadStream = this.settings.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.storage.v1.read.splitReadStream").setAllAttributes(this.otelAttributesFrom(request)).startSpan();
        }
        try {
            SplitReadStreamResponse splitReadStreamResponse;
            block11: {
                Scope splitReadStreamScope = splitReadStream != null ? splitReadStream.makeCurrent() : null;
                try {
                    splitReadStreamResponse = (SplitReadStreamResponse)this.splitReadStreamCallable().call((Object)request);
                    if (splitReadStreamScope == null) break block11;
                }
                catch (Throwable throwable) {
                    if (splitReadStreamScope != null) {
                        try {
                            splitReadStreamScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                splitReadStreamScope.close();
            }
            return splitReadStreamResponse;
        }
        finally {
            if (splitReadStream != null) {
                splitReadStream.end();
            }
        }
    }

    public final UnaryCallable<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamCallable() {
        Span splitReadStreamCallable = null;
        if (this.settings.isOpenTelemetryEnabled()) {
            splitReadStreamCallable = this.settings.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.storage.v1.read.splitReadStreamCallable").startSpan();
        }
        try {
            UnaryCallable<SplitReadStreamRequest, SplitReadStreamResponse> unaryCallable;
            block11: {
                Scope readRowsCallableScope = splitReadStreamCallable != null ? splitReadStreamCallable.makeCurrent() : null;
                try {
                    unaryCallable = this.stub.splitReadStreamCallable();
                    if (readRowsCallableScope == null) break block11;
                }
                catch (Throwable throwable) {
                    if (readRowsCallableScope != null) {
                        try {
                            readRowsCallableScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                readRowsCallableScope.close();
            }
            return unaryCallable;
        }
        finally {
            if (splitReadStreamCallable != null) {
                splitReadStreamCallable.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Span close = null;
        if (this.settings.isOpenTelemetryEnabled()) {
            close = this.settings.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.storage.v1.read.close").startSpan();
        }
        try (Scope closeScope = close != null ? close.makeCurrent() : null;){
            this.stub.close();
        }
        finally {
            if (close != null) {
                close.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Span shutdown = null;
        if (this.settings.isOpenTelemetryEnabled()) {
            shutdown = this.settings.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.storage.v1.read.shutdown").startSpan();
        }
        try (Scope shutdownScope = shutdown != null ? shutdown.makeCurrent() : null;){
            this.stub.shutdown();
        }
        finally {
            if (shutdown != null) {
                shutdown.end();
            }
        }
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        Span shutdownNow = null;
        if (this.settings.isOpenTelemetryEnabled()) {
            shutdownNow = this.settings.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.storage.v1.read.shutdownNow").startSpan();
        }
        try (Scope shutdownNowScope = shutdownNow != null ? shutdownNow.makeCurrent() : null;){
            this.stub.shutdownNow();
        }
        finally {
            if (shutdownNow != null) {
                shutdownNow.end();
            }
        }
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        Span awaitTermination = null;
        if (this.settings.isOpenTelemetryEnabled()) {
            awaitTermination = this.settings.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.storage.v1.read.awaitTermination").setAttribute("duration", duration).setAttribute("unit", unit.toString()).startSpan();
        }
        try {
            boolean bl;
            block11: {
                Scope awaitTerminationScope = awaitTermination != null ? awaitTermination.makeCurrent() : null;
                try {
                    bl = this.stub.awaitTermination(duration, unit);
                    if (awaitTerminationScope == null) break block11;
                }
                catch (Throwable throwable) {
                    if (awaitTerminationScope != null) {
                        try {
                            awaitTerminationScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                awaitTerminationScope.close();
            }
            return bl;
        }
        finally {
            if (awaitTermination != null) {
                awaitTermination.end();
            }
        }
    }

    public void disableOpenTelemetryTracing() {
        this.settings.setEnableOpenTelemetryTracing(false, null);
    }

    public void enableDefaultOpenTelemetryTracing() {
        this.settings.setEnableOpenTelemetryTracing(true, null);
    }

    public void enableOpenTelemetryTracing(TracerProvider tracerProvider) {
        this.settings.setEnableOpenTelemetryTracing(true, tracerProvider);
    }

    private static String getFieldAsString(Object field) {
        return field == null ? "null" : field.toString();
    }

    private Attributes otelAttributesFrom(ReadSession readSession) {
        return Attributes.builder().put("bq.storage.read_session.name", BigQueryReadClient.getFieldAsString(readSession.getName())).put("bq.storage.read_session.data_format_value", BigQueryReadClient.getFieldAsString(readSession.getDataFormatValue())).put("bq.storage.read_session.serialized_size", BigQueryReadClient.getFieldAsString(readSession.getSerializedSize())).put("bq.storage.read_session.table", BigQueryReadClient.getFieldAsString(readSession.getTable())).put("bq.storage.read_session.estimated_row_count", readSession.getEstimatedRowCount()).put("bq.storage.read_session.estimated_total_bytes_scanned", readSession.getEstimatedTotalBytesScanned()).put("bq.storage.read_session.estimated_total_physical_bytes", readSession.getEstimatedTotalPhysicalFileSize()).put("bq.storage.read_session.streams_count", (long)readSession.getStreamsCount()).put("bq.storage.read_session.trace_id", BigQueryReadClient.getFieldAsString(readSession.getTraceId())).put("bq.storage.read_session.expire_time", BigQueryReadClient.getFieldAsString(readSession.getExpireTime())).build();
    }

    private Attributes otelAttributesFrom(SplitReadStreamRequest request) {
        return Attributes.builder().put("bq.storage.split_read_stream_request.name", BigQueryReadClient.getFieldAsString(request.getName())).put("bq.storage.split_read_stream_request.serialized_size", BigQueryReadClient.getFieldAsString(request.getSerializedSize())).put("bq.storage.split_read_stream_request.fraction", BigQueryReadClient.getFieldAsString(request.getFraction())).build();
    }
}

