/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.QueueXml;
import java.io.InputStream;
import java.util.Stack;
import org.mortbay.xml.XmlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueXmlReader
extends AbstractConfigXmlReader<QueueXml> {
    private static final String FILENAME = "WEB-INF/queue.xml";
    private static final String TOTAL_STORAGE_LIMIT_TAG = "total-storage-limit";
    private static final String QUEUEENTRIES_TAG = "queue-entries";
    private static final String QUEUE_TAG = "queue";
    private static final String NAME_TAG = "name";
    private static final String RATE_TAG = "rate";
    private static final String BUCKET_SIZE = "bucket-size";
    private static final String MAX_CONCURRENT_REQUESTS = "max-concurrent-requests";
    private static final String RETRY_PARAMETERS_TAG = "retry-parameters";
    private static final String TASK_RETRY_LIMIT_TAG = "task-retry-limit";
    private static final String TASK_AGE_LIMIT_TAG = "task-age-limit";
    private static final String MIN_BACKOFF_SECONDS_TAG = "min-backoff-seconds";
    private static final String MAX_BACKOFF_SECONDS_TAG = "max-backoff-seconds";
    private static final String MAX_DOUBLINGS_TAG = "max-doublings";

    public QueueXmlReader(String appDir) {
        super(appDir, false);
    }

    public QueueXml readQueueXml() {
        return (QueueXml)this.readConfigXml();
    }

    @Override
    protected QueueXml processXml(InputStream is) {
        final QueueXml queueXml = new QueueXml();
        this.parse(new AbstractConfigXmlReader.ParserCallback(){
            boolean firstQueueEntriesTag = true;
            boolean firstTotalStorageLimitTag = true;
            QueueXml.Entry entry;

            @Override
            public void newNode(XmlParser.Node node, Stack<XmlParser.Node> ancestors) {
                switch (ancestors.size()) {
                    case 0: {
                        if (!QueueXmlReader.QUEUEENTRIES_TAG.equalsIgnoreCase(node.getTag())) break;
                        if (!this.firstQueueEntriesTag) {
                            throw new AppEngineConfigException(QueueXmlReader.this.getFilename() + " contains multiple <" + QueueXmlReader.QUEUEENTRIES_TAG + ">");
                        }
                        this.firstQueueEntriesTag = false;
                        break;
                    }
                    case 1: {
                        if (this.firstQueueEntriesTag) {
                            throw new AppEngineConfigException(QueueXmlReader.this.getFilename() + " does not contain <" + QueueXmlReader.QUEUEENTRIES_TAG + ">");
                        }
                        if (QueueXmlReader.TOTAL_STORAGE_LIMIT_TAG.equalsIgnoreCase(node.getTag())) {
                            if (!this.firstTotalStorageLimitTag) {
                                throw new AppEngineConfigException(QueueXmlReader.this.getFilename() + " contains multiple <" + QueueXmlReader.TOTAL_STORAGE_LIMIT_TAG + ">");
                            }
                            if (node.size() != 1 || !(node.get(0) instanceof String)) {
                                throw new AppEngineConfigException(QueueXmlReader.this.getFilename() + "has invalid <" + QueueXmlReader.TOTAL_STORAGE_LIMIT_TAG + ">");
                            }
                            queueXml.setTotalStorageLimit(QueueXmlReader.this.getString(node));
                            this.firstTotalStorageLimitTag = false;
                            break;
                        }
                        if (QueueXmlReader.QUEUE_TAG.equalsIgnoreCase(node.getTag())) {
                            this.entry = queueXml.addNewEntry();
                            break;
                        }
                        throw new AppEngineConfigException(QueueXmlReader.this.getFilename() + " contains <" + node.getTag() + "> instead of <" + QueueXmlReader.QUEUE_TAG + "/> or <" + QueueXmlReader.TOTAL_STORAGE_LIMIT_TAG + ">");
                    }
                    case 2: {
                        assert (this.entry != null);
                        if (QueueXmlReader.NAME_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setName(QueueXmlReader.this.getString(node));
                                break;
                            }
                            throw new AppEngineConfigException(QueueXmlReader.this.getFilename() + " has bad contents in <" + QueueXmlReader.NAME_TAG + ">");
                        }
                        if (QueueXmlReader.BUCKET_SIZE.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setBucketSize(QueueXmlReader.this.getString(node));
                                break;
                            }
                            throw new AppEngineConfigException(QueueXmlReader.this.getFilename() + " has bad contents in <" + QueueXmlReader.BUCKET_SIZE + ">");
                        }
                        if (QueueXmlReader.RATE_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setRate(QueueXmlReader.this.getString(node));
                                break;
                            }
                            throw new AppEngineConfigException(QueueXmlReader.this.getFilename() + " has bad contents in <" + QueueXmlReader.RATE_TAG + ">");
                        }
                        if (QueueXmlReader.MAX_CONCURRENT_REQUESTS.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setMaxConcurrentRequests(QueueXmlReader.this.getString(node));
                                break;
                            }
                            throw new AppEngineConfigException(QueueXmlReader.this.getFilename() + " has bad contents in <" + QueueXmlReader.MAX_CONCURRENT_REQUESTS + ">");
                        }
                        if (QueueXmlReader.RETRY_PARAMETERS_TAG.equalsIgnoreCase(node.getTag())) {
                            this.entry.setRetryParameters(new QueueXml.RetryParameters());
                            break;
                        }
                        throw new AppEngineConfigException(QueueXmlReader.this.getFilename() + " contains unknown <" + node.getTag() + "> inside <" + QueueXmlReader.QUEUE_TAG + "/>");
                    }
                    case 3: {
                        boolean brokenTag;
                        assert (this.entry != null && this.entry.getRetryParameters() != null);
                        QueueXml.RetryParameters retryParameters = this.entry.getRetryParameters();
                        boolean bl = brokenTag = node.size() != 1 || !(node.get(0) instanceof String);
                        if (QueueXmlReader.TASK_RETRY_LIMIT_TAG.equalsIgnoreCase(node.getTag())) {
                            if (!brokenTag) {
                                retryParameters.setRetryLimit(QueueXmlReader.this.getString(node));
                            }
                        } else if (QueueXmlReader.TASK_AGE_LIMIT_TAG.equalsIgnoreCase(node.getTag())) {
                            if (!brokenTag) {
                                retryParameters.setAgeLimitSec(QueueXmlReader.this.getString(node));
                            }
                        } else if (QueueXmlReader.MIN_BACKOFF_SECONDS_TAG.equalsIgnoreCase(node.getTag())) {
                            if (!brokenTag) {
                                retryParameters.setMinBackoffSec(QueueXmlReader.this.getString(node));
                            }
                        } else if (QueueXmlReader.MAX_BACKOFF_SECONDS_TAG.equalsIgnoreCase(node.getTag())) {
                            if (!brokenTag) {
                                retryParameters.setMaxBackoffSec(QueueXmlReader.this.getString(node));
                            }
                        } else if (QueueXmlReader.MAX_DOUBLINGS_TAG.equalsIgnoreCase(node.getTag())) {
                            if (!brokenTag) {
                                retryParameters.setMaxDoublings(QueueXmlReader.this.getString(node));
                            }
                        } else {
                            throw new AppEngineConfigException(QueueXmlReader.this.getFilename() + " contains unknown <" + node.getTag() + "> inside <" + QueueXmlReader.RETRY_PARAMETERS_TAG + "/>");
                        }
                        if (!brokenTag) break;
                        throw new AppEngineConfigException(QueueXmlReader.this.getFilename() + " has bad contents in <" + node.getTag() + ">");
                    }
                    default: {
                        throw new AppEngineConfigException(QueueXmlReader.this.getFilename() + " has a syntax error; node <" + node.getTag() + "> is too deeply nested to be valid.");
                    }
                }
            }
        }, is);
        queueXml.validateLastEntry();
        return queueXml;
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }
}

